/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.impl;

import javax.inject.Named;
import javax.inject.Singleton;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.AbstractRepository;
import org.b3log.latke.repository.FilterOperator;
import org.b3log.latke.repository.PropertyFilter;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.RepositoryException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Named(value="LakteBuiltInUserRepository")
@Singleton
public class UserRepository
extends AbstractRepository {
    private static final Logger LOGGER = Logger.getLogger(UserRepository.class.getName());

    public UserRepository() {
        super("LakteBuiltInUserRepository");
    }

    public JSONObject getByEmail(String email) {
        Query query = new Query();
        query.setFilter(new PropertyFilter("userEmail", FilterOperator.EQUAL, email.toLowerCase().trim()));
        try {
            JSONObject result = this.get(query);
            JSONArray array = result.getJSONArray("rslts");
            if (0 == array.length()) {
                return null;
            }
            return array.getJSONObject(0);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), e);
            return null;
        }
    }

    public JSONObject getAdmin() {
        Query query = new Query();
        query.setFilter(new PropertyFilter("userRole", FilterOperator.EQUAL, "adminRole"));
        try {
            JSONObject result = this.get(query);
            JSONArray array = result.getJSONArray("rslts");
            if (0 == array.length()) {
                return null;
            }
            return array.getJSONObject(0);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), e);
            return null;
        }
    }

    public boolean isAdminEmail(String email) throws RepositoryException {
        JSONObject user = this.getByEmail(email);
        if (null == user) {
            return false;
        }
        try {
            return "adminRole".equals(user.getString("userRole"));
        }
        catch (JSONException e) {
            LOGGER.log(Level.ERROR, e.getMessage(), e);
            throw new RepositoryException(e);
        }
    }
}

