/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.Projection;
import org.b3log.latke.repository.SortDirection;

public final class Query {
    private int currentPageNum = 1;
    private Integer pageCount;
    private int pageSize = Integer.MAX_VALUE;
    private Map<String, SortDirection> sorts = new LinkedHashMap<String, SortDirection>();
    private Filter filter;
    private Set<Projection> projections = new HashSet<Projection>();
    private Set<String[]> indexes = new HashSet<String[]>();
    private static final int INIT_HASH = 5;
    private static final int BASE = 83;

    public Query addProjection(String propertyName, Class<?> valueType) {
        this.projections.add(new Projection(propertyName, valueType));
        return this;
    }

    public Set<Projection> getProjections() {
        return Collections.unmodifiableSet(this.projections);
    }

    public Query index(String ... properties) {
        if (null == properties || 0 == properties.length) {
            return this;
        }
        this.indexes.add(properties);
        return this;
    }

    public Set<String[]> getIndexes() {
        return Collections.unmodifiableSet(this.indexes);
    }

    public Query addSort(String propertyName, SortDirection sortDirection) {
        this.sorts.put(propertyName, sortDirection);
        return this;
    }

    public Query setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public int getCurrentPageNum() {
        return this.currentPageNum;
    }

    public Query setCurrentPageNum(int currentPageNum) {
        this.currentPageNum = currentPageNum;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Query setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Map<String, SortDirection> getSorts() {
        return Collections.unmodifiableMap(this.sorts);
    }

    public Integer getPageCount() {
        return this.pageCount;
    }

    public Query setPageCount(int pageCount) {
        this.pageCount = pageCount;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Query other = (Query)obj;
        if (this.currentPageNum != other.currentPageNum) {
            return false;
        }
        if (this.pageSize != other.pageSize) {
            return false;
        }
        if (!(this.sorts == other.sorts || this.sorts != null && this.sorts.equals(other.sorts))) {
            return false;
        }
        if (!(this.filter == other.filter || this.filter != null && this.filter.equals(other.filter))) {
            return false;
        }
        return this.projections == other.projections || this.projections != null && this.projections.equals(other.projections);
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + this.currentPageNum;
        hash = 83 * hash + this.pageSize;
        hash = 83 * hash + (this.sorts != null ? this.sorts.hashCode() : 0);
        hash = 83 * hash + (this.filter != null ? this.filter.hashCode() : 0);
        hash = 83 * hash + (this.projections != null ? this.projections.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("currentPageNum=").append(this.currentPageNum).append(", pageSize=").append(this.pageSize).append(", pageCount=").append(this.pageCount).append(", sorts=[");
        Set<Map.Entry<String, SortDirection>> entrySet = this.sorts.entrySet();
        Iterator<Map.Entry<String, SortDirection>> sortsIterator = entrySet.iterator();
        while (sortsIterator.hasNext()) {
            Map.Entry<String, SortDirection> sort = sortsIterator.next();
            stringBuilder.append("[key=").append(sort.getKey()).append(", direction=").append(sort.getValue().name()).append("]");
            if (!sortsIterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        if (null != this.filter) {
            stringBuilder.append(", filter=[").append(this.filter.toString()).append("]");
        }
        stringBuilder.append(", projections=[");
        Iterator<Projection> projectionsIterator = this.projections.iterator();
        while (projectionsIterator.hasNext()) {
            Projection projection = projectionsIterator.next();
            stringBuilder.append('[').append(projection.toString()).append(']');
            if (!projectionsIterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

