/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.remote;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URLDecoder;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.b3log.latke.Latkes;
import org.b3log.latke.RuntimeEnv;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.AbstractRepository;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.Repositories;
import org.b3log.latke.repository.Repository;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.repository.jdbc.util.JdbcRepositories;
import org.b3log.latke.servlet.HTTPRequestContext;
import org.b3log.latke.servlet.HTTPRequestMethod;
import org.b3log.latke.servlet.annotation.RequestProcessing;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.servlet.renderer.JSONRenderer;
import org.b3log.latke.util.Strings;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@RequestProcessor
public class RepositoryAccessor {
    private static final Logger LOGGER = Logger.getLogger(RepositoryAccessor.class.getName());

    @RequestProcessing(value={"/latke/remote/repositories/writable"}, method={HTTPRequestMethod.GET})
    public void getRepositoriesWritable(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) {
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer(renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        if (!this.authSucc(request, jsonObject)) {
            return;
        }
        boolean writable = Repositories.getReposirotiesWritable();
        jsonObject.put("sc", 200);
        jsonObject.put("msg", "Gets repositories writable[" + writable + "]");
        jsonObject.put("writable", writable);
    }

    @RequestProcessing(value={"/latke/remote/repositories/writable"}, method={HTTPRequestMethod.PUT})
    public void setRepositoriesWritable(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) {
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer(renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        String writable = request.getParameter("writable");
        if (!"true".equals(writable) && !"false".equals(writable)) {
            jsonObject.put("sc", 400);
            jsonObject.put("msg", "Requires parameter[writable], optional value is [true] or [false]");
            return;
        }
        if (!this.authSucc(request, jsonObject)) {
            return;
        }
        Repositories.setRepositoriesWritable(Boolean.parseBoolean(writable));
        jsonObject.put("sc", 200);
        jsonObject.put("msg", "Sets repositories writable[" + writable + "]");
    }

    @RequestProcessing(value={"/latke/remote/repository/names"}, method={HTTPRequestMethod.GET})
    public void getRepositoryNames(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) {
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer(renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        jsonObject.put("sc", 200);
        jsonObject.put("msg", "Got data");
        if (!this.authSucc(request, jsonObject)) {
            return;
        }
        jsonObject.put("repositoryNames", Repositories.getRepositoryNames());
    }

    @RequestProcessing(value={"/latke/remote/repository/data"}, method={HTTPRequestMethod.GET})
    public void getData(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) {
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer(renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        jsonObject.put("sc", 200);
        jsonObject.put("msg", "Got data");
        if (this.badGetDataRequest(request, jsonObject) || !this.authSucc(request, jsonObject)) {
            return;
        }
        String repositoryName = request.getParameter("repositoryName");
        Repository repository = Repositories.getRepository(repositoryName);
        if (null == repository) {
            jsonObject.put("sc", 400);
            jsonObject.put("msg", "Not found repository[name=" + repositoryName + "]");
            return;
        }
        Query query = new Query().setCurrentPageNum(Integer.valueOf(request.getParameter("pageNum"))).setPageSize(Integer.valueOf(request.getParameter("pageSize")));
        try {
            JSONObject result = repository.get(query);
            JSONObject pagination = result.getJSONObject("pagination");
            JSONArray data = result.getJSONArray("rslts");
            jsonObject.put("pagination", pagination);
            jsonObject.put("rslts", data);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Gets data failed", e);
            jsonObject.put("sc", 500);
            jsonObject.put("msg", "Gets data failed[errorMsg=" + e.getMessage() + "]");
        }
    }

    @RequestProcessing(value={"/latke/remote/repository/data"}, method={HTTPRequestMethod.POST})
    public void putData(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) {
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer(renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        jsonObject.put("sc", 200);
        jsonObject.put("msg", "Put data");
        StringBuilder dataBuilder = new StringBuilder();
        if (this.badPutDataRequest(request, jsonObject, dataBuilder) || !this.authSucc(request, jsonObject)) {
            return;
        }
        String repositoryName = request.getParameter("repositoryName");
        Repository repository = Repositories.getRepository(repositoryName);
        if (null == repository) {
            String tableNamePrefix = StringUtils.isNotBlank((String)Latkes.getLocalProperty("jdbc.tablePrefix")) ? Latkes.getLocalProperty("jdbc.tablePrefix") + "_" : "";
            String withoutTablePrefix = StringUtils.substringAfter((String)repositoryName, (String)tableNamePrefix);
            repository = new AbstractRepository(withoutTablePrefix){};
        }
        Transaction transaction = repository.beginTransaction();
        try {
            String dataContent = dataBuilder.toString();
            JSONArray data = new JSONArray(dataContent);
            for (int i = 0; i < data.length(); ++i) {
                JSONObject record = data.getJSONObject(i);
                JSONArray keysDescription = Repositories.getRepositoryKeysDescription(repositoryName);
                for (int j = 0; j < keysDescription.length(); ++j) {
                    JSONObject keyDescription = keysDescription.optJSONObject(j);
                    String key = keyDescription.optString("name");
                    String type = keyDescription.optString("type");
                    if ("Date".equals(type)) {
                        Locale defaultLocale = Locale.getDefault();
                        Locale.setDefault(Locale.US);
                        record.put(key, DateUtils.parseDate((String)record.optString(key), (String[])new String[]{"EEE MMM dd HH:mm:ss z yyyy", "EEE MMM d HH:mm:ss z yyyy", "yyyy-MM-dd HH:mm:ss.SSS"}));
                        Locale.setDefault(defaultLocale);
                    }
                    if (!"String".equals(type)) continue;
                    int length = keyDescription.optInt("length");
                    String value = record.optString(key);
                    if (value.length() <= length) continue;
                    record.put(key, value.substring(0, length));
                }
                repository.add(record);
            }
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            LOGGER.log(Level.ERROR, "Puts data failed", e);
            jsonObject.put("sc", 500);
            jsonObject.put("msg", "Puts data failed[errorMsg=" + e.getMessage() + "]");
        }
    }

    @RequestProcessing(value={"/latke/remote/repository/tables"}, method={HTTPRequestMethod.PUT})
    public void createTables(HTTPRequestContext context, HttpServletRequest request, HttpServletResponse response) {
        JSONRenderer renderer = new JSONRenderer();
        context.setRenderer(renderer);
        JSONObject jsonObject = new JSONObject();
        renderer.setJSONObject(jsonObject);
        jsonObject.put("sc", 200);
        jsonObject.put("msg", "Created tables");
        if (!this.authSucc(request, jsonObject)) {
            return;
        }
        if (RuntimeEnv.GAE == Latkes.getRuntimeEnv()) {
            jsonObject.put("msg", "GAE runtime enviorment dose not need to create tables");
            return;
        }
        JdbcRepositories.initAllTables();
    }

    private boolean authSucc(HttpServletRequest request, JSONObject jsonObject) {
        if (!Latkes.isRemoteEnabled()) {
            jsonObject.put("sc", 501);
            jsonObject.put("msg", "Latke remote interfaces are disabled");
            return false;
        }
        String userName = request.getParameter("userName");
        String password = request.getParameter("password");
        if (Strings.isEmptyOrNull(userName)) {
            jsonObject.put("sc", 400);
            jsonObject.put("msg", "Requires parameter[userName]");
            return false;
        }
        if (Strings.isEmptyOrNull(password)) {
            jsonObject.put("sc", 400);
            jsonObject.put("msg", "Requires parameter[password]");
            return false;
        }
        String repositoryAccessorUserName = Latkes.getRemoteProperty("repositoryAccessor.userName");
        String repositoryAccessorPassword = Latkes.getRemoteProperty("repositoryAccessor.password");
        if (userName.equals(repositoryAccessorUserName) && password.equals(repositoryAccessorPassword)) {
            return true;
        }
        jsonObject.put("sc", 403);
        jsonObject.put("msg", "Auth failed[userName=" + userName + ", password=" + password + "]");
        return false;
    }

    private boolean badGetDataRequest(HttpServletRequest request, JSONObject jsonObject) {
        String repositoryName = request.getParameter("repositoryName");
        String pageNumString = request.getParameter("pageNum");
        String pageSizeString = request.getParameter("pageSize");
        if (Strings.isEmptyOrNull(repositoryName)) {
            jsonObject.put("sc", 400);
            jsonObject.put("msg", "Requires parameter[repositoryName]");
            return true;
        }
        if (Strings.isEmptyOrNull(pageNumString)) {
            jsonObject.put("sc", 400);
            jsonObject.put("msg", "Requires parameter[pageNum]");
            return true;
        }
        if (Strings.isEmptyOrNull(pageSizeString)) {
            jsonObject.put("sc", 400);
            jsonObject.put("msg", "Requires parameter[pageSize]");
            return true;
        }
        try {
            Integer.parseInt(pageNumString);
        }
        catch (Exception e) {
            jsonObject.put("sc", 400);
            jsonObject.put("msg", "Parameter[pageNum] must be a integer");
            return true;
        }
        try {
            Integer.parseInt(pageSizeString);
        }
        catch (Exception e) {
            jsonObject.put("sc", 400);
            jsonObject.put("msg", "Parameter[pageSize] must be a integer");
            return true;
        }
        return false;
    }

    private boolean badPutDataRequest(HttpServletRequest request, JSONObject jsonObject, StringBuilder dataBuilder) {
        String repositoryName = request.getParameter("repositoryName");
        if (Strings.isEmptyOrNull(repositoryName)) {
            jsonObject.put("sc", 400);
            jsonObject.put("msg", "Requires parameter[repositoryName]");
            return true;
        }
        String dataContent = request.getParameter("data");
        if (Strings.isEmptyOrNull(dataContent)) {
            try {
                BufferedReader reader = request.getReader();
                dataContent = IOUtils.toString((Reader)reader);
                String str = dataContent.split("=")[1];
                dataContent = URLDecoder.decode(str, "UTF-8");
            }
            catch (IOException e) {
                LOGGER.log(Level.WARN, e.getMessage(), e);
            }
        }
        if (Strings.isEmptyOrNull(dataContent)) {
            jsonObject.put("sc", 400);
            jsonObject.put("msg", "Requires parameter[data]");
            return true;
        }
        try {
            new JSONArray(dataContent);
        }
        catch (JSONException e) {
            jsonObject.put("sc", 400);
            jsonObject.put("msg", "Parameter[data] must be a JSON object or a JSON array");
            return true;
        }
        dataBuilder.append(dataContent);
        return false;
    }
}

