/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.mail.local;

import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.b3log.latke.mail.MailService;
import org.b3log.latke.util.Strings;

final class MailSender {
    private final ResourceBundle mailProperties = ResourceBundle.getBundle("mail");

    MailSender() {
    }

    private Session getSession() {
        Properties props = new Properties();
        props.setProperty("mail.smtp.host", this.mailProperties.getString("mail.smtp.host"));
        String auth = "true";
        if (this.mailProperties.containsKey("mail.smtp.auth")) {
            auth = this.mailProperties.getString("mail.smtp.auth");
        }
        props.setProperty("mail.smtp.auth", auth);
        props.setProperty("mail.smtp.port", this.mailProperties.getString("mail.smtp.port"));
        String starttls = "true";
        if (this.mailProperties.containsKey("mail.smtp.starttls.enable")) {
            starttls = this.mailProperties.getString("mail.smtp.starttls.enable");
        }
        props.put("mail.smtp.starttls.enable", starttls);
        props.put("mail.debug", this.mailProperties.getString("mail.debug"));
        props.put("mail.smtp.socketFactory.class", this.mailProperties.getString("mail.smtp.socketFactory.class"));
        props.put("mail.smtp.socketFactory.fallback", this.mailProperties.getString("mail.smtp.socketFactory.fallback"));
        props.put("mail.smtp.socketFactory.port", this.mailProperties.getString("mail.smtp.socketFactory.port"));
        return Session.getInstance((Properties)props, (Authenticator)new SMTPAuthenticator());
    }

    public Message convert2JavaMailMsg(MailService.Message message) throws Exception {
        if (message == null) {
            return null;
        }
        if (Strings.isEmptyOrNull(message.getFrom())) {
            throw new MessagingException("Null from");
        }
        if (null == message.getRecipients() || message.getRecipients().isEmpty()) {
            throw new MessagingException("Null recipients");
        }
        MimeMessage ret = new MimeMessage(this.getSession());
        ret.setFrom((Address)new InternetAddress(message.getFrom()));
        String subject = message.getSubject();
        ret.setSubject(MimeUtility.encodeText((String)(subject != null ? subject : ""), (String)"UTF-8", (String)"B"));
        String htmlBody = message.getHtmlBody();
        ret.setContent((Object)(htmlBody != null ? htmlBody : ""), "text/html;charset=UTF-8");
        ret.addRecipients(MimeMessage.RecipientType.TO, (Address[])this.transformRecipients(message.getRecipients()));
        return ret;
    }

    private InternetAddress[] transformRecipients(Set<String> recipients) throws MessagingException {
        if (recipients.isEmpty()) {
            throw new MessagingException("recipients of mail should not be empty");
        }
        InternetAddress[] ret = new InternetAddress[recipients.size()];
        int i = 0;
        for (String recipient : recipients) {
            ret[i] = new InternetAddress(recipient);
            ++i;
        }
        return ret;
    }

    void sendMail(MailService.Message message) throws Exception {
        Message msg = this.convert2JavaMailMsg(message);
        Transport.send((Message)msg);
    }

    private class SMTPAuthenticator
    extends Authenticator {
        private SMTPAuthenticator() {
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(MailSender.this.mailProperties.getString("mail.user"), MailSender.this.mailProperties.getString("mail.password"));
        }
    }
}

