/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc.config.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Named;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.bean.BeanImpl;
import org.b3log.latke.ioc.bean.LatkeBean;
import org.b3log.latke.ioc.config.BeanModule;
import org.b3log.latke.ioc.config.Configurator;
import org.b3log.latke.ioc.config.InjectionPointValidator;
import org.b3log.latke.ioc.util.Beans;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.util.Reflections;

public final class ConfiguratorImpl
implements Configurator {
    private static final Logger LOGGER = Logger.getLogger(ConfiguratorImpl.class.getName());
    private LatkeBeanManager beanManager;
    private Set<BeanModule> modules;
    private Map<Type, Set<Class<?>>> typeClasses;
    private Map<Class<?>, Set<Annotation>> classQualifiers;
    private Map<Annotation, Set<Class<?>>> qualifierClasses;

    public ConfiguratorImpl(LatkeBeanManager beanManager) {
        this.beanManager = beanManager;
        this.typeClasses = new HashMap();
        this.classQualifiers = new HashMap();
        this.qualifierClasses = new HashMap();
        this.modules = new HashSet<BeanModule>();
    }

    @Override
    public void addTypeClassBinding(Type beanType, Class<?> beanClass) {
        Set<Class<?>> beanClasses = this.typeClasses.get(beanType);
        if (beanClasses == null) {
            beanClasses = new HashSet();
        }
        beanClasses.add(beanClass);
        this.typeClasses.put(beanType, beanClasses);
    }

    @Override
    public void addQualifierClassBinding(Annotation qualifier, Class<?> beanClass) {
        Set<Class<?>> beanClasses = this.qualifierClasses.get(qualifier);
        if (beanClasses == null) {
            beanClasses = new HashSet();
        }
        beanClasses.add(beanClass);
        this.qualifierClasses.put(qualifier, beanClasses);
    }

    @Override
    public void addClassQualifierBinding(Class<?> beanClass, Annotation qualifier) {
        Set<Annotation> qualifiers = this.classQualifiers.get(beanClass);
        if (null == qualifiers) {
            qualifiers = new HashSet<Annotation>();
        }
        if (qualifier.annotationType().equals(Named.class)) {
            Iterator<Annotation> iterator = qualifiers.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().annotationType().equals(Named.class)) continue;
                iterator.remove();
            }
        }
        qualifiers.add(qualifier);
        this.classQualifiers.put(beanClass, qualifiers);
    }

    @Override
    public Set<Class<?>> getBindedBeanClasses(Type beanType) {
        return this.typeClasses.get(beanType);
    }

    @Override
    public Set<Annotation> getBindedQualifiers(Class<?> beanClass) {
        return this.classQualifiers.get(beanClass);
    }

    @Override
    public void validate() {
        for (Bean bean : this.beanManager.getBeans()) {
            InjectionPointValidator.checkValidity(bean);
            InjectionPointValidator.checkDependency(bean, this);
        }
    }

    @Override
    public <T> LatkeBean<T> createBean(Class<T> beanClass) {
        try {
            return this.beanManager.getBean(beanClass);
        }
        catch (Exception e) {
            LOGGER.log(Level.TRACE, "Not found bean [beanClass={0}], so to create it", beanClass);
            if (!Beans.checkClass(beanClass)) {
                throw new IllegalStateException("Can't create bean for class[" + beanClass.getName() + "] caused by it is an interface or an abstract class, or it dose not implement any interface");
            }
            String name = Beans.getBeanName(beanClass);
            if (null == name) {
                LOGGER.log(Level.DEBUG, "Class[beanClass={0}] can't be created as bean caused by it has no bean name.", beanClass);
                return null;
            }
            Set<Annotation> qualifiers = Beans.getQualifiers(beanClass, name);
            Class<? extends Annotation> scope = Beans.getScope(beanClass);
            Set<Type> beanTypes = Beans.getBeanTypes(beanClass);
            Set<Class<? extends Annotation>> stereotypes = Beans.getStereotypes(beanClass);
            LOGGER.log(Level.DEBUG, "Adding a bean[name={0}, scope={1}, class={2}] to the bean manager....", name, scope.getName(), beanClass.getName());
            BeanImpl<T> ret = new BeanImpl<T>(this.beanManager, name, scope, qualifiers, beanClass, beanTypes, stereotypes);
            this.beanManager.addBean(ret);
            for (Type beanType : beanTypes) {
                this.addTypeClassBinding(beanType, beanClass);
            }
            for (Annotation qualifier : qualifiers) {
                this.addClassQualifierBinding(beanClass, qualifier);
                this.addQualifierClassBinding(qualifier, beanClass);
            }
            return ret;
        }
    }

    @Override
    public void createBeans(Collection<Class<?>> classes) {
        if (null == classes || classes.isEmpty()) {
            return;
        }
        ConfiguratorImpl.filterClasses(classes);
        for (Class<?> clazz : classes) {
            this.createBean(clazz);
        }
    }

    @Override
    public void addModule(BeanModule module) {
        this.modules.add(module);
        Collection<Class<?>> classes = module.getBeanClasses();
        if (null != classes && !classes.isEmpty()) {
            this.createBeans(classes);
        }
        LOGGER.log(Level.DEBUG, "Added a module[name={0}]", module.getName());
    }

    private static void filterClasses(Collection<Class<?>> classes) {
        Iterator<Class<?>> iterator = classes.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz = iterator.next();
            if (!clazz.isAnnotation() && Reflections.isConcrete(clazz)) continue;
            iterator.remove();
        }
    }
}

