/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.b3log.latke.ioc.config.Configurator;
import org.b3log.latke.util.Reflections;

public final class InjectionPointValidator {
    private InjectionPointValidator() {
    }

    public static <T> void checkValidity(Bean<T> bean) {
        Set injectionPoints = bean.getInjectionPoints();
        HashSet<Constructor> constructors = new HashSet<Constructor>();
        for (InjectionPoint injectionPoint : injectionPoints) {
            Member member = injectionPoint.getMember();
            if (!(member instanceof Constructor)) continue;
            constructors.add((Constructor)member);
        }
        if (constructors.size() > 1) {
            throw new RuntimeException("Only one constructor can be injected!");
        }
    }

    public static <T> void checkDependency(Bean<T> bean, Configurator configurator) {
        for (InjectionPoint injectionPoint : bean.getInjectionPoints()) {
            Set<Annotation> bindedQualifiers;
            Type requiredType = injectionPoint.getType();
            Set requiredQualifiers = injectionPoint.getQualifiers();
            if (Reflections.isConcrete(requiredType) && (bindedQualifiers = configurator.getBindedQualifiers((Class)requiredType)).containsAll(requiredQualifiers)) continue;
            Set<Class<?>> bindedBeanClasses = configurator.getBindedBeanClasses(requiredType);
            if (bindedBeanClasses == null) {
                throw new UnsatisfiedResolutionException("Has no eligible bean[type=" + requiredType.toString() + "] for injection point[" + injectionPoint + "]");
            }
            if (bindedBeanClasses.size() == 1) {
                Class<?> eligibleClass = bindedBeanClasses.iterator().next();
                bindedQualifiers = configurator.getBindedQualifiers(eligibleClass);
                if (bindedQualifiers.containsAll(requiredQualifiers)) continue;
                throw new UnsatisfiedResolutionException("Has no eligible bean[type=" + requiredType.toString() + ", qualifiers=]" + requiredQualifiers + "] for injection point[" + injectionPoint + "]");
            }
            if (bindedBeanClasses.size() <= 1) continue;
            HashSet eligibleClasses = new HashSet();
            for (Class<?> beanClass : bindedBeanClasses) {
                bindedQualifiers = configurator.getBindedQualifiers(beanClass);
                if (!bindedQualifiers.containsAll(requiredQualifiers)) continue;
                eligibleClasses.add(beanClass);
            }
            if (eligibleClasses.isEmpty()) {
                throw new UnsatisfiedResolutionException("Has no eligible bean[type=" + requiredType.toString() + ", qualifiers=" + requiredQualifiers + "] for injection point[" + injectionPoint + "]");
            }
            if (eligibleClasses.size() <= 1) continue;
            throw new AmbiguousResolutionException("Has more than one eligible bean[type=" + requiredType.toString() + ", qualifiers=" + requiredQualifiers + "] for injection point[" + injectionPoint + "]");
        }
    }
}

