/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc.config;

import java.io.DataInputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javax.inject.Named;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.annotation.Repository;
import org.b3log.latke.service.annotation.Service;
import org.b3log.latke.servlet.ClassPathResolver;
import org.b3log.latke.servlet.annotation.RequestProcessor;
import org.b3log.latke.util.AntPathMatcher;
import org.b3log.latke.util.ArrayUtils;
import org.b3log.latke.util.Strings;

public final class Discoverer {
    private static final Logger LOGGER = Logger.getLogger(Discoverer.class.getName());
    private static final String[] BUILT_IN_COMPONENT_PKGS = new String[]{"org.b3log.latke.remote"};

    private Discoverer() {
    }

    public static Collection<Class<?>> discover(String scanPath) throws Exception {
        if (Strings.isEmptyOrNull(scanPath)) {
            throw new IllegalStateException("Please specify the [scanPath]");
        }
        LOGGER.debug("scanPath[" + scanPath + "]");
        HashSet ret = new HashSet();
        String[] splitPaths = scanPath.split(",");
        String[] paths = ArrayUtils.concatenate(splitPaths, new String[][]{BUILT_IN_COMPONENT_PKGS});
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        for (String path : paths) {
            if (!AntPathMatcher.isPattern(path)) {
                path = path.replaceAll("\\.", "/") + "/**/*.class";
            }
            urls.addAll(ClassPathResolver.getResources(path));
        }
        for (URL url : urls) {
            DataInputStream classInputStream = new DataInputStream(url.openStream());
            ClassFile classFile = new ClassFile(classInputStream);
            String className = classFile.getName();
            AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
            if (null == annotationsAttribute) {
                LOGGER.log(Level.TRACE, "The class[name={0}] is not a bean", className);
                continue;
            }
            ConstPool constPool = classFile.getConstPool();
            Annotation[] annotations = annotationsAttribute.getAnnotations();
            boolean maybeBeanClass = false;
            for (Annotation annotation : annotations) {
                if (annotation.getTypeName().equals(RequestProcessor.class.getName())) {
                    Annotation singletonAnnotation = new Annotation("javax.inject.Singleton", constPool);
                    annotationsAttribute.addAnnotation(singletonAnnotation);
                    classFile.addAttribute((AttributeInfo)annotationsAttribute);
                    classFile.setVersionToJava5();
                    maybeBeanClass = true;
                    break;
                }
                if (annotation.getTypeName().equals(Service.class.getName()) || annotation.getTypeName().equals(Repository.class.getName())) {
                    maybeBeanClass = true;
                    break;
                }
                if (!annotation.getTypeName().equals(Named.class.getName())) continue;
                maybeBeanClass = true;
                break;
            }
            if (!maybeBeanClass) continue;
            Class<?> clz = null;
            try {
                clz = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException e) {
                LOGGER.log(Level.ERROR, "some error to load the class[" + className + "]", e);
            }
            ret.add(clz);
        }
        return ret;
    }
}

