/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import org.b3log.latke.intercept.annotation.AfterMethod;
import org.b3log.latke.intercept.annotation.BeforeMethod;
import org.b3log.latke.ioc.LatkeBeanManager;
import org.b3log.latke.ioc.bean.Interceptor;
import org.b3log.latke.ioc.bean.InterceptorHolder;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.repository.annotation.Transactional;
import org.b3log.latke.repository.impl.UserRepository;

public final class JavassistMethodHandler
implements MethodHandler {
    private static final Logger LOGGER = Logger.getLogger(JavassistMethodHandler.class.getName());
    private LatkeBeanManager beanManager;
    private MethodFilter methodFilter = new MethodFilter(){

        public boolean isHandled(Method method) {
            String name = method.getName();
            return !"beginTransaction".equals(name) && !"hasTransactionBegun".equals(name);
        }
    };

    public JavassistMethodHandler(LatkeBeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public Object invoke(Object proxy, Method method, Method proceed, Object[] params) throws Throwable {
        LOGGER.trace("Processing invocation: " + method.toString());
        Class<?> declaringClass = method.getDeclaringClass();
        String invokingMehtodName = declaringClass.getName() + '#' + method.getName();
        this.handleInterceptor(invokingMehtodName, params, BeforeMethod.class);
        UserRepository userRepository = this.beanManager.getReference(UserRepository.class);
        boolean withTransactionalAnno = method.isAnnotationPresent(Transactional.class);
        boolean alreadyInTransaction = userRepository.hasTransactionBegun();
        boolean needHandleTrans = withTransactionalAnno && !alreadyInTransaction;
        Transaction transaction = null;
        if (needHandleTrans) {
            transaction = userRepository.beginTransaction();
        }
        Object ret = null;
        try {
            ret = proceed.invoke(proxy, params);
            if (needHandleTrans) {
                transaction.commit();
            }
        }
        catch (InvocationTargetException e) {
            if (needHandleTrans && null != transaction && transaction.isActive()) {
                transaction.rollback();
            }
            throw e.getTargetException();
        }
        this.handleInterceptor(invokingMehtodName, params, AfterMethod.class);
        return ret;
    }

    private void handleInterceptor(String invokingMehtodName, Object[] params, Class<? extends Annotation> interceptAnnClass) {
        Set<Interceptor> interceptors = InterceptorHolder.getInterceptors(invokingMehtodName, interceptAnnClass);
        for (Interceptor interceptor : interceptors) {
            Method interceptMethod = interceptor.getInterceptMethod();
            Class<?> interceptMethodClass = interceptMethod.getDeclaringClass();
            try {
                Object reference = this.beanManager.getReference(interceptMethodClass);
                interceptMethod.invoke(reference, params);
            }
            catch (Exception e) {
                String errMsg = "Interception[" + interceptor.toString() + "] execute failed";
                LOGGER.log(Level.ERROR, errMsg, e);
                throw new RuntimeException(errMsg);
            }
        }
    }

    public MethodFilter getMethodFilter() {
        return this.methodFilter;
    }
}

