/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc.annotated;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import org.b3log.latke.ioc.annotated.AnnotatedParameterImpl;
import org.b3log.latke.util.CollectionUtils;

public abstract class AbstractAnnotatedCallableImpl<T>
implements AnnotatedCallable<T> {
    private Member member;
    private List<AnnotatedParameter<T>> parameters;

    public AbstractAnnotatedCallableImpl(Member member) {
        this.member = member;
        this.parameters = new ArrayList<AnnotatedParameter<T>>();
        Type[] parameterTypes = null;
        Annotation[][] parameterAnnotations = null;
        if (member instanceof Method) {
            parameterTypes = ((Method)member).getGenericParameterTypes();
            parameterAnnotations = ((Method)member).getParameterAnnotations();
        } else if (member instanceof Constructor) {
            parameterTypes = ((Constructor)member).getGenericParameterTypes();
            parameterAnnotations = ((Constructor)member).getParameterAnnotations();
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type parameter = parameterTypes[i];
            Annotation[] annotations = parameterAnnotations[i];
            Set<Annotation> annotationSet = CollectionUtils.arrayToSet(annotations);
            AnnotatedParameterImpl annotatedParameter = new AnnotatedParameterImpl(this, parameter, i, annotationSet);
            this.parameters.add(annotatedParameter);
        }
    }

    public AnnotatedType<T> getDeclaringType() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<AnnotatedParameter<T>> getParameters() {
        return this.parameters;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.member.getModifiers());
    }

    public Member getMember() {
        return this.member;
    }
}

