/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.image;

import org.b3log.latke.Latkes;
import org.b3log.latke.RuntimeEnv;
import org.b3log.latke.image.ImageService;
import org.b3log.latke.logging.Logger;

public final class ImageServiceFactory {
    private static final Logger LOGGER = Logger.getLogger(ImageServiceFactory.class.getName());
    private static final ImageService IMAGE_SERVICE;

    public static ImageService getImageService() {
        return IMAGE_SERVICE;
    }

    private ImageServiceFactory() {
    }

    static {
        LOGGER.info("Constructing Image Service....");
        RuntimeEnv runtimeEnv = Latkes.getRuntimeEnv();
        try {
            Class<?> serviceClass = null;
            switch (runtimeEnv) {
                case LOCAL: {
                    serviceClass = Class.forName("org.b3log.latke.image.local.LocalImageService");
                    IMAGE_SERVICE = (ImageService)serviceClass.newInstance();
                    break;
                }
                case GAE: {
                    serviceClass = Class.forName("org.b3log.latke.image.gae.GAEImageService");
                    IMAGE_SERVICE = (ImageService)serviceClass.newInstance();
                    break;
                }
                default: {
                    throw new RuntimeException("Latke runs in the hell.... Please set the enviornment correctly");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can not initialize Image Service!", e);
        }
        LOGGER.info("Constructed Image Service");
    }
}

