/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.cron;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.b3log.latke.Latkes;
import org.b3log.latke.RuntimeEnv;
import org.b3log.latke.cron.Cron;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class CronService {
    private static final Logger LOGGER = Logger.getLogger(CronService.class.getName());
    private static final List<Cron> CRONS = new ArrayList<Cron>();
    private static final List<Timer> TIMERS = new ArrayList<Timer>();

    public static void start() {
        LOGGER.info("Constructing Cron Service....");
        CronService.shutdown();
        RuntimeEnv runtimeEnv = Latkes.getRuntimeEnv();
        try {
            switch (runtimeEnv) {
                case LOCAL: {
                    CronService.loadCronXML();
                    for (Cron cron : CRONS) {
                        cron.setURL(Latkes.getServer() + Latkes.getContextPath() + cron.getUrl());
                        Timer timer = new Timer();
                        TIMERS.add(timer);
                        timer.scheduleAtFixedRate((TimerTask)cron, 60000L, cron.getPeriod());
                        LOGGER.log(Level.DEBUG, "Scheduled a cron job[url={0}]", cron.getUrl());
                    }
                    LOGGER.log(Level.DEBUG, "[{0}] cron jobs totally", CRONS.size());
                    break;
                }
                case GAE: {
                    break;
                }
                default: {
                    throw new RuntimeException("Latke runs in the hell.... Please set the enviornment correctly");
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Can not initialize Cron Service!", e);
            throw new IllegalStateException(e);
        }
        LOGGER.info("Constructed Cron Service");
    }

    public static void shutdown() {
        CRONS.clear();
        for (Timer timer : TIMERS) {
            timer.cancel();
        }
        TIMERS.clear();
    }

    private static void loadCronXML() {
        File cronXML = Latkes.getWebFile("/WEB-INF/cron.xml");
        if (null == cronXML || !cronXML.exists()) {
            LOGGER.log(Level.INFO, "Not found cron.xml, no cron jobs need to schedule", new Object[0]);
            return;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(cronXML);
            Element root = document.getDocumentElement();
            root.normalize();
            NodeList crons = root.getElementsByTagName("cron");
            for (int i = 0; i < crons.getLength(); ++i) {
                Element cronElement = (Element)crons.item(i);
                Element urlElement = (Element)cronElement.getElementsByTagName("url").item(0);
                Element descriptionElement = (Element)cronElement.getElementsByTagName("description").item(0);
                Element scheduleElement = (Element)cronElement.getElementsByTagName("schedule").item(0);
                String url = urlElement.getTextContent();
                String description = descriptionElement.getTextContent();
                String schedule = scheduleElement.getTextContent();
                CRONS.add(new Cron(url, description, schedule));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Reads cron.xml failed", e);
            throw new RuntimeException(e);
        }
    }

    private CronService() {
    }
}

