/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.cache.local.memory;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.b3log.latke.cache.local.memory.AbstractMemoryCache;
import org.b3log.latke.cache.local.util.DoubleLinkedMap;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.util.Serializer;

public final class LruMemoryCache<K extends Serializable, V extends Serializable>
extends AbstractMemoryCache<K, V>
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(LruMemoryCache.class.getName());
    private static final long serialVersionUID = 1L;
    private DoubleLinkedMap<K, byte[]> map = new DoubleLinkedMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        this.putCountInc();
        LruMemoryCache lruMemoryCache = this;
        synchronized (lruMemoryCache) {
            if (this.getCachedCount() >= this.getMaxCount()) {
                this.collect();
            }
            try {
                this.map.addFirst(key, Serializer.serialize(value));
            }
            catch (IOException e) {
                LOGGER.log(Level.ERROR, "Cache error[key=" + key + ']', e);
                return;
            }
            this.cachedCountInc();
        }
    }

    @Override
    public void putAsync(K key, V value) {
        this.put(key, value);
    }

    @Override
    public synchronized V get(K key) {
        byte[] bytes = this.map.get(key);
        if (bytes != null) {
            this.hitCountInc();
            this.map.makeFirst(key);
            try {
                return (V)((Serializable)Serializer.deserialize(bytes));
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "Gets cached object failed[key=" + key + "]", e);
                return null;
            }
        }
        this.missCountInc();
        return null;
    }

    @Override
    public synchronized void remove(K key) {
        boolean removed = this.map.remove(key);
        if (removed) {
            this.cachedCountDec();
        }
    }

    @Override
    public synchronized void remove(Collection<K> keys) {
        for (Serializable key : keys) {
            this.remove(key);
        }
    }

    @Override
    public synchronized void collect() {
        this.map.removeLast();
        this.cachedCountDec();
    }

    @Override
    public synchronized void removeAll() {
        this.map.removeAll();
        this.setCachedCount(0L);
        this.setMissCount(0L);
        this.setHitCount(0);
    }

    @Override
    public boolean contains(K key) {
        return null != this.get(key);
    }

    @Override
    public long inc(K key, long delta) {
        Long v;
        Object ret = this.get(key);
        if (null == ret || !(ret instanceof Long)) {
            v = delta;
            ret = v;
            this.put(key, ret);
        }
        if (ret instanceof Long) {
            v = (Long)ret + delta;
            ret = v;
            this.put(key, ret);
        }
        return (Long)ret;
    }
}

