/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.cache;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.b3log.latke.Latkes;
import org.b3log.latke.RuntimeEnv;
import org.b3log.latke.cache.Cache;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;

public final class CacheFactory {
    private static final Logger LOGGER = Logger.getLogger(CacheFactory.class.getName());
    private static final Map<String, Cache<String, ?>> CACHES = Collections.synchronizedMap(new HashMap());

    public static synchronized void removeAll() {
        RuntimeEnv runtime = Latkes.getRuntime("cache");
        if (RuntimeEnv.LOCAL == Latkes.getRuntimeEnv()) {
            runtime = RuntimeEnv.LOCAL;
        }
        switch (runtime) {
            case GAE: {
                Iterator<Cache<String, ?>> iterator = CACHES.values().iterator();
                if (!iterator.hasNext()) break;
                iterator.next().removeAll();
                break;
            }
            case LOCAL: {
                for (Map.Entry<String, Cache<String, ?>> entry : CACHES.entrySet()) {
                    Cache<String, ?> cache = entry.getValue();
                    cache.removeAll();
                    LOGGER.log(Level.TRACE, "Clears cache[name={0}]", entry.getKey());
                }
                break;
            }
            default: {
                throw new RuntimeException("Latke runs in the hell.... Please set the enviornment correctly");
            }
        }
    }

    public static synchronized Cache<String, ? extends Serializable> getCache(String cacheName) {
        LOGGER.log(Level.INFO, "Constructing Cache[name={0}]....", cacheName);
        Cache ret = CACHES.get(cacheName);
        try {
            if (null == ret) {
                switch (Latkes.getRuntime("cache")) {
                    case LOCAL: {
                        Class<?> localLruCache = Class.forName("org.b3log.latke.cache.local.memory.LruMemoryCache");
                        ret = (Cache)localLruCache.newInstance();
                        break;
                    }
                    case GAE: {
                        Class<?> gaeMemcache = Class.forName("org.b3log.latke.cache.gae.Memcache");
                        Constructor<?> gaeMemcacheConstructor = gaeMemcache.getConstructor(String.class);
                        ret = (Cache)gaeMemcacheConstructor.newInstance(cacheName);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Latke runs in the hell.... Please set the enviornment correctly");
                    }
                }
                CACHES.put(cacheName, ret);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Can not get cache: " + e.getMessage(), e);
        }
        LOGGER.log(Level.INFO, "Constructed Cache[name={0}]", cacheName);
        return ret;
    }

    private CacheFactory() {
    }
}

