/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.b3log.latke.RuntimeDatabase;
import org.b3log.latke.RuntimeEnv;
import org.b3log.latke.RuntimeMode;
import org.b3log.latke.cron.CronService;
import org.b3log.latke.ioc.Lifecycle;
import org.b3log.latke.logging.Level;
import org.b3log.latke.logging.Logger;
import org.b3log.latke.repository.jdbc.util.Connections;
import org.b3log.latke.servlet.AbstractServletListener;
import org.b3log.latke.util.Strings;
import org.b3log.latke.util.freemarker.Templates;
import org.h2.tools.Server;

public final class Latkes {
    private static final Logger LOGGER;
    private static Locale locale;
    private static RuntimeEnv runtimeEnv;
    private static RuntimeMode runtimeMode;
    private static final Properties LOCAL_PROPS;
    private static String staticResourceVersion;
    private static String serverScheme;
    private static String staticServerScheme;
    private static String serverHost;
    private static String staticServerHost;
    private static String serverPort;
    private static String staticServerPort;
    private static String server;
    private static String servePath;
    private static String staticServer;
    private static String staticServePath;
    private static String contextPath;
    private static String staticPath;
    private static String scanPath;
    private static final Properties LATKE_PROPS;
    private static final Properties REMOTE_PROPS;
    private static Server h2;

    public static String getStaticResourceVersion() {
        if (null == staticResourceVersion) {
            staticResourceVersion = LATKE_PROPS.getProperty("staticResourceVersion");
        }
        return staticResourceVersion;
    }

    public static String getServerScheme() {
        if (null == serverScheme && null == (serverScheme = LATKE_PROPS.getProperty("serverScheme"))) {
            throw new IllegalStateException("latke.properties [serverScheme] is empty");
        }
        return serverScheme;
    }

    public static String getServerHost() {
        if (null == serverHost && null == (serverHost = LATKE_PROPS.getProperty("serverHost"))) {
            throw new IllegalStateException("latke.properties [serverHost] is empty");
        }
        return serverHost;
    }

    public static String getServerPort() {
        if (null == serverPort) {
            serverPort = LATKE_PROPS.getProperty("serverPort");
        }
        return serverPort;
    }

    public static String getServer() {
        if (null == server) {
            StringBuilder serverBuilder = new StringBuilder(Latkes.getServerScheme()).append("://").append(Latkes.getServerHost());
            String port = Latkes.getServerPort();
            if (!Strings.isEmptyOrNull(port) && !port.equals("80")) {
                serverBuilder.append(':').append(port);
            }
            server = serverBuilder.toString();
        }
        return server;
    }

    public static String getServePath() {
        if (null == servePath) {
            servePath = Latkes.getServer() + Latkes.getContextPath();
        }
        return servePath;
    }

    public static String getStaticServerScheme() {
        if (null == staticServerScheme && null == (staticServerScheme = LATKE_PROPS.getProperty("staticServerScheme"))) {
            throw new IllegalStateException("latke.properties [staticServerScheme] is empty");
        }
        return staticServerScheme;
    }

    public static String getStaticServerHost() {
        if (null == staticServerHost && null == (staticServerHost = LATKE_PROPS.getProperty("staticServerHost"))) {
            throw new IllegalStateException("latke.properties [staticServerHost] is empty");
        }
        return staticServerHost;
    }

    public static String getStaticServerPort() {
        if (null == staticServerPort) {
            staticServerPort = LATKE_PROPS.getProperty("staticServerPort");
        }
        return staticServerPort;
    }

    public static String getStaticServer() {
        if (null == staticServer) {
            StringBuilder staticServerBuilder = new StringBuilder(Latkes.getStaticServerScheme()).append("://").append(Latkes.getStaticServerHost());
            String port = Latkes.getStaticServerPort();
            if (!Strings.isEmptyOrNull(port)) {
                staticServerBuilder.append(':').append(port);
            }
            staticServer = staticServerBuilder.toString();
        }
        return staticServer;
    }

    public static String getStaticServePath() {
        if (null == staticServePath) {
            staticServePath = Latkes.getStaticServer() + Latkes.getStaticPath();
        }
        return staticServePath;
    }

    public static String getContextPath() {
        if (RuntimeEnv.GAE == Latkes.getRuntimeEnv()) {
            return "";
        }
        if (null == contextPath) {
            contextPath = LATKE_PROPS.getProperty("contextPath");
        }
        return contextPath;
    }

    public static String getStaticPath() {
        if (RuntimeEnv.GAE == Latkes.getRuntimeEnv()) {
            return "";
        }
        if (null == staticPath) {
            staticPath = LATKE_PROPS.getProperty("staticPath");
        }
        return staticPath;
    }

    public static String getScanPath() {
        if (null == scanPath) {
            scanPath = LATKE_PROPS.getProperty("scanPath");
        }
        return scanPath;
    }

    public static RuntimeEnv getRuntime(String serviceName) {
        if (RuntimeEnv.LOCAL == Latkes.getRuntimeEnv()) {
            return RuntimeEnv.LOCAL;
        }
        String value = LATKE_PROPS.getProperty(serviceName);
        if (null == value) {
            LOGGER.log(Level.WARN, "Rutnime service[name={0}] is undefined, please configure it in latkes.properties", serviceName);
            return null;
        }
        return RuntimeEnv.valueOf(value);
    }

    public static void initRuntimeEnv() {
        String runtimeModeValue;
        LOGGER.log(Level.TRACE, "Initializes runtime environment from configuration file", new Object[0]);
        String runtimeEnvValue = LATKE_PROPS.getProperty("runtimeEnv");
        if (null != runtimeEnvValue) {
            runtimeEnv = RuntimeEnv.valueOf(runtimeEnvValue);
        }
        if (null == runtimeEnv) {
            LOGGER.log(Level.TRACE, "Initializes runtime environment by class loading", new Object[0]);
            try {
                runtimeEnv = RuntimeEnv.GAE;
                Class.forName("org.b3log.latke.repository.gae.GAERepository");
            }
            catch (ClassNotFoundException e) {
                runtimeEnv = RuntimeEnv.LOCAL;
            }
        }
        if (null != (runtimeModeValue = LATKE_PROPS.getProperty("runtimeMode"))) {
            runtimeMode = RuntimeMode.valueOf(runtimeModeValue);
        } else {
            LOGGER.log(Level.TRACE, "Can't parse runtime mode in latke.properties, default to [DEVELOPMENT]", new Object[0]);
            runtimeMode = RuntimeMode.DEVELOPMENT;
        }
        LOGGER.log(Level.INFO, "Latke is running on [{0}] with mode [{1}]", new Object[]{Latkes.getRuntimeEnv(), Latkes.getRuntimeMode()});
        if (RuntimeEnv.LOCAL == runtimeEnv) {
            String newTCPServer;
            RuntimeDatabase runtimeDatabase = Latkes.getRuntimeDatabase();
            LOGGER.log(Level.INFO, "Runtime database is [{0}]", new Object[]{runtimeDatabase});
            if (RuntimeDatabase.H2 == runtimeDatabase && "true".equals(newTCPServer = Latkes.getLocalProperty("newTCPServer"))) {
                LOGGER.log(Level.INFO, "Starting H2 TCP server", new Object[0]);
                String jdbcURL = Latkes.getLocalProperty("jdbc.URL");
                if (Strings.isEmptyOrNull(jdbcURL)) {
                    throw new IllegalStateException("The jdbc.URL in local.properties is required");
                }
                String[] parts = jdbcURL.split(":");
                if (parts.length != Integer.valueOf("5")) {
                    throw new IllegalStateException("jdbc.URL should like [jdbc:h2:tcp://localhost:8250/~/] (the port part is required)");
                }
                String port = parts[parts.length - 1];
                port = StringUtils.substringBefore((String)port, (String)"/");
                LOGGER.log(Level.TRACE, "H2 TCP port [{0}]", port);
                try {
                    h2 = Server.createTcpServer((String[])new String[]{"-tcpPort", port, "-tcpAllowOthers"}).start();
                }
                catch (SQLException e) {
                    String msg = "H2 TCP server create failed";
                    LOGGER.log(Level.ERROR, "H2 TCP server create failed", e);
                    throw new IllegalStateException("H2 TCP server create failed");
                }
                LOGGER.info("Started H2 TCP server");
            }
        }
        locale = new Locale("en_US");
    }

    public static RuntimeEnv getRuntimeEnv() {
        if (null == runtimeEnv) {
            throw new RuntimeException("Runtime enviornment has not been initialized!");
        }
        return runtimeEnv;
    }

    public static void setRuntimeMode(RuntimeMode runtimeMode) {
        Latkes.runtimeMode = runtimeMode;
    }

    public static RuntimeMode getRuntimeMode() {
        if (null == runtimeMode) {
            throw new RuntimeException("Runtime mode has not been initialized!");
        }
        return runtimeMode;
    }

    public static RuntimeDatabase getRuntimeDatabase() {
        if (RuntimeEnv.LOCAL != runtimeEnv) {
            throw new RuntimeException("Underlying database can be specified when Latke runs on [LOCAL] environment only, current runtime enviornment [" + (Object)((Object)runtimeEnv) + ']');
        }
        String runtimeDatabase = LOCAL_PROPS.getProperty("runtimeDatabase");
        if (null == runtimeDatabase) {
            throw new RuntimeException("Please configures runtime database in local.properties!");
        }
        RuntimeDatabase ret = RuntimeDatabase.valueOf(runtimeDatabase);
        if (null == ret) {
            throw new RuntimeException("Please configures a valid runtime database in local.properties!");
        }
        return ret;
    }

    public static void setLocale(Locale locale) {
        Latkes.locale = locale;
    }

    public static Locale getLocale() {
        if (null == locale) {
            throw new RuntimeException("Default locale has not been initialized!");
        }
        return locale;
    }

    public static boolean runsWithJDBCDatabase() {
        return RuntimeEnv.LOCAL == Latkes.getRuntimeEnv();
    }

    public static String getLocalProperty(String key) {
        return LOCAL_PROPS.getProperty(key);
    }

    public static boolean isRemoteEnabled() {
        return !REMOTE_PROPS.isEmpty();
    }

    public static String getRemoteProperty(String key) {
        return REMOTE_PROPS.getProperty(key);
    }

    public static void shutdown() {
        try {
            if (RuntimeEnv.LOCAL != Latkes.getRuntimeEnv()) {
                return;
            }
            Connections.shutdownConnectionPool();
            RuntimeDatabase runtimeDatabase = Latkes.getRuntimeDatabase();
            switch (runtimeDatabase) {
                case H2: {
                    String newTCPServer = Latkes.getLocalProperty("newTCPServer");
                    if (!"true".equals(newTCPServer)) break;
                    h2.stop();
                    h2.shutdown();
                    LOGGER.log(Level.INFO, "Closed H2 TCP server", new Object[0]);
                    break;
                }
            }
            CronService.shutdown();
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Shutdowns Latke failed", e);
        }
        Lifecycle.endApplication();
    }

    public static void setTimeZone(String timeZoneId) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
        Templates.MAIN_CFG.setTimeZone(timeZone);
        Templates.MOBILE_CFG.setTimeZone(timeZone);
    }

    public static void loadSkin(String skinDirName) {
        LOGGER.debug("Loading skin [dirName=" + skinDirName + ']');
        ServletContext servletContext = AbstractServletListener.getServletContext();
        Templates.MAIN_CFG.setServletContextForTemplateLoading((Object)servletContext, "skins/" + skinDirName);
        Latkes.setTimeZone("Asia/Shanghai");
        LOGGER.info("Loaded skins....");
    }

    public static String getSkinName(String skinDirName) {
        try {
            Properties ret = new Properties();
            File file = Latkes.getWebFile("/skins/" + skinDirName + "/skin.properties");
            ret.load(new FileInputStream(file));
            return ret.getProperty("name");
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Read skin configuration error[msg={0}]", e.getMessage());
            return null;
        }
    }

    public static File getWebFile(String path) {
        ServletContext servletContext = AbstractServletListener.getServletContext();
        try {
            URL resource = servletContext.getResource(path);
            if (null == resource) {
                return null;
            }
            File ret = FileUtils.toFile((URL)resource);
            if (null == ret) {
                File tempdir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
                ret = new File(tempdir.getPath() + path);
                FileUtils.copyURLToFile((URL)resource, (File)ret);
                ret.deleteOnExit();
            }
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Reads file [path=" + path + "] failed", e);
            return null;
        }
    }

    private Latkes() {
    }

    static {
        InputStream resourceAsStream;
        LOGGER = Logger.getLogger(Latkes.class.getName());
        LOCAL_PROPS = new Properties();
        LATKE_PROPS = new Properties();
        REMOTE_PROPS = new Properties();
        LOGGER.debug("Loading latke.properties");
        try {
            resourceAsStream = Latkes.class.getResourceAsStream("/latke.properties");
            if (null != resourceAsStream) {
                LATKE_PROPS.load(resourceAsStream);
                LOGGER.debug("Loaded latke.properties");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Not found latke.properties", new Object[0]);
            throw new RuntimeException("Not found latke.properties");
        }
        LOGGER.debug("Loading local.properties");
        try {
            resourceAsStream = Latkes.class.getResourceAsStream("/local.properties");
            if (null != resourceAsStream) {
                LOCAL_PROPS.load(resourceAsStream);
                LOGGER.debug("Loaded local.properties");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.DEBUG, "Not found local.properties", new Object[0]);
        }
        LOGGER.debug("Loading remote.properties");
        try {
            resourceAsStream = Latkes.class.getResourceAsStream("/remote.properties");
            if (null != resourceAsStream) {
                REMOTE_PROPS.load(resourceAsStream);
                LOGGER.debug("Loaded remote.properties");
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.DEBUG, "Not found Latke remote.properties", new Object[0]);
        }
    }
}

