#----------------------------------------------------------------
#
# Messages content for module polymod
# French Messages
#
#----------------------------------------------------------------
# $Id: polymod.sql,v 1.2 2010/02/04 15:51:48 sebastien Exp $

DELETE FROM messages WHERE module_mes = 'polymod' and language_mes = 'fr';

INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(2, 'polymod', 'fr', 'Création / modification d''un élément ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(3, 'polymod', 'fr', 'Création / modification de l''élément ''%s'' :');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(4, 'polymod', 'fr', 'Suppression d''un élément ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(5, 'polymod', 'fr', 'Suppression de l''élément ''%s'' :');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(6, 'polymod', 'fr', 'Lien existant');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(7, 'polymod', 'fr', 'Accueil');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(18, 'polymod', 'fr', 'Mots-clés');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(19, 'polymod', 'fr', 'Publié entre le');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(20, 'polymod', 'fr', 'et le');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(21, 'polymod', 'fr', '%s élément(s) ''%s'' correspondant à votre recherche');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(30, 'polymod', 'fr', 'Objet');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(31, 'polymod', 'fr', 'Changement du contenu d''un élement %s');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(32, 'polymod', 'fr', 'Changement apporté sur l''élément %s : <strong>%s</strong>\n\nAuteur(s) de la modification :\n%s');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(37, 'polymod', 'fr', 'Libellé');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(39, 'polymod', 'fr', 'Description');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(52, 'polymod', 'fr', 'Confirmez-vous la suppression de l''élément ''%s'' : %s');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(53, 'polymod', 'fr', 'Proposition de suppression d''un élément %s');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(55, 'polymod', 'fr', 'Suppression de l''élément %s : <strong>%s</strong>\n\nAuteur(s) de la suppression :\n%s');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(57, 'polymod', 'fr', 'Publication sur le site');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(66, 'polymod', 'fr', 'Trouver un élément ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(77, 'polymod', 'fr', 'Lister');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(82, 'polymod', 'fr', 'Gestion des éléments ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(108, 'polymod', 'fr', 'Gérer les éléments ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(109, 'polymod', 'fr', 'Effectuer une recherche');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(110, 'polymod', 'fr', '<div class=\"rowComment\"><h1>Lance une recherche sur un type d\'objet donné :</h1><div class=\"retrait\"><span class=\"code\"> &lt;atm-search what=\"<span class=\"keyword\">objet</span>\" name=\"<span class=\"keyword\">searchName</span>\"&gt;...&lt;/atm-search&gt; </span><br /><br /><ul>    <li><span class=\"keyword\">objet</span> : Type d\'objet à rechercher (de la forme <span class=\"vertclair\">{<span class=\"keyword\">objet</span>}</span>)</li>    <li><span class=\"keyword\">searchName</span> : Nom de la recherche : identifiant unique pour la recherche dans la rangée.</li>    <li>Un attribut <span class=\"keyword\">public</span> (facultatif) peut être ajouté pour spécifier une recherche sur la zone publique ou éditée. Il prend pour valeur <span class=\"vertclair\">true</span> pour une recherche publique (défaut) ou <span class=\"vertclair\">false</span> pour une recherche dans la zone éditée.</li></ul></div><h2>Ce tag peut contenir les sous-tags suivants :</h2><div class=\"retrait\"><h3>Affichage des résultats :</h3><div class=\"retrait\"><span class=\"code\"> &lt;atm-result search=\"<span class=\"keyword\">searchName</span>\"&gt; ... &lt;/atm-result&gt; </span><br /><br />Le contenu de ce tag sera lu pour chaque résultat trouvé pour la recherche en cours.<ul>    <li><span class=\"keyword\">searchName</span> : Nom de la recherche sur lequel appliquer le paramètre.</li>    <li>Un attribut <span class=\"keyword\">return </span>(facultatif) peut être ajouté pour spécifier le type de résultat retourné. Par défaut une recherche renvoie des objets, mais dans l\'optique d\'améliorer les performances, il est possible de spécifier les deux valeurs suivantes de retour :    <ul>        <li><span class=\"vertclair\">POLYMOD_SEARCH_RETURN_IDS</span> : retournera uniquement l\'identifiant du résultat.</li>        <li><span class=\"vertclair\">POLYMOD_SEARCH_RETURN_OBJECTSLIGHT</span> : retournera le résultat mais sans charger les sous-objets qu\'il peut contenir dans ses différents champs. Attention, ce paramètre n\'est possible que sur une recherche publique.</li>    </ul></li></ul><br />Les valeurs suivantes seront remplacées dans le tag :<ul>    <li><span class=\"vertclair\">{firstresult}</span> : Vrai si le résultat en cours est le premier de la page en cours.</li>    <li><span class=\"vertclair\">{lastresult}</span> : Vrai si le résultat en cours est le dernier de la page en cours.</li>    <li><span class=\"vertclair\">{resultcount}</span> : Numéro du résultat dans la page.</li>    <li><span class=\"vertclair\">{maxresults}</span> : Nombre de résultats pour la recherche.</li>    <li><span class=\"vertclair\">{maxpages}</span> : Nombre de pages maximum pour la recherche en cours.</li>    <li><span class=\"vertclair\">{currentpage}</span> : Numéro de la page actuelle pour la recherche en cours.</li>    <li><span class=\"vertclair\">{resultid}</span> : Identifiant du résultat. Utile dans le cas d\'une recherche retournant uniquement les identifiants des résultats (paramètre return avec la valeur POLYMOD_SEARCH_RETURN_IDS).</li></ul></div><h3>Aucun résultats :</h3><div class=\"retrait\"><span class=\"code\"> &lt;atm-noresult search=\"<span class=\"keyword\">searchName</span>\"&gt; ... &lt;/atm-noresult&gt; </span><br /><br />Le contenu de ce tag sera affiché si aucun résultat n\'est trouvé pour la recherche en cours.<ul>    <li><span class=\"keyword\">searchName</span> : Nom de la recherche sur laquelle appliquer le paramètre.</li></ul></div><h3>Paramètre de recherche :</h3><div class=\"retrait\"><span class=\"code\"> &lt;atm-search-param search=\"<span class=\"keyword\">searchName</span>\" type=\"<span class=\"keyword\">paramType</span>\" value=\"<span class=\"keyword\">paramValue</span>\" mandatory=\"<span class=\"keyword\">mandatoryValue</span>\" /&gt; </span><br /><br />Permet de limiter les résultats de la recherche à des paramètres donnés.<ul>    <li><span class=\"keyword\">searchName</span> : Nom de la recherche sur laquelle appliquer le paramètre.</li>    <li><span class=\"keyword\">paramType</span> : Type de paramètre, peut être de la forme <span class=\"vertclair\">{<span class=\"keyword\">objet:champ</span>:fieldID}</span> pour filtrer la recherche sur la valeur d\'un champ de l\'élément recherché ou bien un nom de type fixe parmi les suivants&#160;pour utiliser un filtrage prédéfini :<br />    <ul>        <li><span class=\"vertclair\">keywords </span>: Permet de rechercher tous les éléments contenant les mots clés saisis (la recherche s\'effectue dans les champs pour lesquels l\'option \"Ajouter au formulaire de recherche\" est active). <br />        Ce filtre accepte trois comportements spécifiques que vous pouvez spécifier à l\'aide de l\'attribut <span class=\"keyword\">operator </span>:        <ul>            <li><span class=\"vertclair\">any </span>: Valeur de défaut : Les résultats retournés comportement n\'importe quel mot saisi dans le filtre. Il s\'agit de l\'opérateur employé par défaut.</li>            <li><span class=\"vertclair\">all </span>: Les résultats retournés comporteront tous les mots saisis dans le filtre.</li>            <li><span class=\"vertclair\">phrase </span>: Les résultats retournés comporteront la phrase exacte saisie dans le filtre.</li><li><span class=\"vertclair\">beginswith</span> : Les résultats retournés commenceront par la phrase exacte saisie dans le fitre.</li>        </ul></li>        <li><span class=\"vertclair\">item </span>: Permet de rechercher un élément spécifiquement par son identifiant.<br />        Ce filtre accepte des comportements spécifiques que vous pouvez spécifier à l\'aide de l\'attribut <span class=\"keyword\">operator </span>:        <ul>            <li><span class=\"vertclair\">=</span> (défaut), <span class=\"vertclair\">!=</span>, <span class=\"vertclair\">&gt;=</span>, <span class=\"vertclair\">&gt;</span>, <span class=\"vertclair\">&lt;=</span>, <span class=\"vertclair\">&lt;</span> : Vous permet d\'effectuer des recherches en comparant numérique les identifiants retournés à l\'identifiant fourni en paramètre.</li>        </ul></li>        <li><span class=\"vertclair\">items </span>: Permet de rechercher des éléments par leurs identifiants (un tableau d\'identifiant est alors attendu en valeur du filtre).<br />        Ce filtre accepte deux comportements spécifiques que vous pouvez spécifier à l\'aide de l\'attribut <span class=\"keyword\">operator </span>:        <ul>            <li><span class=\"vertclair\">in </span>: Les éléments retournés appartiendront aux identifiants fournis en paramètre (comportement par défaut).</li>            <li><span class=\"vertclair\">not in</span> : Les éléments retournés n\'appartiendront pas aux éléments fournis en paramètre.</li>        </ul></li>        <li><span class=\"vertclair\">itemsOrdered </span>: Permet de rechercher des éléments par leurs identifiants tout en conservant l\'ordre donné dans le tableau (un tableau d\'identifiant est alors attendu en valeur du filtre).</li>        <li><span class=\"vertclair\">archives </span>: Permet d\'obtenir les résultats dont les dates de publications sont dépassées. Seuls les éléments paramétrés comme ressource primaire sont concernés.</li>        <li><span class=\"vertclair\">publication date after</span> : Permet de spécifier une date de début de publication supérieure ou égale à la date fournie en valeur. Seuls les éléments paramétrés comme ressource primaire sont concernés.</li>        <li><span class=\"vertclair\">publication date before</span> : Permet de spécifier une date de début de publication inférieure ou égale à la date fournie en valeur. Seuls les éléments paramétrés comme ressource primaire sont concernés.</li>        <li><span class=\"vertclair\">status </span>: Permet de spécifier le statut de publication des éléments recherchés. Seuls les éléments paramétrés comme ressource primaire sont concernés. <br />        Les valeurs suivantes sont acceptées :        <ul>            <li><span class=\"vertclair\">online </span>: Eléments actuellement en ligne.</li>            <li><span class=\"vertclair\">offline </span>: Eléments &#160;qui ne sont plus en ligne.</li>            <li><span class=\"vertclair\">validated</span> : Eléments validés</li>            <li><span class=\"vertclair\">awaiting </span>: Eléments en attente de validation.</li>        </ul></li>    </ul></li>    <li><span class=\"keyword\">paramValue</span> : Valeur du paramètre de la recherche. Si la valeur est \'<span class=\"vertclair\">block</span>\' vous pourrez spécifier cette valeur lors de la création de la rangée dans la page.</li>    <li><span class=\"keyword\">mandatoryValue</span> : Booléen (<span class=\"vertclair\">true</span> ou <span class=\"vertclair\">false</span>), permet de spécifier si ce paramètre de recherche est optionnel ou obligatoire.</li></ul><br />Un attribut facultatif supplémentaire <span class=\"keyword\">operator</span> permet d\'ajouter un comportement spécifique au type de champ sur le filtre. La valeur acceptée par ce paramètre est expliquée dans l\'aide du champ concerné s\'il accepte un tel paramètre.</div><h3>Afficher une page donnée de résultats (le nombre de résultats d\'une page est spécifié par le tag atm-search-limit) :</h3><div class=\"retrait\"><span class=\"code\"> &lt;atm-search-page search=\"<span class=\"keyword\">searchName</span>\" value=\"<span class=\"keyword\">pageValue</span>\" /&gt;</span><ul>    <li><span class=\"keyword\">searchName</span> : Nom de la recherche sur laquelle appliquer le paramètre.</li>    <li><span class=\"keyword\">pageValue</span> : Valeur numérique de la page à afficher.</li></ul></div><h3>Limiter le nombre de résultats d\'une page :</h3><div class=\"retrait\"><span class=\"code\"> &lt;atm-search-limit search=\"<span class=\"keyword\">searchName</span>\" value=\"<span class=\"keyword\">limitValue</span>\" /&gt;</span><ul>    <li><span class=\"keyword\">searchName</span> : Nom de la recherche sur laquelle appliquer la limite.</li>    <li><span class=\"keyword\">limitValue</span> : Valeur numérique de la limite à appliquer. Si la valeur est \'<span class=\"vertclair\">block</span>\' vous pourrez spécifier cette valeur lors de la création de la rangée dans la page.</li></ul></div><h3>Ordonner les résultats :</h3><div class=\"retrait\"><span class=\"code\">&lt;atm-search-order search=\"<span class=\"keyword\">searchName</span>\" type=\"<span class=\"keyword\">orderType</span>\" direction=\"<span class=\"keyword\">directionValue</span>\" /&gt;</span><ul>    <li><span class=\"keyword\">searchName</span> : Nom de la recherche sur laquelle appliquer la limite.</li>    <li><span class=\"keyword\">orderType</span> : Type de valeur sur laquelle appliquer l\'ordre, peut être de la forme <span class=\"vertclair\">{<span class=\"keyword\">objet:champ</span>:fieldID}</span> ou un nom de type fixe parmi :&#160;    <ul>        <li><span class=\"vertclair\">objectID </span>: Tri les résultats par ordre de création.</li>        <li><span class=\"vertclair\">random </span>: Mélange aléatoirement des résultats.</li>        <li><span class=\"vertclair\">publication date start&#160;</span>: Tri les résultats par date de début de publication. Seuls les éléments paramétrés comme ressource primaire sont concernés.</li>        <li><span class=\"vertclair\">publication date end</span> : Tri des résultats par date de fin de publication. Seuls les éléments paramétrés comme ressource primaire sont concernés.</li>    </ul></li>    <li><span class=\"keyword\">directionValue</span> : Sens à appliquer : <span class=\"vertclair\">asc</span> pour croissant, <span class=\"vertclair\">desc</span> pour décroissant. Si la valeur est \'<span class=\"vertclair\">block</span>\' vous pourrez spécifier cette valeur lors de la création de la rangée dans la page.</li></ul><p>Vous avez la possibilité de mettre plusieurs tags atm-search-order à la suite pour définir des ordres imbriqués.</p><p>Un attribut facultatif supplémentaire <span class=\"keyword\">operator</span> permet d\'ajouter un comportement spécifique au type de champ sur l\'ordre. La valeur acceptée par ce paramètre est expliquée dans l\'aide du champ concerné s\'il accepte un tel paramètre.</p></div></div><h2>Fonctions :</h2><div class=\"retrait\"><h3>Afficher la liste des pages de la recherche en cours :</h3><div class=\"retrait\"><div class=\"code\">&lt;atm-function function=\"pages\" maxpages=\"<span class=\"keyword\">maxpagesValues</span>\" currentpage=\"<span class=\"keyword\">currentpageValue</span>\" displayedpage=\"<span class=\"keyword\">displayedpagesValue</span>\"&gt;<br />&#160;&#160;&#160; <span class=\"keyword\">&lt;pages&gt;</span> ... <span class=\"vertclair\">{n}</span> ... <span class=\"keyword\">&lt;/pages&gt;</span><br />&#160;&#160;&#160; <span class=\"keyword\">&lt;currentpage&gt;</span> ... <span class=\"vertclair\">{n}</span> ... <span class=\"keyword\">&lt;/currentpage&gt;</span><br />&#160;&#160;&#160; <span class=\"keyword\">&lt;start&gt;</span> ... <span class=\"vertclair\">{n}</span> ... <span class=\"keyword\">&lt;/start&gt;</span><br />&#160;&#160;&#160; <span class=\"keyword\">&lt;previous&gt;</span> ... <span class=\"vertclair\">{n}</span> ... <span class=\"keyword\">&lt;/previous&gt;</span><br />&#160;&#160;&#160; <span class=\"keyword\">&lt;next&gt;</span> ... <span class=\"vertclair\">{n}</span> ... <span class=\"keyword\">&lt;/next&gt;</span><br />&#160;&#160;&#160; <span class=\"keyword\">&lt;end&gt;</span> ... <span class=\"vertclair\">{n}</span> ... <span class=\"keyword\">&lt;/end&gt;</span><br />&lt;/atm-function&gt;</div><br /><br />Cette fonction permet d\'afficher la liste de toutes les pages possibles pour la recherche.<br /><ul>    <li><span class=\"keyword\">maxpagesValue</span> : Nombre de pages maximum sur lesquelles boucler (habituellement : <span class=\"vertclair\">{maxpages}</span> ).</li>    <li><span class=\"keyword\">currentpageValue</span> : Numéro de la page courante de la recherche (habituellement : <span class=\"vertclair\">{currentpage}</span> ).</li>    <li><span class=\"keyword\">displayedpagesValue</span> : Nombre de pages à afficher.</li>    <li>Le tag &lt;<span class=\"keyword\">pages</span>&gt; sera lu pour chaque pages à lister excepté la page courante et la valeur <span class=\"vertclair\">{n}</span> sera remplacée par le numéro de la page.</li>    <li>Le tag optionnel &lt;<span class=\"keyword\">currentpage</span>&gt; sera lu pour la page en cours. S\'il n\'existe pas, le tag &lt;<span class=\"keyword\">pages</span>&gt; sera utilisé à la place.</li>    <li>Le tag optionnel &lt;<span class=\"keyword\">start</span>&gt; sera lu pour la première page.</li>    <li>Le tag optionnel &lt;<span class=\"keyword\">previous</span>&gt; sera lu pour la page précédente.</li>    <li>Le tag optionnel &lt;<span class=\"keyword\">next</span>&gt; sera lu pour la page suivante.</li>    <li>Le tag optionnel &lt;<span class=\"keyword\">end</span>&gt; sera lu pour la dernière page.</li></ul><p>Attention, les tags atm-* ne seront pas interprétés dans le tag atm-function.</p></div></div></div><p>&#160;</p>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(111, 'polymod', 'fr', 'Syntaxe des tags');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(112, 'polymod', 'fr', 'Variables et fonctions des objets');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(113, 'polymod', 'fr', 'Tags de travail spécifiques au Polymod');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(114, 'polymod', 'fr', '<div class="rowComment">\r\n<h1>Tags de travail spécifiques au Polymod :</h1>\r\n<p>Ces tags ne peuvent être employés qu''à l''intérieur d''un tag block de module polymod.</p>\r\n<div class="retrait">\r\n<h3>Boucler sur un ensemble d''objets :</h3>\r\n<div class="retrait"><span class="code">&lt;atm-loop on="<span class="keyword">objets</span>"&gt; ... &lt;/atm-loop&gt;</span>\r\n<ul>\r\n    <li><span class="keyword">objets</span> : Collection d''objets. Employé pour traiter tous les objets d''un ensemble d''objets multiple (dit multi-objet).</li>\r\n    <li>Un attribut <span class="keyword">reverse</span> (facultatif) peut être ajouté pour inverser l''ordre des résultats (valeur : booléen <span class="vertclair">true</span>, <span class="vertclair">false</span>)</li>\r\n</ul>\r\n<br />\r\nLes valeurs suivantes seront remplacées dans le tag :\r\n<ul>\r\n    <li><span class="vertclair">{firstloop}</span> : Vrai si l''objet en cours est le premier de la liste d''objets.</li>\r\n    <li><span class="vertclair">{lastloop}</span> : Vrai si l''objet en cours est le dernier de la liste d''objets.</li>\r\n    <li><span class="vertclair">{loopcount}</span> : Numéro de l''objet en cours dans la liste d''objets.</li>\r\n    <li><span class="vertclair">{lastloop}</span> : Vrai si l''objet en cours est le dernier de la liste d''objets.</li>\r\n    <li><span class="vertclair">{maxloops}</span> : Nombre d''objets sur lesquels boucler.</li>\r\n</ul>\r\n</div>\r\n<h3>Référencer un élément pour le gestionnaire de cache :</h3>\r\n<div class="retrait"><span class="code">&lt;atm-cache-reference element="<span class="keyword">element</span>" /&gt;<span class="keyword"><br />\r\n</span></span>\r\n<ul>\r\n    <li><span class="keyword">element </span>: Référencer un module à l''aide de son codename : <span class="vertclair">%s</span> ou les utilisateurs ou groupes d''Automne à l''aide de la valeur : <span class="vertclair">users</span>.</li>\r\n</ul>\r\n<p><span class="xml-punctuation">Ce tag vous permet d''informer le gestionnaire de cache que vous employez dans du code PHP inséré dans le bloc en cours, un élément donné (module ou utilisateurs / groupes d''Automne). Ainsi, le gestionnaire de cache pourra monitorer les modifications faites sur cet élément pour rafraichir le cache si l''élément référencé vient à être modifié.</span></p>\r\n</div>\r\n</div>\r\n</div>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(115, 'polymod', 'fr', 'Bloc de données');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(116, 'polymod', 'fr', '<div class="rowComment">\r\n<h1>Bloc de données du module :</h1>\r\n<div class="retrait"><span class="code"> 		&lt;block module="%s" id="<span class="keyword">blockID</span>" language="<span class="keyword">languageCode</span>" cache="<span class="keyword">lifetime</span>"&gt; ... &lt;/block&gt; 	</span> 	<br />\r\n<br />\r\nCe tag permet l''affichage de données spécifiques à ce module. Il doit entourer tout ensemble de tags relatif à un traitement de données du module.<br />\r\n<ul>\r\n    <li><span class="keyword">blockID </span>: Identifiant unique du bloc de contenu dans la rangée. Deux blocs de contenus d''une même rangée ne doivent pas avoir d''identifiants identiques.</li>\r\n    <li><span class="keyword">languageCode </span>(attribut facultatif) : Code du langage relatif à ce bloc de contenu parmi les codes suivants : <span class="vertclair">%s</span>. <br />\r\n    Si non présent, la langue de la page sera utilisée. Si non présente, la langue par défaut d''Automne sera utilisée.</li>\r\n    <li><span class="keyword">lifetime<span> </span></span>(attribut facultatif) : Cet attribut permet de spécifier la durée du cache appliqué sur ce bloc de données. Il accepte les valeurs suivantes :\r\n    <ul>\r\n        <li><span class="vertclair">0</span>, <span class="vertclair">false</span> : Désactive le cache coté client pour ce bloc.</li>\r\n        <li><span class="vertclair">nombre entier supérieur à 1</span> : Active le cache pour la durée spécifiée (en secondes).</li>\r\n        <li><span class="vertclair">1</span>, <span class="vertclair">true</span>, <span class="vertclair">auto</span> : Active le cache automatique (valeur par défaut si l''attribut n''existe pas).<br />\r\n        Le cache automatique à une durée maximum de 24h. Il sera activé uniquement si ce bloc de données ne contient pas de code PHP. Pour plus d''informations consultez le fonctionnement du cache des données Polymod dans <a href="http://doc.automne-cms.org" target="_blank">la documentation d''Automne</a>.</li>\r\n    </ul>\r\n    </li>\r\n</ul>\r\n</div>\r\n</div>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(117, 'polymod', 'fr', 'Libellé de l''objet, correspond à sa valeur');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(118, 'polymod', 'fr', 'Libellé du champ : ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(119, 'polymod', 'fr', 'Identifiant du champ : ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(120, 'polymod', 'fr', 'Valeur du champ');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(121, 'polymod', 'fr', 'Nom de l''objet');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(122, 'polymod', 'fr', 'Variables de l''objet');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(123, 'polymod', 'fr', 'Fonctions de l''objet');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(124, 'polymod', 'fr', 'Sélection des paramètres de recherche de la rangée ''%s'' du module ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(125, 'polymod', 'fr', 'Pour la recherche ayant l''identifiant ''%s'' dans cette rangée');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(126, 'polymod', 'fr', '[Erreur : la recherche ayant l''identifiant ''%s'' dans la rangée ''%s'' n''est pas valide : Elle porte sur un objet inexistant.]');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(127, 'polymod', 'fr', '[Erreur : la recherche ayant l''identifiant ''%s'' dans la rangée ''%s'' n''est pas valide : Un des paramètres porte sur un champ inexistant.]');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(128, 'polymod', 'fr', 'Nombre de résultats par page');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(129, 'polymod', 'fr', 'Croissant');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(130, 'polymod', 'fr', 'Décroissant');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(131, 'polymod', 'fr', 'Ordre d''affichage');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(132, 'polymod', 'fr', 'Par création d''objet');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(133, 'polymod', 'fr', '[Erreur : la recherche ayant l''identifiant ''%s'' dans la rangée ''%s'' n''est pas valide : Le type de l''un de ces paramètres est inconnu : ''%s'']');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(134, 'polymod', 'fr', 'Publié à partir du');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(135, 'polymod', 'fr', 'Publié jusqu''au');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(136, 'polymod', 'fr', '[Erreur : la recherche ayant l''identifiant ''%s'' dans la rangée ''%s'' n''est pas valide : Le type de l''un de ces paramètres de tri est inconnu : ''%s'']');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(137, 'polymod', 'fr', 'Par date de début de publication');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(138, 'polymod', 'fr', 'Par date de fin de publication');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(141, 'polymod', 'fr', 'Identifiant unique de l''objet');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(142, 'polymod', 'fr', 'Libellé de l''objet');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(143, 'polymod', 'fr', 'Nom de l''objet : ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(144, 'polymod', 'fr', 'Description de l''objet : ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(145, 'polymod', 'fr', 'Identifiant de type de l''objet : ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(146, 'polymod', 'fr', 'Identifiant du champ auquel l''objet appartient (si il existe)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(147, 'polymod', 'fr', 'Identifiant de ressource de l''objet');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(148, 'polymod', 'fr', 'Ensemble des objets de type ''%s'' associés à ce  champ. Cette valeur est usuellement utilisée par un tag atm-loop');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(149, 'polymod', 'fr', 'Nombre d''objets de type ''%s'' associés à ce champ');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(150, 'polymod', 'fr', 'Date format&eacute;e. Remplacez ''format'' par la valeur correspondant au format accept&eacute; en PHP pour la <a href="http://www.php.net/date" class="admin" target="_blank">''fonction date''</a>. Pour une date employ&eacute;e dans un Fil RSS, utilisez la valeur ''<strong>rss</strong>'' pour sp&eacute;cifier le format.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(151, 'polymod', 'fr', 'Adresse du lien (URL)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(152, 'polymod', 'fr', 'Libellé du lien');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(153, 'polymod', 'fr', 'Cible du lien (_blank, _top, etc.)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(154, 'polymod', 'fr', 'Type de lien (interne, externe, fichier, etc.)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(155, 'polymod', 'fr', 'Code HTML complet du lien. Le titre du lien peut-être modifié grâce à un paramètre (facultatif)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(156, 'polymod', 'fr', 'Identifiant de la catégorie racine de ce champ');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(157, 'polymod', 'fr', 'Nombre de catégories associées à ce champ');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(158, 'polymod', 'fr', 'Catégories associées à ce champ. Cette valeur est usuellement utilisée par un tag atm-loop');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(159, 'polymod', 'fr', 'Identifiant d''une catégorie du champ (utilisable dans un tag atm-loop)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(160, 'polymod', 'fr', 'Libellé d''une catégorie du champ (utilisable dans un tag atm-loop)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(161, 'polymod', 'fr', 'Identifiant de la catégorie du champ');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(162, 'polymod', 'fr', '<strong>Liste de tous les objets d''un type donn&eacute; :</strong><br /><br /><span class="code">&lt;select ...&gt;&lt;atm-function function=&quot;selectOptions&quot; object=&quot;%s&quot; selected=&quot;<span class="keyword">selectedID</span>&quot;&gt;&lt;/atm-function&gt;&lt;/select&gt;</span><br />Cette fonction permet d''afficher une liste class&eacute;e par ordre alphab&eacute;tique de tags &lt;option&gt; contenant tous les objets du m&ecirc;me type que l''objet pass&eacute; en param&egrave;tre. Elle est usuellement employ&eacute;e &agrave; l''int&eacute;rieur d''un tag &lt;select&gt;.<br /><ul><li><span class="keyword">selectedID : </span>Identifiant de l''objet &agrave; selectionner dans la liste</li></ul><br />');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(163, 'polymod', 'fr', '<p><strong>Arborescence de cat&eacute;gories : </strong><br /> <br /> <span class=\"code\">&lt;atm-function function=&quot;categoriesTree&quot; object=&quot;%s&quot; root=&quot;<span class=\"keyword\">rootID</span>&quot; maxlevel=&quot;<span class=\"keyword\">maxLevel</span>&quot; selected=&quot;<span class=\"keyword\">selectedID</span>&quot;&gt;<br /> &nbsp;&nbsp;&nbsp; <span class=\"keyword\">&lt;item&gt;</span>&lt;li class=&quot;<span class=\"vertclair\">{lvl}</span>&quot;&gt; ... <span class=\"vertclair\">{id}</span> ... <span class=\"vertclair\">{label}</span> ... <span class=\"vertclair\">{sublevel}</span> ... &lt;/li&gt;<span class=\"keyword\">&lt;/item&gt;</span><br /> &nbsp;&nbsp;&nbsp; <span class=\"keyword\">&lt;itemselected&gt;</span>&lt;li class=&quot;<span class=\"vertclair\">{lvl}</span>&quot;&gt; ... <span class=\"vertclair\">{id}</span> ... <span class=\"vertclair\">{label}</span> ... <span class=\"vertclair\">{sublevel}</span> ... &lt;/li&gt;<span class=\"keyword\">&lt;/itemselected&gt;</span><br /> &nbsp;&nbsp;&nbsp; <span class=\"keyword\">&lt;template&gt;</span>&lt;ul&gt;<span class=\"vertclair\">{sublevel}</span>&lt;/ul&gt;<span class=\"keyword\">&lt;/template&gt;</span><br /> &lt;/atm-function&gt;<strong><br /> </strong></span></p> <p>Cette Fonction permet d\'afficher une arborescence de cat&eacute;gories.</p> <ul> <strong> </strong>     <li><span class=\"keyword\">rootID </span>: L\'identifiant de la cat&eacute;gorie devant servir de racine &agrave; l\'arborescence.</li>     <li>Le tag &lt;<span class=\"keyword\">item</span>&gt; sera lu pour chaque cat&eacute;gorie &agrave; lister. La valeur <span style=\"font-weight: bold;\"><span class=\"vertclair\">{id}</span> </span>sera remplac&eacute;e par l\'identifiant de la cat&eacute;gorie en cours, la valeur <span class=\"vertclair\">{label}</span> par son libell&eacute;, la valeur <span class=\"vertclair\">{description}</span> par sa description, la valeur <span class=\"vertclair\">{icon}</span> par le tag HTML permettant d\'afficher l\'ic&ocirc;ne. La valeur <span class=\"vertclair\">{lvl}</span> sera remplac&eacute;e par le num&eacute;ro du niveau en cours dans l\'arborescence et la valeur <span class=\"vertclair\">{sublevel}</span> par le niveau suivant dans l\'arborescence.</li>     <li>Le tag &lt;<span class=\"keyword\">template</span>&gt; sera lu au d&eacute;but de chaque niveau d\'arborescence. La valeur <span class=\"vertclair\">{sublevel}</span> sera remplac&eacute;e par le contenu du niveau d\'arborescence en cours.</li>     <li>Le tag &lt;<span class=\"keyword\">itemselected</span>&gt; sera lu pour la cat&eacute;gorie actuellement s&eacute;lectionn&eacute;e (facultatif).</li> </ul> <p><strong>Attributs facultatifs accept&eacute;s :</strong></p> <ul>     <li><span class=\"keyword\">maxLevel </span>: Nombre de niveaux maximum &agrave; afficher pour l\'arborescence.</li>     <li><span class=\"keyword\">selectedID </span>: Cat&eacute;gorie actuellement s&eacute;lectionn&eacute;e.</li>     <li><span class=\"keyword\">usedcategories </span>: Bool&eacute;en <span class=\"vertclair\">true, false</span>.&nbsp;Affiche uniquement les cat&eacute;gories utilis&eacute;es (d&eacute;faut : true).</li>     <li><span class=\"keyword\">disable </span>: Masque une liste de cat&eacute;gorie. Format : Identifiants des cat&eacute;gories &agrave; masquer s&eacute;par&eacute; par des virgules.</li>     <li><span class=\"keyword\">editableonly </span>: Bool&eacute;en <span class=\"vertclair\">true, false</span>. Affiche uniquement les cat&eacute;gories que l\'utilisateur peut &eacute;diter.</li> </ul>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(164, 'polymod', 'fr', '<strong>Hi&eacute;rarchie - Historique de cat&eacute;gories :</strong><br /> <br /> <span class="code"> &lt;atm-function function=&quot;categoryLineage&quot; object=&quot;%s&quot; category=&quot;<span class="keyword">categoryID</span>&quot; root=&quot;<span class="keyword">rootCatID</span>&quot;&gt;<br /> &nbsp;&nbsp;&nbsp; <span class="keyword">&lt;ancestor&gt;</span> ... <span class="vertclair">{id}</span> ... <span class="vertclair">{label}</span> ... <span class="keyword">&lt;/ancestor&gt;</span><br /> &nbsp;&nbsp;&nbsp; <span class="keyword">&lt;self&gt;</span> ... <span class="vertclair">{id}</span> ... <span class="vertclair">{label}</span> ... <span class="keyword">&lt;/self&gt;</span><br /> &lt;/atm-function&gt;</span><strong><br /> </strong>Cette fonction permet d''afficher la hi&eacute;rarchie parente (historique) d''une cat&eacute;gorie donn&eacute;e. <ul> <li><strong><span class="keyword">categoryID </span>: </strong>L''identifiant de la cat&eacute;gorie dont on souhaite afficher la hi&eacute;rarchie.</li> <li><strong><span class="keyword">rootCatID </span>: </strong>L''identifiant de la cat&eacute;gorie à partir de laquelle on souhaite afficher la hi&eacute;rarchie (facultatif si "catégorie de plus haut niveau" sélectionnée, obligatoire dans le cas contraire).</li> <li>Le tag <strong>&lt;<span class="keyword">ancestor</span>&gt;</strong> sera lu pour chaque ancêtre de la cat&eacute;gorie trouv&eacute;. La valeur <span class="vertclair">{id}</span> sera remplac&eacute; par l''identifiant de la cat&eacute;gorie ancêtre, la valeur <span class="vertclair">{label}</span> par son libell&eacute;.</li> <li>Le tag optionel <strong>&lt;<span class="keyword">self</span>&gt;</strong> sera lu pour la cat&eacute;gorie ancêtre dont on affiche la hiérarchie (si le tag n''existe pas, le tag &lt;<span class="keyword">ancestor</span>&gt; sera employ&eacute;). La valeur <span class="vertclair">{id}</span> sera remplac&eacute; par l''identifiant de la cat&eacute;gorie&nbsp; dont on affiche la hiérarchie, la valeur <span class="vertclair">{label}</span> par son libell&eacute;.</li> </ul>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(165, 'polymod', 'fr', '<p><strong>Liste de toutes les catégories d''un champ donné :</strong><br />\r\n<br />\r\n<span class="code">&lt;select ...&gt;&lt;atm-function function="selectOptions" object="%s" selected="<span class="keyword">selectedID</span>"&gt;&lt;/atm-function&gt;&lt;/select&gt;</span><br />\r\nCette fonction permet d''afficher une liste classée par ordre alphabétique de tags &lt;option&gt; contenant toutes les catégories et sous catégories d''un champ donné. Elle est usuellement employée à l''intérieur d''un tag &lt;select&gt;.</p>\r\n<ul>\r\n    <li><span class="keyword">selectedID </span><strong>: </strong>Identifiant de la catégorie à sélectionner dans la liste (facultatif)</li>\r\n</ul>\r\n<p><strong>Attributs facultatifs acceptés :</strong></p>\r\n<ul>\r\n    <li><span class="keyword">usedcategories </span>: Booléen <span class="vertclair">true, false</span>, affiche uniquement les catégories utilisées (défaut : true).</li>\r\n    <li><span class="keyword">usedbyitemsids </span>: Affiche uniquement les catégories employées par les éléments listés. Accepte un liste d''identifiants d''éléments (séparé par une virgule). Employé uniquement si <span class="keyword">usedcategories </span>est utilisé (défaut : false).</li>\r\n    <li><span class="keyword">editableonly </span>: Booléen <span class="vertclair">true, false</span>, affiche uniquement les catégories éditables (défaut : false).</li>\r\n    <li><span class="keyword">root </span>: L''identifiant de la catégorie à employer comme racine.</li>\r\n    <li><span class="keyword">disable </span>: Masque une liste de catégorie. Format : Identifiants des catégories à masquer séparé par des virgules.</li>\r\n    <li><span class="keyword">sort </span>: Tri les catégories affichées par ordre alphabétique de leurs libellés. A ne pas employer en cas d''affichage d''arborescence de catégories. Valeurs acceptées : <span class="vertclair">asc</span> ou <span class="vertclair">desc</span>.</li>\r\n</ul>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(166, 'polymod', 'fr', 'Catégories');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(167, 'polymod', 'fr', 'Permet de catégoriser les objets et de gérer leurs droits d''accès');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(168, 'polymod', 'fr', 'Catégories multiples');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(169, 'polymod', 'fr', 'Catégorie de plus haut niveau');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(170, 'polymod', 'fr', 'Date');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(171, 'polymod', 'fr', 'Champ contenant une date au format de la langue courante');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(172, 'polymod', 'fr', 'Si le champ est vide, enregistrer la date du jour');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(173, 'polymod', 'fr', 'Avec gestion des heures, minutes, secondes');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(174, 'polymod', 'fr', 'hh:mm:ss');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(175, 'polymod', 'fr', 'Lien');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(176, 'polymod', 'fr', 'Champ contenant un lien vers un site externe, une page ou un fichier.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(177, 'polymod', 'fr', 'Nombre entier');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(178, 'polymod', 'fr', 'Nombre entier de 11 chiffres maximum');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(179, 'polymod', 'fr', 'Peut être nul');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(180, 'polymod', 'fr', 'Peut être négatif');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(181, 'polymod', 'fr', 'Champ texte');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(182, 'polymod', 'fr', 'Champ de texte long, avec ou sans HTML');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(183, 'polymod', 'fr', 'HTML autorisé');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(184, 'polymod', 'fr', 'Type de barre d''outil pour l''éditeur de texte (wysiwyg)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(185, 'polymod', 'fr', 'Chaîne de caractères');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(186, 'polymod', 'fr', 'Chaîne contenant 255 caractères maximum sans HTML. Peut être un email.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(187, 'polymod', 'fr', 'Nombre maximum de charactères :<br /><small>(255 maximum)</small>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(188, 'polymod', 'fr', 'Objet inconnu');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(189, 'polymod', 'fr', 'Cet objet n''est pas défini');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(190, 'polymod', 'fr', 'Multiples objets ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(191, 'polymod', 'fr', 'Objet composé de multiples objets ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(192, 'polymod', 'fr', 'Ces objets peuvent être édités ?');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(193, 'polymod', 'fr', 'Création d''un élément ''%s'' à associer');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(194, 'polymod', 'fr', 'Edition d''un objet ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(195, 'polymod', 'fr', 'Eléments ''%s'' actuellement associés');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(196, 'polymod', 'fr', 'Associer un objet ''%s'' existant');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(197, 'polymod', 'fr', 'Forcer le chargement des sous objets ?');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(198, 'polymod', 'fr', 'Attention, ce paramètre doit rester désactivé sauf si des données sont manquantes lors de certains chargements. Activer ce paramètre peut entraîner une perte de performance très importante.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(199, 'polymod', 'fr', 'Uniquement les objets répondant à ces paramètres');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(200, 'polymod', 'fr', 'Image');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(201, 'polymod', 'fr', 'Champ contenant une image avec ou sans image zoom');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(202, 'polymod', 'fr', 'Largeur maximum de la vignette en pixels');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(203, 'polymod', 'fr', 'Date de début de publication formatée. Remplacez ''format'' par la valeur correspondant au format accepté en PHP pour la <a href="http://www.php.net/date" class="admin" target="_blank">''fonction date''</a>. Pour une date employ&eacute;e dans un Fil RSS, utilisez la valeur ''<strong>rss</strong>'' pour sp&eacute;cifier le format.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(204, 'polymod', 'fr', 'Date de fin de publication formatée (si elle existe). Remplacez ''format'' par la valeur correspondant au format accepté en PHP pour la <a href="http://www.php.net/date" class="admin" target="_blank">''fonction date''</a>. Pour une date employ&eacute;e dans un Fil RSS, utilisez la valeur ''<strong>rss</strong>'' pour sp&eacute;cifier le format.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(205, 'polymod', 'fr', 'Par défaut, proposer d''utiliser l''image originale comme image zoom');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(206, 'polymod', 'fr', 'Vignette');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(207, 'polymod', 'fr', 'Image zoom');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(208, 'polymod', 'fr', '(La vignette sera redimensionnée à %s pixels de large)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(209, 'polymod', 'fr', 'Par défaut, proposer d''utiliser une image zoom distincte');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(211, 'polymod', 'fr', 'Conserver l''image originale comme image zoom');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(212, 'polymod', 'fr', '(Si la vignette dépasse cette largeur elle sera redimensionnée)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(213, 'polymod', 'fr', 'Cochez la case pour effacer l''image');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(214, 'polymod', 'fr', 'Image actuelle');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(215, 'polymod', 'fr', 'Code HTML de l''image. Le titre du lien peut être modifié grace à un paramètre (facultatif)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(216, 'polymod', 'fr', 'Libellé de l''image');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(217, 'polymod', 'fr', 'Nom du fichier de l''image');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(218, 'polymod', 'fr', 'Nom du fichier de l''image zoom');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(219, 'polymod', 'fr', 'Chemin du répertoire de l''image et de l''image zoom');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(220, 'polymod', 'fr', 'Largeur de l''image en pixels');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(221, 'polymod', 'fr', 'Hauteur de l''image en pixels');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(222, 'polymod', 'fr', 'Largeur de l''image zoom en pixels');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(223, 'polymod', 'fr', 'Hauteur de l''image zoom en pixels');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(224, 'polymod', 'fr', 'Poids de l''image en Mo');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(225, 'polymod', 'fr', 'Poids de l''image zoom en Mo');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(226, 'polymod', 'fr', 'La valeur du champ doit être un email valide');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(227, 'polymod', 'fr', 'Fichier');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(228, 'polymod', 'fr', 'Champ contenant un fichier avec ou sans vignette');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(229, 'polymod', 'fr', 'Largeur maximum de la vignette en pixels');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(230, 'polymod', 'fr', 'Utiliser une vignette pour le fichier');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(231, 'polymod', 'fr', '<!--Icônes de type pour les fichiers-->');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(232, 'polymod', 'fr', 'Fichier source');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(233, 'polymod', 'fr', 'ou Fichier FTP');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(234, 'polymod', 'fr', 'Chemin du repertoire FTP à utiliser');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(235, 'polymod', 'fr', '(Laissez vide pour empêcher l''utilisation d''un répertoire FTP comme source pour vos documents)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(236, 'polymod', 'fr', '(max : %s)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(237, 'polymod', 'fr', '(Répertoire FTP : %s)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(238, 'polymod', 'fr', 'Chemin vers l''icône du fichier (si elle existe)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(239, 'polymod', 'fr', 'Type de fichier (extension)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(240, 'polymod', 'fr', 'Cochez la case pour effacer le fichier');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(241, 'polymod', 'fr', 'Fichier actuel');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(242, 'polymod', 'fr', 'Code HTML du fichier');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(243, 'polymod', 'fr', 'Libellé du fichier');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(244, 'polymod', 'fr', 'Nom du fichier');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(245, 'polymod', 'fr', 'Nom du fichier de la vignette');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(246, 'polymod', 'fr', 'Chemin du répertoire du fichier et de la vignette');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(247, 'polymod', 'fr', 'Largeur de la vignette en pixels');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(248, 'polymod', 'fr', 'Hauteur de la vignette en pixels');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(249, 'polymod', 'fr', 'Autoriser l''utilisation de fichiers du répertoire FTP');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(250, 'polymod', 'fr', '(Permet d''utiliser un répertoire d''Automne pour déposer des gros fichiers via FTP)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(251, 'polymod', 'fr', 'Poids du fichier en Mo');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(252, 'polymod', 'fr', 'Renvoi vrai si l''objet contient un lien valide.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(253, 'polymod', 'fr', 'Largeur maximum de l''image en pixels');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(254, 'polymod', 'fr', 'Adresse de prévisualisation');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(255, 'polymod', 'fr', 'Valeur HTML du texte (retours chariots convertis pour le texte seul)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(256, 'polymod', 'fr', 'Fichier associé à la catégorie du champ');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(257, 'polymod', 'fr', 'Fichier d''une catégorie du champ (utilisable dans un tag atm-loop)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(258, 'polymod', 'fr', 'Sans %s');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(259, 'polymod', 'fr', 'Nombre d''utilisateurs/groupes associés à ce champ');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(260, 'polymod', 'fr', 'Utilisateurs/Groupes associés à ce champ. Cette valeur est usuellement utilisée par un tag atm-loop');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(261, 'polymod', 'fr', 'Identifiant d''un utilisateur/groupe du champ (utilisable dans un tag atm-loop)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(262, 'polymod', 'fr', 'Nom et prénom d''un utilisateur ou nom d''un groupe du champ (utilisable dans un tag atm-loop)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(263, 'polymod', 'fr', 'Identifiant de l''utilisateur ou du groupe');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(264, 'polymod', 'fr', 'Utilisateur/Groupe');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(265, 'polymod', 'fr', 'Permet d''associer un ou plusieurs utilisateurs ou groupe(s) d''utilisateurs');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(266, 'polymod', 'fr', 'Multiples utilisateurs ou groupes');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(267, 'polymod', 'fr', 'Utiliser des groupes');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(268, 'polymod', 'fr', 'La valeur est l''utilisateur actuel');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(269, 'polymod', 'fr', 'Ce paramètre exclut les autres');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(270, 'polymod', 'fr', 'Si ce paramètre est sélectionné, vous pourrez utiliser des groupes d''utilisateurs. Sinon, ce sera des utilisateurs');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(271, 'polymod', 'fr', '<strong>Liste de tous les utilisateurs/groupes du champ :<br />\n</strong><br />\n<span class="code"> &lt;select&gt;<strong>&lt;</strong>atm-function function=&quot;selectOptions&quot; object=&quot;%s&quot; selected=&quot;<span class="keyword">selectedID</span><strong>&quot;&gt;&lt;/</strong>atm-function<strong>&gt;</strong>&lt;/select&gt;</span><br />\nCette fonction permet d''afficher une liste class&eacute;e par ordre alphab&eacute;tique de tags &lt;option&gt; contenant tous les utilisateurs/groupes du champ donn&eacute; en param&egrave;tre. Elle est usuellement employ&eacute;e &agrave; l''int&eacute;rieur d''un tag &lt;select&gt;.<br />\n<ul>\n	<li><span class="keyword">selectedID </span><strong>: </strong>Identifiant de l''utilisateur/groupe &agrave; selectionner dans la liste</li>\n</ul>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(272, 'polymod', 'fr', 'Nom et prénom de l''utilisateur ou nom du groupe');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(273, 'polymod', 'fr', 'Email d''un utilisateur du champ (utilisable dans un tag atm-loop)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(274, 'polymod', 'fr', 'Email de l''utilisateur');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(275, 'polymod', 'fr', 'Modules WYSIWYG associés');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(276, 'polymod', 'fr', 'Propriétés de l''objet');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(277, 'polymod', 'fr', 'Création / modification d''un module WYSIWYG pour l''objet ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(278, 'polymod', 'fr', 'Syntaxe de la définition du module WYSIWYG pour l''objet ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(279, 'polymod', 'fr', 'Confirmez-vous la suppression du module WYSIWYG ''%s'' ? Attention cette suppression est définitive, elle n''est pas soumise à validation et elle impactera tous les objets ainsi que tous les fichiers correspondant à ce module !');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(280, 'polymod', 'fr', '[Erreur : Aucun module WYSIWYG disponible ...]');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(281, 'polymod', 'fr', 'Type');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(282, 'polymod', 'fr', 'Editeur de texte');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(283, 'polymod', 'fr', 'Elément actuellement sélectionné');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(284, 'polymod', 'fr', 'Sélectionner');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(285, 'polymod', 'fr', 'Déselectionner');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(286, 'polymod', 'fr', '[Erreur : Ce module nécessite d''avoir sélectionné un texte. Merci de sélectionner le texte souhaité ...]');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(287, 'polymod', 'fr', 'Modules WYSIWYG');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(288, 'polymod', 'fr', '
<div class="rowComment"> 
<h1>Bloc de données d''un module WYSIWYG :</h1>
<p><span class="code"> &lt;atm-plugin language="<span class="keyword">languageCode</span>"&gt;<br />
&#160;&#160;&#160; <span class="keyword">&lt;atm-plugin-valid&gt;</span><br />
&#160;&#160;&#160; &#160;&#160;&#160; ...<br />
&#160;&#160;&#160; <span class="keyword">&lt;/atm-plugin-valid&gt;</span><br />
&#160;&#160;&#160; <span class="keyword">&lt;atm-plugin-invalid&gt;</span><br />
&#160;&#160;&#160; &#160;&#160;&#160; ...<br />
&#160;&#160;&#160; <span class="keyword">&lt;/atm-plugin-invalid&gt;</span><br />
&#160;&#160;&#160; <span class="keyword">&lt;atm-plugin-view&gt;</span><br />
&#160;&#160;&#160;&#160;&#160;&#160;&#160; ...<br />
&#160;&#160;&#160; <span class="keyword">&lt;/atm-plugin-view&gt;</span><br />
&lt;/atm-plugin&gt;</span><br />
<br />
Ce tag permet l''affichage de données spécifiques à un objet dans l''éditeur de texte visuel (WYSIWYG).<br />
Le <span class="keyword">tag atm-plugin-valid</span> sera lu si l''objet sélectionné est valide (non supprimé, validé et en cours de publication).</p>
<p><br />
Le tag <span class="keyword">atm-plugin-invalid </span>(facultatif) sera lu si l''objet sélectionné est invalide (supprimé, non validé ou dont les dates de publication sont dépassées ou si l''utilisateur n''a pas les droits de consultation de cet objet).</p>
<p><br />
Le tag <span class="keyword">atm-plugin-view</span> (facultatif) remplacera le tag atm-plugin-valid dans l''éditeur de texte visuel (WYSIWYG). Il est principalement utilisé pour afficher une version simplifié des données et ainsi faciliter la modification du contenu de l''éditeur.</p>
<ul>
    <li><span class="keyword">languageCode </span>: Code du langage relatif au contenu parmi les codes suivants : <span class="vertclair">%s</span>.</li>
    <li><span class="keyword">{plugin:selection}</span> : Sera replacé par la valeur textuelle sélectionnée dans l''éditeur (facultatif).</li>
</ul>
</div>
');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(289, 'polymod', 'fr', '<strong>Charge une cat&eacute;gorie donn&eacute;e :<br />\n</strong><br />\n<span class="code"> &lt;atm-function function=&quot;category&quot; object=&quot;%s&quot; category=&quot;<span class="keyword">categoryID</span>&quot;&gt;<br />\n&nbsp;&nbsp;&nbsp; ... <span class="vertclair">{id}</span> ... <span class="vertclair">{label}</span> ... <br />\n&lt;/atm-function&gt;</span><strong><br />\n</strong>Cette fonction permet d''afficher le contenu d''une cat&eacute;gorie donn&eacute;e.<br />\n<ul>\n	<li><span class="keyword">categoryID </span><strong>: </strong>L''identifiant de la cat&eacute;gorie dont on souhaite afficher la hi&eacute;rarchie.</li>\n	<li>La valeur <span class="vertclair">{id}</span> sera remplac&eacute; par l''identifiant de la cat&eacute;gorie anc&egrave;tre, la valeur <span class="vertclair">{label}</span> par son libell&eacute;.</li>\n</ul>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(290, 'polymod', 'fr', 'Fils RSS associés');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(291, 'polymod', 'fr', 'Confirmez-vous la suppression du fil RSS ''%s'' ? Attention cette suppression est définitive, elle n''est pas soumise à validation et elle impactera tous les objets ainsi que tous les fichiers correspondant à ce module !');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(292, 'polymod', 'fr', 'Création / modification d''un fil RSS pour l''objet ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(293, 'polymod', 'fr', 'Syntaxe de la définition du fil RSS pour l''objet ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(294, 'polymod', 'fr', 'Fils RSS');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(295, 'polymod', 'fr', '<strong>Bloc de donn&eacute;es d''un module WYSIWYG :<br /><br />&lt;atm-plugin language=&quot;</strong>languageCode<strong>&quot;&gt;<br />&nbsp;&nbsp;&nbsp; &lt;atm-plugin-valid&gt;<br />&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; ...<br />&nbsp;&nbsp;&nbsp; &lt;/atm-plugin-valid&gt;<br />&nbsp;&nbsp;&nbsp; &lt;atm-plugin-invalid&gt;<br />&nbsp;&nbsp;&nbsp; &nbsp;&nbsp;&nbsp; ...<br />&nbsp;&nbsp;&nbsp; &lt;/atm-plugin-invalid&gt;<br />&lt;/atm-plugin&gt;</strong><br /><br />Ce tag permet l''affichage de donn&eacute;es sp&eacute;cifiques &agrave; un objet dans l''&eacute;diteur de texte visuel (WYSIWYG).<br />Le tag <strong>atm-plugin-valid</strong> sera lu si l''objet s&eacute;lectionn&eacute; est valide (non supprim&eacute;, valid&eacute; et en cours de publication).<br />Le tag <strong>atm-plugin-invalid</strong> (facultatif) sera lu si l''objet s&eacute;lectionn&eacute; est invalide (supprim&eacute;, non valid&eacute; ou dont les dates de publication sont d&eacute;pass&eacute;es ou si l''utilisateur n''a pas les droits de consultation de cet objet).<br /><ul><li><strong>languageCode</strong> : Code du langage relatif au contenu parmi les codes suivants : <strong>%s</strong>.</li><li><strong>{plugin:selection}</strong> : Sera replac&eacute; par la valeur s&eacute;lectionn&eacute;e dans le Wysiwyg (facultatif).</li></ul>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(296, 'polymod', 'fr', 'Adresse vers le site du fil');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(297, 'polymod', 'fr', 'Ce lien sera employé dans le fil RSS et permettra d''aller au site source du fil. Si ce champ n''est pas rempli, l''adresse ''%s'' sera utilisée.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(298, 'polymod', 'fr', 'Auteur');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(299, 'polymod', 'fr', 'Email de l''auteur');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(300, 'polymod', 'fr', 'Copyright');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(301, 'polymod', 'fr', 'Catégories');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(302, 'polymod', 'fr', 'Liste de termes séparés par des virgules permettant de catégoriser le fil RSS');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(303, 'polymod', 'fr', 'Interval de mise à jour');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(304, 'polymod', 'fr', 'Permet aux lecteurs de fils RSS d''avoir une valeur indicative concernant la fréquence de mise à jour du fil. Par défaut : 1 fois par jour, minimum : 2 fois par heure.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(305, 'polymod', 'fr', 'Fréquence dans cet interval');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(306, 'polymod', 'fr', 'Horaire');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(307, 'polymod', 'fr', 'Quotidienne');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(308, 'polymod', 'fr', 'Hebdomadaire');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(309, 'polymod', 'fr', 'Mensuelle');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(310, 'polymod', 'fr', 'Annuelle');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(311, 'polymod', 'fr', '<strong>Permet de faire un lien vers l''un des fil RSS de l''objet&nbsp; :<br /> </strong><br /> <span class="code">&lt;atm-function function=&quot;rss&quot; object=&quot;%s&quot; selected=&quot;<span class="keyword">rssId</span>&quot; attributeName=&quot;<span class="keyword">attributeValue</span>&quot;&gt;<br /> &nbsp;&nbsp;&nbsp; &lt;a href=&quot;<span class="vertclair">{url}</span>&quot; title=&quot;<span class="vertclair">{description}</span>&quot;&gt;<span class="vertclair">{label}</span>&lt;/a&gt;<br /> &lt;/atm-function&gt;</span><br /> Cette fonction permet d''obtenir les informations concernant l''un des fil RSS de l''objet. Elle est usuellement utilis&eacute;e pour r&eacute;aliser un lien d''abonnement vers ce fil RSS.<br /> <ul> <li><span class="keyword">rssId </span><strong>: </strong>Identifiant du fil RSS &agrave; selectionner parmi les suivants : %s</li> <li>L''attribut <span class="keyword">attributeName </span>et sa valeur <span class="keyword">attributeValue </span>sont facultatifs. Ils permettent d''ajouter un attribut et sa valeur &agrave; l''adresse du fil RSS g&eacute;n&eacute;r&eacute; par la fonction. Vous pouvez mettre autant d''attributs suppl&eacute;mentaires de cette fa&ccedil;on.</li> <li><span class="vertclair">{url}</span> sera remplac&eacute; par l''adresse du fil RSS.</li> <li><span class="vertclair">{label}</span> sera remplac&eacute; par le libell&eacute; du fil RSS.</li> <li><span class="vertclair">{description}</span> sera remplac&eacute; par la description du fil RSS.</li> </ul>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(312, 'polymod', 'fr', '<strong>Permet de charger un objet par son identifiant&nbsp; :<br />\n<br />\n</strong><span class="code">&lt;atm-function function=&quot;loadObject&quot; object=&quot;%s&quot; value=&quot;<span class="keyword">objectId</span>&quot;&gt;&lt;/atm-function&gt;</span><br />\nCette fonction permet de charger depuis la base de donn&eacute;e l''objet correspondant &agrave; l''identifiant fourni en param&egrave;tre. L''objet ainsi charg&eacute; devient accessible m&ecirc;me en dehors d''une recherche.<br />\n<ul>\n	<li><span class="keyword">objectId </span><strong>: </strong>Identifiant unique de l''objet &agrave; charger.</li>\n</ul>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(313, 'polymod', 'fr', '<div class=\"rowComment\"><h1>Bloc de données d\'un fil RSS :</h1><span class=\"code\">&lt;atm-rss language=\"<span class=\"keyword\">languageCode</span>\"&gt;<br />&#160;&#160;&#160; <span class=\"keyword\">&lt;atm-rss-title&gt;</span> ... <span class=\"keyword\">&lt;/atm-rss-title&gt;</span><br />&#160;&#160;&#160; &lt;atm-search ...&gt;<br />&#160;&#160;&#160; &#160;&#160;&#160; ...<br />&#160;&#160;&#160; &#160;&#160;&#160; &lt;atm-result ...&gt;<br />&#160;&#160;&#160; &#160;&#160;&#160; &#160;&#160;&#160;<span class=\"keyword\"> &lt;atm-rss-item&gt;</span><br />&#160;&#160;&#160; &#160;&#160;&#160; &#160;&#160;&#160; &#160;&#160;&#160; <span class=\"keyword\">&lt;atm-rss-item-url&gt;</span>{page:id:url}?item={object:id}<span class=\"keyword\">&lt;/atm-rss-item-url&gt; </span><br />&#160;&#160;&#160; &#160;&#160;&#160; &#160;&#160;&#160; &#160;&#160;&#160; <span class=\"keyword\">&lt;atm-rss-item-title&gt;</span> ... <span class=\"keyword\">&lt;/atm-rss-item-title&gt;</span><br />&#160;&#160;&#160; &#160;&#160;&#160; &#160;&#160;&#160; &#160;&#160;&#160; <span class=\"keyword\">&lt;atm-rss-item-content&gt;</span> ... <span class=\"keyword\">&lt;/atm-rss-item-content&gt;</span><br />&#160;&#160;&#160; &#160;&#160;&#160; &#160;&#160;&#160; &#160;&#160;&#160; <span class=\"keyword\">&lt;atm-rss-item-author&gt;</span> ... <span class=\"keyword\">&lt;/atm-rss-item-author&gt;</span><br />&#160;&#160;&#160; &#160;&#160;&#160; &#160;&#160;&#160; &#160;&#160;&#160; <span class=\"keyword\">&lt;atm-rss-item-date&gt;</span> ... <span class=\"keyword\">&lt;/atm-rss-item-date&gt;</span><br />&#160;&#160;&#160; &#160;&#160;&#160; &#160;&#160;&#160; &#160;&#160;&#160; <span class=\"keyword\">&lt;atm-rss-item-category&gt;</span> ... <span class=\"keyword\">&lt;/atm-rss-item-category&gt;</span><br />&#160;&#160;&#160; &#160;&#160;&#160; &#160;&#160;&#160; <span class=\"keyword\">&lt;/atm-rss-item&gt;</span><br />&#160;&#160;&#160; &#160;&#160;&#160; &lt;/atm-result&gt;<br />&#160;&#160;&#160; &lt;/atm-search&gt;<br />&lt;/atm-rss&gt;</span><br /><br />Ce tag permet de créer un fil RSS à partir d\'objets répondant à une recherche.<br /><ul><li><strong><span class=\"keyword\">languageCode </span></strong>: Code du langage relatif au contenu parmi les codes suivants : <strong><span class=\"vertclair\">%s</span></strong>. Vous pouvez employer une variable pour spécifier dynamiquement la langue de ce flux RSS (ex: <span class=\"vertclair\">{request:string:language}</span> ).</li></ul>Le tag <span class=\"keyword\">atm-rss</span> peut contenir un tag <span class=\"keyword\">atm-rss-title</span> (facultatif) permettant de redéfinir le titre du fil RSS. <br />Le tag <span class=\"keyword\">atm-rss</span><strong> </strong>doit contenir un sous tag <span class=\"keyword\">atm-rss-item</span> lui même devant être dans un résultat d\'une recherche. Pour chaque élément résultat de la recherche, ce tag permettra la création d\'un élément correspondant dans le fil RSS.<br /><br />Le tag <span class=\"keyword\">atm-rss-item</span> doit<strong> </strong>contenir les sous tags suivants :<br /><ul><li><span class=\"keyword\">atm-rss-item-url</span><strong> :</strong> Tag obligatoire, il permet de spécifier l\'adresse internet source de l\'élément du fil RSS (Les aggrégateurs RSS s\'en servent pour créer un lien vers cet élément sur votre site). Ce doit donc être une adresse valide vers l\'élément source. Un seul tag de ce type est permit dans chaque tag atm-rss-item.</li><li><span class=\"keyword\">atm-rss-item-title</span><strong> : </strong>Tag obligatoire, il permet de spécifier le nom de l\'élément du fil RSS. Le code HTML n\'y est pas autorisé. Un seul tag de ce type est permit dans chaque tag atm-rss-item.</li><li><span class=\"keyword\">atm-rss-item-content</span><strong> : </strong>Tag obligatoire, il permet de spécifier le contenu de l\'élément du fil RSS. Le code HTML y est autorisé. Un seul tag de ce type est permit dans chaque tag atm-rss-item.</li></ul>Le tag <span class=\"keyword\">atm-rss-item</span> peut<strong> </strong>contenir les sous tags suivants :<br /><ul><li><span class=\"keyword\">atm-rss-item-author</span><strong> : </strong>Ce tag permet de spécifer l\'auteur de l\'élément du fil RSS. Le code HTML n\'y est pas autorisé. Un seul tag de ce type est permit dans chaque tag atm-rss-item.</li><li><span class=\"keyword\">atm-rss-item-date</span><strong> :</strong> Ce tag permet de spécifer la date de création de l\'élément du fil RSS. Le code HTML n\'y est pas autorisé. Un seul tag de ce type est permit dans chaque tag atm-rss-item. Pensez à employer le format <span class=\"vertclair\">rss</span> si vous employez la valeur d\'un champ de type Date.</li><li><span class=\"keyword\">atm-rss-item-category</span><strong> :</strong> Ce tag permet de spécifer une le nom d\'une catégorie pour l\'élément du fil RSS. Le code HTML n\'y est pas autorisé. Vous pouvez mettre plusieurs tags de ce type dans chaque tag atm-rss-item.</li></ul></div>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(314, 'polymod', 'fr', 'Utilisateurs');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(315, 'polymod', 'fr', 'Groupes');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(316, 'polymod', 'fr', 'Tous les utilisateurs');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(317, 'polymod', 'fr', 'Utilisateurs inclus/exclus');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(318, 'polymod', 'fr', 'Tous les groupes');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(319, 'polymod', 'fr', 'Groupes inclus/exclus');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(320, 'polymod', 'fr', 'Inclusion');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(321, 'polymod', 'fr', 'Si ce paramètre est à :<br/>"oui" : seuls les utilisateurs/groupes sélectionnés sont affichés dans la liste déroulante du champ.<br/>"non" : les utilisateurs sélectionnés sont exclus de la liste déroulante du champ.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(322, 'polymod', 'fr', 'Indexé dans le moteur de recherche');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(323, 'polymod', 'fr', 'Langue');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(324, 'polymod', 'fr', 'Langue de l''objet. Créé une relation avec les langues disponibles sur le système. Nécessaire à l''indexation correcte dans le moteur de recherche.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(325, 'polymod', 'fr', 'Indexé dans le moteur de recherche');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(326, 'polymod', 'fr', 'Indexation');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(327, 'polymod', 'fr', 'Si cet objet appartient en tant que champ à un objet indexé, inutile de l''indexer lui même');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(328, 'polymod', 'fr', 'Adresse du lien vers l''objet');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(329, 'polymod', 'fr', 'Cette adresse devra permettre d''aller vers l''objet à partir des résultats de recherche.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(330, 'polymod', 'fr', 'Indexer uniquement le dernier sous-objet');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(331, 'polymod', 'fr', 'Cette option est utile pour le versioning d''objets quand les versions antérieures ne doivent pas être indexées dans le moteur de recherche.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(332, 'polymod', 'fr', 'Désactiver l''association de sous-objets');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(333, 'polymod', 'fr', 'Cette option permet d''empêcher l''emploi de sous-objets créés en dehors de l''objet principal. Elle n''est utile que si l''option "Ces objets peuvent être édités" est active.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(334, 'polymod', 'fr', 'Contourner les droits');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(335, 'polymod', 'fr', 'Permet de ne pas tenir compte des droits de ces catégories pour les recherches');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(336, 'polymod', 'fr', 'Notification par email');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(337, 'polymod', 'fr', 'Ce champ permet d''envoyer une notification par email lors de la validation d''un objet');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(338, 'polymod', 'fr', 'Sujet de l''email');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(339, 'polymod', 'fr', 'Corps de l''email');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(340, 'polymod', 'fr', 'Emission au choix');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(341, 'polymod', 'fr', 'Hauteur de l''éditeur');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(342, 'polymod', 'fr', 'Largeur de l''éditeur');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(343, 'polymod', 'fr', 'Permet de choisir lors de l''édition de l''objet si l''email doit être envoyé');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(344, 'polymod', 'fr', 'Inclure des fichiers');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(345, 'polymod', 'fr', 'Permet d''inclure les fichiers de l''objet en pièce jointe dans l''email');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(346, 'polymod', 'fr', 'Emetteur de l''email');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(347, 'polymod', 'fr', 'Permet de spécifier une adresse d''emetteur pour l''email. Si aucun, l''adresse "postmaster" d''Automne sera employée.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(348, 'polymod', 'fr', 'A la validation');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(349, 'polymod', 'fr', 'Evénement système');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(350, 'polymod', 'fr', 'Emission');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(351, 'polymod', 'fr', 'L''email sera envoyé à la validation de l''objet ou déclenché par un événement système à spécifier (code PHP spécifique).');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(352, 'polymod', 'fr', 'Syntaxe de la définition du sujet et du corps de l''email');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(353, 'polymod', 'fr', 'Où choisir une page');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(354, 'polymod', 'fr', 'Code HTML');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(355, 'polymod', 'fr', 'Dernier envoi');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(356, 'polymod', 'fr', 'Jamais');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(357, 'polymod', 'fr', 'Actif');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(358, 'polymod', 'fr', 'Inactif');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(359, 'polymod', 'fr', 'Préparation des notifications par email');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(360, 'polymod', 'fr', 'Envoi d''une notification email');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(361, 'polymod', 'fr', 'Autoriser l''association des inutilisées');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(362, 'polymod', 'fr', 'Permet de sélectionner les catégories inutilisées dans les rangées');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(363, 'polymod', 'fr', 'Libellé des objets (séparés par des virgules, ou spécifiez un séparateur en paramètre)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(364, 'polymod', 'fr', 'Notification de validation en attente');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(365, 'polymod', 'fr', 'Notification de suppression en attente');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(366, 'polymod', 'fr', 'Champ requis (renvoie un booléen true ou false)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(367, 'polymod', 'fr', 'Catégorie par défaut');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(368, 'polymod', 'fr', 'Date de création de l''objet');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(369, 'polymod', 'fr', 'Décalage temporel');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(370, 'polymod', 'fr', 'Si "Date du jour", "Date de création" ou "Date de mise à jour" est sélectionné, décaler la valeur de cette durée (Voir le <a href="http://www.php.net/manual/fr/function.strtotime.php" target="_blank" class="admin">format de la fonction strtotime</a>)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(371, 'polymod', 'fr', 'Date de mise à jour de l''objet');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(372, 'polymod', 'fr', 'Format à respecter');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(373, 'polymod', 'fr', 'Ce champ vous permet de spécifier un format à respecter en utilisant une expression régulière PERL (<a href="http://www.php.net/manual/fr/reference.pcre.pattern.syntax.php" target="_blank" class="admin">voir l''aide du format</a>)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(374, 'polymod', 'fr', 'Extensions autorisées');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(375, 'polymod', 'fr', 'Séparées par une virgule');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(376, 'polymod', 'fr', 'Extensions interdites');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(377, 'polymod', 'fr', 'Utilisateur créant l''objet');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(378, 'polymod', 'fr', 'Opérateurs des filtres de recherche pour ce champ');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(379, 'polymod', 'fr', 'Un opérateur permet de modifier le fonctionnement d''un filtre (tag <span class="keyword">atm-search-param</span>) dans une recherche. Il s''ajoute au filtre en ajoutant le paramètre <span class="keyword">operator</span> suivit de la valeur souhaitée au tag <span class="keyword">atm-search-param</span> proposant un filtre sur ce champ. Les valeurs suivantes sont possibles :');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(380, 'polymod', 'fr', '<br/><span class="keyword">&gt;=</span> : supérieur ou égal<br/><span class="keyword">&lt;=</span> : inférieur ou égal<br/><span class="keyword">&lt;</span> : inférieur<br/><span class="keyword">&gt;</span> : supérieur<br/><span class="keyword">&gt;= or null</span> : supérieur ou égal ou nul<br/><span class="keyword">&lt;= or null</span> : inférieur ou égal ou nul<br/><span class="keyword">&lt; or null</span> : inférieur ou nul<br/><span class="keyword">&gt; or null</span> : supérieur ou nul<br/><span class="keyword">&gt;= and not null</span> : (supérieur ou égal) et non nul<br/><span class="keyword">&lt;= and not null</span> : (inférieur ou égal) et non nul<br/><span class="keyword">&lt; and not null</span> : inférieur et non nul<br/><span class="keyword">&gt; and not null</span> : supérieur et non nul');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(381, 'polymod', 'fr', 'Ne recherche que les objets associés à la catégorie en paramètre (les sous-catégories ne sont plus prises en compte)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(382, 'polymod', 'fr', 'Tags de formulaires (création - modification)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(383, 'polymod', 'fr', '<div class=\"rowComment\"><h1>Création modification d\'objets coté client :</h1><p><span class=\"code\">&lt;atm-form what=\"<span class=\"keyword\">objet</span>\" name=\"<span class=\"keyword\">formName</span>\"&gt; ... &lt;/atm-form&gt;</span><br />Ce tag permet de créer un formulaire de saisie pour un nouvel objet (si ce tag n\'est pas dans un résultat de recherche)ou de modification pour un objet existsnat (si ce tag se trouve dans un résultat de recherche.</p><ul>    <li><span class=\"keyword\">objet</span> : Type d\'objet à saisir (de la forme <span class=\"vertclair\">{<span class=\"keyword\">objet</span>}</span>)</li>    <li><span class=\"keyword\">formName</span> : Nom du formulaire : identifiant unique pour le formulaire dans la rangée.</li></ul><p>Ce tag peut ensuite avoir tout une suite d\'attributs html qui seront ajoutés sur le code HTML du tag form généré (<span class=\"vertclair\">width, height, id, class, etc.</span>).</p><p>Les valeurs suivantes seront remplacées dans le tag :</p><ul>    <li><span class=\"vertclair\">{filled}</span> : Vrai si le formulaire a été correctement rempli et que sa validation n\'a provoqué aucune erreur.</li>    <li><span class=\"vertclair\">{required}</span> : Vrai si le formulaire n\'a pas été correctement rempli et que des champs requis ont été laissés vides.</li>    <li><span class=\"vertclair\">{malformed}</span> : Vrai si le formulaire n\'a pas été correctement rempli et que les values de certains champs sont incorrectes.</li>    <li><span class=\"vertclair\">{error}</span> : Vrai si le formulaire a généré une erreur.</li></ul><h2>Ce tag peut contenir les sous-tags suivants :</h2><div class=\"retrait\"><h3>Affichage des champs requis :</h3><div class=\"retrait\"><span class=\"code\">&lt;atm-form-required form=\"<span class=\"keyword\">formName</span>\"&gt;<br />&#160;&#160;&#160; ... <span class=\"vertclair\">{requiredname}</span> ...<br />&lt;/atm-form-required&gt;</span><br />Le contenu du tag sera lu pour chaque champ requis lors de la saisie du formulaire.<br /><ul>    <li><span class=\"keyword\">formName</span> : Nom du formulaire sur lequel appliquer le tag.</li></ul><p>Les valeurs suivantes seront remplacées dans le tag :</p><ul>    <li><span class=\"vertclair\">{firstrequired}</span> : Vrai si le champ requis en cours est le premier du formulaire en cours.</li>    <li><span class=\"vertclair\">{last</span><span class=\"vertclair\">required</span><span class=\"vertclair\">}</span> : Vrai si le champ requis en cours est le dernier du formulaire en cours.</li>    <li><span class=\"vertclair\">{</span><span class=\"vertclair\">required</span><span class=\"vertclair\">count}</span> : Numéro du champ requis dans le formulaire en cours.</li>    <li><span class=\"vertclair\">{max</span><span class=\"vertclair\">required</span><span class=\"vertclair\">}</span> : Nombre de champs requis dans le formulaire en cours.</li>    <li><span class=\"vertclair\">{</span><span class=\"vertclair\">required</span><span class=\"vertclair\">name}</span> : Nom du champ requis dans le formulaire en cours.</li>    <li><span class=\"vertclair\">{</span><span class=\"vertclair\">required</span><span class=\"vertclair\">field}</span> : Objet champ requis dans le formulaire en cours.</li></ul></div><h3>Affichage des champs malformés :</h3><div class=\"retrait\"><span class=\"code\">&lt;atm-form-malformed form=\"<span class=\"keyword\">formName</span>\"&gt;<br />&#160;&#160;&#160; ... <span class=\"vertclair\">{malformedname}</span> ...<br />&lt;/atm-form-malformed&gt;</span><br />Le contenu du tag sera lu pour chaque champ malformé lors de la saisie du formulaire.<br /><ul>    <li><span class=\"keyword\">formName</span> : Nom du formulaire sur lequel appliquer le tag.</li></ul><p>Les valeurs suivantes seront remplacées dans le tag :</p><ul>    <li><span class=\"vertclair\">{firstmalformed}</span> : Vrai si le champ malformé en cours est le premier du formulaire en cours.</li>    <li><span class=\"vertclair\">{lastmalformed}</span> : Vrai si le champ malformé en cours est le dernier du formulaire en cours.</li>    <li><span class=\"vertclair\">{malformedcount}</span> : Numéro du champ malformé dans le formulaire en cours.</li>    <li><span class=\"vertclair\">{maxmalformed}</span> : Nombre de champs malformés dans le formulaire en cours.</li>    <li><span class=\"vertclair\">{malformedname}</span> : Nom du champ malformé dans le formulaire en cours.</li>    <li><span class=\"vertclair\">{malformedfield}</span> : Objet champ malformé dans le formulaire en cours.</li></ul></div><h3>Affichage d\'un champ de saisie :</h3><div class=\"retrait\"><span class=\"code\">&lt;atm-input field=\"<span class=\"keyword\">{objet:champ}</span>\" form=\"<span class=\"keyword\">formName</span>\" /&gt;</span><br />Ce tag sera remplacé par la zone de saisie (champ de formulaire) nécessaire à la saisie correcte des informations relatives au type du champ spécifié.<br /><ul>    <li><span class=\"keyword\">formName</span> : Nom du formulaire sur lequel appliquer le tag.</li>    <li><span class=\"keyword\">{objet:champ}</span> : Champ de l\'objet géré par le formulaire sur lequel la saisie doit être effectuée.</li></ul><p>Ce tag peut ensuite avoir tout une suite d\'attributs html qui seront ajoutés sur le code HTML du tag input généré (<span class=\"vertclair\">width, height, id, class, etc.</span>).</p><p>Si vous souhaitez obtenir un champ caché, vous pouvez employer l\'attribut <span class=\"vertclair\">hidden=\"1\"</span>. Vous pouvez aussi spécifier une valeur pour votre champ caché à l\'aide de l\'attribut <span class=\"vertclair\">value</span>.</p></div><h3>Affichage d\'un champ de saisie avec vérification complexe :</h3><div class=\"retrait\"><span class=\"code\">&lt;atm-input field=\"<span class=\"keyword\">{objet:champ}</span>\" form=\"<span class=\"keyword\">formName</span>\"&gt;<br />&#160;&#160;&#160; ... &lt;atm-input-callback return=\"<span class=\"keyword\">returnValue</span>\" /&gt; ...<br />&lt;/atm-input&gt;</span><br />Cette balise permet d\'effectuer des validations de champs dans un atm-form<ul>    <li><span class=\"keyword\">formName</span> : Nom du formulaire sur lequel s\'applique le tag.</li>    <li><span class=\"keyword\">{objet:champ}</span> : Champ de l\'objet géré par le formulaire sur lequel la saisie avec vérification complexe doit être effectuée.</li>    <li><span class=\"keyword\">returnValue</span> : La présence du tag atm-input-callback avec pour attribut return=\"<span class=\"vertclair\">valid</span>\" validera le contenu du champ, en cas d\'abscence du tag ou de valeur différente de <span class=\"vertclair\">valid</span> le champ retournera une erreur de type <span class=\"vertclair\">malformed</span></li></ul><br /><p>Cet exemple permet de rechercher si un utilisateur existe déjà pour un email donné et auquel cas, d\'empêcher sa réinscription :</p><br /><span class=\"code\">&lt;atm-input id=\"participant-email\" field=\"<span class=\"keyword\">{Participant:Email}</span>\" form=\"<span class=\"keyword\">quizInscription</span>\"&gt;<br />&#160;&#160;&#160;&lt;atm-search what=\"<span class=\"keyword\">{Participant}</span>\" name=\"<span class=\"keyword\">emailCheck</span>\"&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;atm-search-param search=\"<span class=\"keyword\">emailCheck</span>\" type=\"<span class=\"keyword\">{Participant:Email:fieldID}</span>\" value=\"<span class=\"keyword\">{request:string:participantEmail}</span>\" mandatory=\"<span class=\"keyword\">true</span>\" /&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;atm-result search=\"<span class=\"keyword\">emailCheck</span>\"&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;atm-input-callback return=\"<span class=\"vertclair\">invalid</span>\" /&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;/atm-result&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;atm-noresult search=\"<span class=\"keyword\">emailCheck</span>\"&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;atm-input-callback return=\"<span class=\"vertclair\">valid</span>\" /&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;/atm-noresult&gt;<br />&#160;&#160;&#160;&lt;/atm-search&gt;<br />&lt;/atm-input&gt;</span></div><h3>Executer une action après validation du formulaire :</h3><div class=\"retrait\"><span class=\"code\">&lt;atm-form-callback&#160;form=\"<span class=\"keyword\">formName</span>\"&gt;<br />&#160;&#160;&#160; ...&#160;<br />&lt;/atm-form-callback&gt;</span><br />Cette balise permet d\'effectuer des opérations après la validation du formulaire. Vous pouvez ainsi par exemple ajouter l\'objet créé à un autre objet à l\'aide du tag atm-object-link (voir ci-dessous), ou exécuter du code PHP spécifique.</div><h3>Ajout d\'un objet à un objet existant :</h3><div class=\"retrait\"><span class=\"code\">&lt;atm-object-link field=\"<span class=\"keyword\">{object:champ}</span>\" objectid=\"<span class=\"keyword\">objectid</span>\"&gt;</span><br />Cette balise permet d\'ajouter un object dans un champ sous-objet ou sous-object multiple d\'un objet existant.<ul>    <li><span class=\"keyword\">{objet:champ}</span> : Champ de l\'objet (de type sous-objet ou sous-objet multiple) sur lequel l\'objet doit être ajouté.</li>    <li><span class=\"keyword\">objectid</span> : Identifiant de l\'objet à ajouter au champ précisé dans l\'attribut <span class=\"vertclair\">field</span>.</li></ul></div><h3>Exemple de formulaire complexe :</h3><div class=\"retrait\">Dans cet exemple, nous allons voir le code d\'un formulaire permettant de créer un objet Message pour ensuite l\'ajouter à un objet Actualité existant. L\'objectif étant de gérer à l\'aide de ce code l\'ajout d\'un commentaire sur une actualité.<br /><br /><span class=\"code\">&lt;atm-form what=\"<span class=\"keyword\">{Message}</span>\" name=\"<span class=\"keyword\">createMessage</span>\"&gt;<br />&#160;&#160;&#160;<span class=\"vertclair\">&lt;!-- <br />&#160;&#160;&#160;&#160;&#160;&#160;Cette partie permet d\'affectuer des opérations suite à l\'enregistrement du formulaire.<br />&#160;&#160;&#160;&#160;&#160;&#160;Le contenu de ce tag sera exécuté après la soumission du formulaire et uniquement <br />&#160;&#160;&#160;&#160;&#160;&#160;si la soumission s\'est effectuée correctement.<br />&#160;&#160;&#160;--&gt;</span><br />&#160;&#160;&#160;&lt;atm-form-callback form=\"<span class=\"keyword\">createMessage</span>\"&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;<br />&#160;&#160;&#160;&#160;&#160;&#160;<span class=\"vertclair\">&lt;!-- Ici nous choisissons de rechercher un objet Actualité --&gt;</span><br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;atm-search what=\"<span class=\"keyword\">{Actualite}</span>\" name=\"<span class=\"keyword\">addMessage</span>\" public=\"<span class=\"keyword\">false</span>\"&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;atm-search-param search=\"<span class=\"keyword\">addMessage</span>\" type=\"<span class=\"keyword\">item</span>\" value=\"<span class=\"keyword\">{request:int:news}</span>\" mandatory=\"<span class=\"keyword\">true</span>\" /&gt; <br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;atm-result search=\"<span class=\"keyword\">addMessage</span>\"&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;<span class=\"vertclair\">&lt;!-- <br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Dans l\'actualité trouvée nous ajoutons le nouvel objet Message créé par<br />&#160;&#160; &#160; &#160; &#160; &#160; &#160; &#160; &#160;le formulaire dans le champ stockant les Messages <br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;--&gt;</span><br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;atm-object-link field=\"<span class=\"keyword\">{Actualite:Messages}</span>\" objectId=\"<span class=\"keyword\">{Message:id}</span>\"/&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;/atm-result&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;/atm-search&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;<br />&#160;&#160;&#160;&lt;/atm-form-callback&gt;<br />&#160;&#160;&#160;<br />&#160;&#160;&#160;<span class=\"vertclair\">&lt;!-- Cette partie affiche le message indiquant que le formulaire a été correctement enregistré --&gt;</span><br />&#160;&#160;&#160;&lt;atm-if what=\"<span class=\"keyword\">{filled}</span>\"&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;div class=\"message-ok\"&gt;Votre message a bien été ajouté !&lt;/div&gt;<br />&#160;&#160;&#160;&lt;/atm-if&gt;<br />&#160;&#160;&#160;<br />&#160;&#160;&#160;<span class=\"vertclair\">&lt;!-- Cette partie affiche le formulaire si il n\'est pas rempli ou comporte des erreurs --&gt;</span><br />&#160;&#160;&#160;&lt;atm-if what=\"<span class=\"keyword\">!{filled}</span>\"&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;<br />&#160;&#160;&#160;&#160;&#160;<span class=\"vertclair\">&#160;&lt;!-- Cette partie affiche les erreurs éventuelles survenues lors de la soumission --&gt;</span><br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;atm-if what=\"<span class=\"keyword\">{error}</span>\"&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;div class=\"message-alert\"&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Une erreur est survenue durant l\'enregistrement de votre message ... <br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Veuillez réessayer.<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;/div&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;/atm-if&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;<br />&#160;&#160;&#160;&#160;&#160;&#160;<span class=\"vertclair\">&lt;!-- Cette partie affiche une erreur à propos des champs manquants détectés lors de la soumission --&gt;</span><br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;atm-if what=\"<span class=\"keyword\">{required}</span>\"&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;div class=\"message-alert\"&gt;Les champs suivants sont requis :<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;ul&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;atm-form-required form=\"<span class=\"keyword\">createMessage</span>\"&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;li&gt;<span class=\"keyword\">{requiredname}</span>&lt;/li&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;/atm-form-required&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;/ul&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;/div&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;/atm-if&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;<br />&#160;&#160;&#160;&#160;&#160;&#160;<span class=\"vertclair\">&lt;!-- Cette partie affiche une erreur à propos des champs incorrects détectés lors de la soumission --&gt;</span><br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;atm-if what=\"<span class=\"keyword\">{malformed}</span>\"&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;div class=\"message-alert\"&gt;Les champs suivants sont incorrects :<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;ul&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;atm-form-malformed form=\"<span class=\"keyword\">createMessage</span>\"&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;li&gt;<span class=\"keyword\">{requiredname}</span>&lt;/li&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;/atm-form-malformed&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;/ul&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;/div&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;/atm-if&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;<br />&#160;&#160;&#160;&#160;&#160;&#160;<span class=\"vertclair\">&lt;!-- ... Ajoutez ici les champs atm-input composant votre formulaire ... --&gt;</span><br />&#160;&#160;&#160;&#160;&#160;&#160;<br />&#160;&#160;&#160;&#160;&#160;&#160;<span class=\"vertclair\">&lt;!-- Exemple de tag atm-input --&gt;</span><br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;div class=\"message\"&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Votre message :&lt;br/&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&lt;atm-input field=\"<span class=\"keyword\">{Message:Texte}</span>\" form=\"<span class=\"keyword\">createMessage</span>\" /&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;/div&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;<br />&#160;&#160;&#160;&#160;&#160;&#160;<span class=\"vertclair\">&lt;!-- <br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;Ce champ caché permet de spécifier l\'identifiant de l\'actualité dans laquelle <br />&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;nous voulons enregistrer le message créé à l\'aide de ce formulaire <br />&#160;&#160;&#160;&#160;&#160;&#160;--&gt;</span><br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;input type=\"hidden\" name=\"news\" value=\"<span class=\"keyword\">{request:int:news}</span>\" /&gt;<br />&#160;&#160;&#160;&#160;&#160;&#160;<br />&#160;&#160;&#160;&#160;&#160;&#160;<span class=\"vertclair\">&lt;!-- Bouton de soumission du formulaire --&gt;</span><br />&#160;&#160;&#160;&#160;&#160;&#160;&lt;input type=\"submit\" class=\"submit\" value=\"Publier votre message\" /&gt;<br />&#160;&#160;&#160;&lt;/atm-if&gt;<br />&lt;/atm-form&gt;<br /></span></div></div></div>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(384, 'polymod', 'fr', 'Booléen');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(385, 'polymod', 'fr', 'Permet de spécifier un état (oui - non)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(386, 'polymod', 'fr', 'Libellé de la catégorie');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(387, 'polymod', 'fr', 'Identifiant des utilisateur/groupe du champ');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(388, 'polymod', 'fr', 'Si ce paramètre est à :<br/>"oui" : seuls les utilisateurs/groupes sélectionnés ci-dessous recevront les notifications.<br/>"non" : les utilisateurs/groupes sélectionnés ci-dessous sont exclus de la réception des notifications.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(389, 'polymod', 'fr', 'Permet de faire une recherche sur une valeur incomplète. Utilisez le caractère % pour spécifier la partie inconnue. Par exemple, "cha%" retournera "chat", "chameau", etc.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(390, 'polymod', 'fr', 'Les valeurs suivantes sont possibles');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(391, 'polymod', 'fr', 'Opérateurs des champs de saisie pour ce champ');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(392, 'polymod', 'fr', 'Un opérateur permet de modifier l''affichage d''un champ (<span class="keyword">atm-input</span>) dans un formulaire (<span class="keyword">atm-form</span>). Il s''ajoute au tag <span class="keyword">atm-input</span> en ajoutant le paramètre <span class="keyword">operator</span> suivi de la valeur souhaitée. Les valeurs suivantes sont possibles :');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(393, 'polymod', 'fr', 'Affiche uniquement les sous catégories de la racine spécifiée');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(394, 'polymod', 'fr', 'Comparaison numérique de deux champs numériques flottants.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(395, 'polymod', 'fr', 'La valeur du champ peut être un nombre négatif');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(396, 'polymod', 'fr', 'Nombre flottant (à virgule)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(397, 'polymod', 'fr', 'Chaîne contenant un nombre à virgule (255 caractères maximum).');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(398, 'polymod', 'fr', 'Ensemble des IDs des objets de type ''%s'' associé à ce champ.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(399, 'polymod', 'fr', 'Largeur des boîtes de sélection (pixels)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(400, 'polymod', 'fr', 'Hauteur des boîtes de sélection (pixels)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(401, 'polymod', 'fr', 'Uniquement dans le cas de catégories multiples. 300x200 par défaut.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(402, 'polymod', 'fr', 'Description du champ : ''%s''');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(403, 'polymod', 'fr', 'Ordre de création');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(404, 'polymod', 'fr', 'Début de publication');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(405, 'polymod', 'fr', 'Trier par');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(406, 'polymod', 'fr', 'Page');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(407, 'polymod', 'fr', 'Permet de choisir une page Automne');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(409, 'polymod', 'fr', 'Largeur de l''aperçu dans les résultats de la recherche');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(411, 'polymod', 'fr', 'Retourne vrai (true) si ce champ possède une valeur');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(412, 'polymod', 'fr', '(Si la vignette dépasse cette hauteur elle sera redimensionnée)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(413, 'polymod', 'fr', 'Hauteur maximum de l''image en pixels');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(414, 'polymod', 'fr', 'Hauteur maximum de la vignette en pixels');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(415, 'polymod', 'fr', '(La vignettte sera redimensionnée à %s pixels de hauteur)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(416, 'polymod', 'fr', '(La vignettte sera redimensionnée à %s pixels de largeur et %s  pixels de hauteur)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(417, 'polymod', 'fr', 'Unité');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(418, 'polymod', 'fr', '(Sera affichée à côté de la valeur)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(419, 'polymod', 'fr', 'Unité : "%s"');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(420, 'polymod', 'fr', 'Affichage des résultats côté admin');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(421, 'polymod', 'fr', 'Syntaxe pour l''objet "%s"');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(422, 'polymod', 'fr', 'Recherchable');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(423, 'polymod', 'fr', 'Hauteur maximum de la vignette en pixels');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(424, 'polymod', 'fr', 'Indexé');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(425, 'polymod', 'fr', 'Largeur de la fenêtre popup');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(426, 'polymod', 'fr', 'Hauteur de la fenêtre popup');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(427, 'polymod', 'fr', 'message(s) envoyé(s)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(428, 'polymod', 'fr', 'Ne recherche que les objets associés à la(aux) catégorie(s) éditable(s) fournie(s) en paramètre');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(429, 'polymod', 'fr', 'Ne recherche que les objets qui ne sont pas associés à la catégorie en paramètre');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(430, 'polymod', 'fr', 'Ne recherche que les objets qui ne sont pas associés à la catégorie en paramètre, de façon stricte (les sous-catégories ne sont plus prises en compte)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(500, 'polymod', 'fr', 'Les catégories sont employées pour le(s) champ(s) : ');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(501, 'polymod', 'fr', 'Résultats : {0} %s sur {1}');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(502, 'polymod', 'fr', 'Résultats : Aucun résultat pour votre recherche ...');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(503, 'polymod', 'fr', 'Résultats');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(504, 'polymod', 'fr', '{0} %s sur {1}');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(505, 'polymod', 'fr', 'Supprime le ou les éléments %s sélectionnés. ');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(506, 'polymod', 'fr', 'Cette action est soumise à une validation ultérieure.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(507, 'polymod', 'fr', 'Cette action n''est pas soumise à une validation et est effective directement.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(508, 'polymod', 'fr', 'Annule la demande de suppression du ou des éléments %s sélectionnés.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(509, 'polymod', 'fr', 'Dévérouille le ou les éléments %s sélectionnés. Attention, si une personne est actuellement en train de modifier cet élément, elle pourrait perdre ses modifications.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(510, 'polymod', 'fr', 'Aperçu avant validation du ou des éléments %s sélectionnés.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(511, 'polymod', 'fr', 'Modification du ou des éléments %s sélectionnés.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(512, 'polymod', 'fr', 'Création d''un nouvel élément %s.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(513, 'polymod', 'fr', 'Recevez un email pour toute validation en attente dans ce module.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(514, 'polymod', 'fr', 'Validations');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(515, 'polymod', 'fr', 'Heures');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(516, 'polymod', 'fr', 'Modifier l''élément associé sélectionné');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(517, 'polymod', 'fr', 'Enlever l''élément associé sélectionné');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(518, 'polymod', 'fr', 'Choisissez les éléments ''%s'' à associer');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(519, 'polymod', 'fr', 'Choisissez l''aide à afficher : ');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(520, 'polymod', 'fr', 'Ordre aléatoire');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(521, 'polymod', 'fr', 'Sur cette page, vous pouvez spécifier des paramètres pour l''affichage de la rangée de contenu en cours d''édition.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(522, 'polymod', 'fr', 'Le formulaire est incomplet ou possède des valeurs incorrectes ...');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(523, 'polymod', 'fr', 'Cet onglet est désactivé car vous devez avoir sélectionné du texte dans l''éditeur pour l''utiliser.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(524, 'polymod', 'fr', 'Cet onglet est désactivé car vous ne devez pas avoir sélectionné de texte dans l''éditeur pour l''utiliser.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(525, 'polymod', 'fr', 'L''élément ''%s'' que vous cherchez à éditer est vérouillé par %s le %s.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(526, 'polymod', 'fr', 'Vous n''avez pas le droit d''éditer l''élément ''%s''.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(527, 'polymod', 'fr', 'Sur cette page, vous pouvez créer ou modifier les données de l''élément %s');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(528, 'polymod', 'fr', 'Erreur durant l''enregistrement de l''élément ...');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(529, 'polymod', 'fr', 'Aucune catégorie disponible ...');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(530, 'polymod', 'fr', 'Aucun élément disponible ...');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(531, 'polymod', 'fr', 'Elément inexistant ...');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(532, 'polymod', 'fr', 'Titre de la page');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(533, 'polymod', 'fr', 'Adresse (url) de la page');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(534, 'polymod', 'fr', 'Identifiant de la page');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(535, 'polymod', 'fr', 'Les champs suivants sont obligatoire :');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(536, 'polymod', 'fr', 'Taille max : %s car.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(537, 'polymod', 'fr', 'Le contenu du champ ''%s'' est mal formatté et il ne peut être enregistré.<br />Evitez tout copier-coller de texte depuis un éditeur de texte externe. Employez les outils ''Coller comme texte'' ou ''Coller de Word'' de la barre d''outils dans ce cas.<br /><br />Vérifiez le code source de votre contenu : il doit être composé de XHTML valide.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(538, 'polymod', 'fr', '<strong>Liste de toutes les valeurs du champ :</strong><br />\n<br />\n<span class="code">&lt;select ...&gt;&lt;atm-function function=&quot;selectOptions&quot; object=&quot;%s&quot; selected=&quot;<span class="keyword">selectedValue</span>&quot;&gt;&lt;/atm-function&gt;&lt;/select&gt;</span><br />\nCette fonction permet d''afficher une liste class&eacute;e par ordre alphab&eacute;tique de tags &lt;option&gt; contenant toutes les valeurs du champ. Elle est usuellement employ&eacute;e &agrave; l''int&eacute;rieur d''un tag &lt;select&gt;.\n<ul>\n   <li><span class="keyword">selectedValue </span><strong>: </strong>Valeur &agrave; s&eacute;lectionner dans la liste (facultatif)</li>\n</ul>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(539, 'polymod', 'fr', 'Comparaison numérique de deux champs.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(540, 'polymod', 'fr', 'Description de la catégorie');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(541, 'polymod', 'fr', 'Enregistrer et Valider');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(542, 'polymod', 'fr', 'Enregistre vos modifications et les valide automatiquement. Vos modifications seront directement publiées sur le site sans étape intermédiaire de validation.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(543, 'polymod', 'fr', 'Enregistre vos modifications sans les valider. Vos modifications devront être validées avant d''être visibles sur le site.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(544, 'polymod', 'fr', 'Enregistre vos modifications. Vos modifications seront directement visibles sur le site.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(545, 'polymod', 'fr', 'Chemin vers la vignette si elle existe.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(546, 'polymod', 'fr', 'Chemin vers la vignette si elle existe (utilisable dans un tag atm-loop).');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(547, 'polymod', 'fr', 'Code HTML complet de la vignette si elle existe.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(548, 'polymod', 'fr', 'Code HTML complet de la vignette si elle existe (utilisable dans un tag atm-loop).');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(549, 'polymod', 'fr', 'Largeur maximum de l''image zoom en pixels');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(550, 'polymod', 'fr', '(Si l''image zoom dépasse cette largeur elle sera redimensionnée)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(551, 'polymod', 'fr', 'Hauteur maximum de l''image zoom en pixels');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(552, 'polymod', 'fr', '(Si l''image zoom dépasse cette hauteur elle sera redimensionnée)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(553, 'polymod', 'fr', 'Publiés (En ligne)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(554, 'polymod', 'fr', 'Non publiés (Hors ligne)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(555, 'polymod', 'fr', 'Validés (Statut vert)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(556, 'polymod', 'fr', 'En attente de validation (Statut orange)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(557, 'polymod', 'fr', '<strong>Liste de toutes les langues du champ :<br />\n</strong><br />\n<span class="code"> &lt;select&gt;<strong>&lt;</strong>atm-function function=&quot;selectOptions&quot; object=&quot;%s&quot; selected=&quot;<span class="keyword">selectedCode</span><strong>&quot;&gt;&lt;/</strong>atm-function<strong>&gt;</strong>&lt;/select&gt;</span><br />\nCette fonction permet d''afficher une liste class&eacute;e par ordre alphab&eacute;tique de tags &lt;option&gt; contenant toutes les langues du champ donn&eacute; en param&egrave;tre. Elle est usuellement employ&eacute;e &agrave; l''int&eacute;rieur d''un tag &lt;select&gt;.<br />\n<ul>\n	<li><span class="keyword">selectedCode </span><strong>: </strong>Code de la langue &agrave; selectionner dans la liste</li>\n</ul>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(558, 'polymod', 'fr', 'Tableau des identifiants des catégories');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(559, 'polymod', 'fr', 'Libellés des catégories. Vous pouvez modifier le séparateur (par défaut : virgule) en ajoutant un paramètre à l\'aide d\'un séparateur pipe (|).');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(560, 'polymod', 'fr', 'Utilisez la touche control [Ctrl] sur PC ou Pomme [cmd] sur Mac pour faire des sélections multiples.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(561, 'polymod', 'fr', 'Coordonnées (Google)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(562, 'polymod', 'fr', 'Point de coordonnées sur une carte');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(563, 'polymod', 'fr', 'Longitude (X)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(564, 'polymod', 'fr', 'Latitude (Y)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(565, 'polymod', 'fr', 'Employer certains champs de l\'élément comme adresse source ?');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(566, 'polymod', 'fr', 'Sélectionnez les champs de l\'élément à employer comme adresse source');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(567, 'polymod', 'fr', 'Adresse');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(568, 'polymod', 'fr', 'Champs');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(569, 'polymod', 'fr', 'Mettre &agrave; jour depuis l\'adresse');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(570, 'polymod', 'fr', 'Google ne peut déterminer la position de cette adresse "{0}" ...');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(571, 'polymod', 'fr', 'Positionner sur la Carte');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(572, 'polymod', 'fr', 'Fen&ecirc;tre Cartographique');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(573, 'polymod', 'fr', 'Saisissez une adresse de d&eacute;part ...');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(574, 'polymod', 'fr', 'Chemin complet vers le fichier (répertoire et nom). Cette variable accepte deux paramètres optionnels largeur (width) et hauteur (height) permettant de redimensionner dynamiquement le fichier lorsqu\'il s\'agit d\'une image. Spécifiez pour ces valeurs les dimensions attendues en pixels.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(575, 'polymod', 'fr', 'Chemin complet vers la vignette (répertoire et nom). Cette variable accepte deux paramètres optionnels largeur (width) et hauteur (height) permettant de redimensionner dynamiquement la vignette. Spécifiez pour ces valeurs les dimensions attendues en pixels.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(576, 'polymod', 'fr', 'Si le fichier est une image : largeur de l\'image en pixels');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(577, 'polymod', 'fr', 'Si le fichier est une image : hauteur de l\'image en pixels');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(578, 'polymod', 'fr', 'Type de la vignette (extension)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(579, 'polymod', 'fr', 'Chemin complet vers l\'image (répertoire et nom). Cette variable accepte deux paramètres optionnels largeur (width) et hauteur (height) permettant de redimensionner dynamiquement l\'image. Spécifiez pour ces valeurs les dimensions attendues en pixels.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(580, 'polymod', 'fr', 'Chemin complet vers l\'image zoom (répertoire et nom). Cette variable accepte deux paramètres optionnels largeur (width) et hauteur (height) permettant de redimensionner dynamiquement l\'image zoom. Spécifiez pour ces valeurs les dimensions attendues en pixels.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(581, 'polymod', 'fr', 'Légende');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(582, 'polymod', 'fr', 'Rendre la légende obligatoire');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(583, 'polymod', 'fr', 'Champ de l\'objet');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(584, 'polymod', 'fr', 'Ce paramètre vous permet de sélectionner un champ "Utilisateur / Groupe" de l\'objet actuel.<br />Si ce paramètre est employé, le ou les destinataires de la notification seront ceux disponibles dans le champ sélectionné.<br />L\'utilisation de ce paramètre annule les trois paramètres précédents.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(585, 'polymod', 'fr', 'Options des mots-clés');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(586, 'polymod', 'fr', 'N\'importe quel mot (ou)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(587, 'polymod', 'fr', 'Tous les mots (et)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(588, 'polymod', 'fr', 'Phrase exacte');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(589, 'polymod', 'fr', 'Opérateurs de gestion de l\'ordre de recherche pour ce champ');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(590, 'polymod', 'fr', '<p>Un op&eacute;rateur permet de modifier le fonctionnement d\'un filtre de gestion de l\'ordre (tag <span class=\"keyword\">atm-search-order</span>) dans une recherche. Il s\'ajoute au filtre en ajoutant le param&egrave;tre <span class=\"keyword\">operator </span>suivit de la valeur souhait&eacute;e au tag <span class=\"keyword\">atm-search-order</span> proposant un filtre sur ce champ. Les valeurs suivantes sont possibles :</p>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(591, 'polymod', 'fr', 'Tri les catégories par ordre alphabétique de leurs libellés.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(592, 'polymod', 'fr', 'Affiche les catégories dans l\'ordre alphabétique de leurs libellés (uniquement pour les champs de catégories uniques. Attention, n\'employez pas cet attribut dans le cas ou vous affichez une arborescence de catégories).');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(593, 'polymod', 'fr', 'Spécifie la largeur des boîtes de sélection lors d\'un choix de catégories multiple. Accepte une valeur entière en pixels.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(594, 'polymod', 'fr', 'Spécifie la hauteur des boîtes de sélection lors d\'un choix de catégories multiple. Accepte une valeur entière en pixels.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(595, 'polymod', 'fr', 'Permet de choisir l\'affichage des bo&icirc;tes de dialogue lors de la s&eacute;lection multiple de cat&eacute;gories. Accepte les valeurs <span class=\"vertclair\">horizontal</span> et <span class=\"vertclair\">vertical</span>');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(596, 'polymod', 'fr', 'Titre de la boîte de dialogue de gauche lors de la sélection multiple de catégories.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(597, 'polymod', 'fr', 'Titre de la boîte de dialogue de droite lors de la sélection multiple de catégories.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(598, 'polymod', 'fr', 'Description du champ lors de la sélection multiple de catégories.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(599, 'polymod', 'fr', 'Permet de rechercher une valeur différente de la valeur spécifiée.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(600, 'polymod', 'fr', 'Si la valeur fournie est un tableau de valeur, permet de rechercher les éléments parmi ces valeurs ou qui n\'appartiennent pas à ces valeurs. ');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(601, 'polymod', 'fr', 'Dépublier le ou les éléments %s sélectionnés : positionne la date de fin de publication de l\'élément à la date d\'hier. L\'élément ne sera plus consultable en ligne. Cette action est soumise à validation et peut être annulée.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(602, 'polymod', 'fr', 'Re-publier le ou les éléments %s sélectionnés : supprime la date de fin de publication de l\'élément. L\'élément sera à nouveau consultable en ligne. Cette action est soumise à validation et peut être annulée.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(603, 'polymod', 'fr', 'Dépublier');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(604, 'polymod', 'fr', 'Publier');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(605, 'polymod', 'fr', 'Timestamp de la date');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(606, 'polymod', 'fr', 'Etes-vous sûr de vouloir supprimer le ou les éléments %s sélectionnés ?');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(607, 'polymod', 'fr', 'Etes-vous sûr de vouloir désassocier l\'élément %s sélectionné ?');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(608, 'polymod', 'fr', 'Veuillez sélectionner un élément sur lequel réaliser cette opération ...');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(609, 'polymod', 'fr', 'Coché par défaut');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(610, 'polymod', 'fr', 'Si \'Emission au choix\' est actif, la case permettant de choisir est elle coché par défaut ?');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(611, 'polymod', 'fr', 'Média externe');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(612, 'polymod', 'fr', 'URL d\'un Média provenant d\'un site externe (Youtube, Flickr, Scribd, Dailymotion, Vimeo, etc.). Permet d\'inclure directement le média dans votre site (oEmbed).');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(613, 'polymod', 'fr', 'Titre du média (optionnel)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(614, 'polymod', 'fr', 'Adresse (URL) saisie pour le média');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(615, 'polymod', 'fr', 'Média au format HTML. Cette variable accepte deux paramètres optionnels largeur maximum (maxwidth) et hauteur maximum (maxheight) permettant de spécifier les tailles maximum possibles pour le média. Spécifiez pour ces valeurs les dimensions attendues en pixels.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(616, 'polymod', 'fr', 'Vignette du média (optionnel)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(617, 'polymod', 'fr', 'Largeur en pixels du média');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(618, 'polymod', 'fr', 'Hauteur en pixels du média');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(619, 'polymod', 'fr', 'Type du média (parmis : video, photo, rich, link)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(620, 'polymod', 'fr', 'Description du média (optionnel)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(621, 'polymod', 'fr', 'Nom de l\'auteur du média (optionnel)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(622, 'polymod', 'fr', 'Adresse (URL) vers l\'auteur du média (optionnel)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(623, 'polymod', 'fr', 'Nom du fournisseur du média (optionnel)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(624, 'polymod', 'fr', 'Adresse (URL) vers le fournisseur du média (optionnel)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(625, 'polymod', 'fr', 'Une URL a t\'elle été saisie pour ce champ ? (renvoie un booléen true ou false)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(626, 'polymod', 'fr', 'Données oembed brutes du média (tableau de données)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(627, 'polymod', 'fr', 'Valeur texte brut du texte (tags HTML supprimés pour le texte HTML)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(628, 'polymod', 'fr', 'Aucun média trouvé pour cette adresse ...');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(629, 'polymod', 'fr', 'Il s\'agit de l\'adresse du média telle qu\'elle apparait dans la barre d\'adresse de votre navigateur. Elle doit commencer par http:// .');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(630, 'polymod', 'fr', 'URL du média');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(631, 'polymod', 'fr', 'Clé embed.ly');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(632, 'polymod', 'fr', 'Pour profiter du service <a href="http://embed.ly" target="_blank">embed.ly</a> permettant d\'intégrer tout type de média, saisissez votre clé embed.ly dans ce champ. Vous pouvez obtenir une clé gratuite à cette adresse : <a href="http://app.embed.ly/pricing/free" target="_blank">http://app.embed.ly/pricing/free</a>.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(633, 'polymod', 'fr', 'Elément ''%s'' actuellement associé');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(634, 'polymod', 'fr', 'Commence par');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(635, 'polymod', 'fr', 'Les résultats retournés comporteront n\'importe quel mot saisi dans le filtre. La valeur fournie peut être un tableau ou une chaine contenant une liste de mots.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(636, 'polymod', 'fr', 'Les résultats retournés comporteront tous les mots saisis dans le filtre. La valeur fournie peut être un tableau ou une chaine contenant une liste de mots.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(637, 'polymod', 'fr', 'Les résultats retournés comporteront la phrase exacte saisie dans le filtre.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(638, 'polymod', 'fr', 'Les résultats retournés commenceront par la phrase exacte saisie dans le fitre.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(639, 'polymod', 'fr', 'Fonctionne uniquement sur les champs texte simple.');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(640, 'polymod', 'fr', 'Limiter au(x) champ(s)');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(641, 'polymod', 'fr', 'Tous les champs');
INSERT INTO `messages` (`id_mes`, `module_mes`, `language_mes`, `message_mes`) VALUES(642, 'polymod', 'fr', 'Remettre la recherche à zéro');
