Ext.override(Ext.data.Store, {
	// Keeps track of the load status of the store. Set to true after a successful load event
	loaded: false,
	/**
	 * Returns true if the store has previously performed a successful load function.
	 * @return {Boolean} Whether the store is loaded.
	 */
	isLoaded: function(){
		return this.loaded
	},
	// Called as a callback by the Reader during a load operation.
	loadRecords : function(o, options, success){
		if(!o || success === false){
			if(success !== false){
				this.fireEvent("load", this, [], options);
			}
			if(options.callback){
				options.callback.call(options.scope || this, [], options, false);
			}
			return;
		}
		var r = o.records, t = o.totalRecords || r.length;
		if(!options || options.add !== true){
			if(this.pruneModifiedRecords){
				this.modified = [];
			}
			for(var i = 0, len = r.length; i < len; i++){
				r[i].join(this);
			}
			if(this.snapshot){
				this.data = this.snapshot;
				delete this.snapshot;
			}
			this.data.clear();
			this.data.addAll(r);
			this.totalLength = t;
			this.applySort();
			this.fireEvent("datachanged", this);
		}else{
			this.totalLength = Math.max(t, this.data.length+r.length);
			this.add(r);
		}
		this.loaded = true;
		this.fireEvent("load", this, r, options);
		if(options.callback){
			options.callback.call(options.scope || this, r, options, true);
		}
	}
});