-- query
DROP TABLE IF EXISTS {_prefix_}administrators;
-- query
CREATE TABLE `{_prefix_}administrators` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fkey` int(11) NOT NULL,
  `f_name` varchar(50) NOT NULL,
  `l_name` varchar(50) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(100) NOT NULL,
  `email` varchar(50) NOT NULL,
  `createdate` datetime NOT NULL,
  `latestlogin` int(11) NOT NULL,
  `lastlogin` int(11) NOT NULL,
  `status` enum('Active','Pending') NOT NULL DEFAULT 'Active',
  `type` enum('Super','Normal') NOT NULL DEFAULT 'Normal',
  `acl` text NOT NULL,
  `description` text NOT NULL,
  `resetsid` varchar(200) CHARACTER SET ucs2 NOT NULL,
  `lastresettime` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;
-- query
DROP TABLE IF EXISTS {_prefix_}categories;
-- query
CREATE TABLE `{_prefix_}categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fkey` int(11) NOT NULL DEFAULT '0',
  `adminref` int(11) NOT NULL DEFAULT '0',
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `image` varchar(200) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `type` varchar(255) NOT NULL,
  `generic` varchar(250) NOT NULL,
  `entry_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_modified` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8;
-- query
DROP TABLE IF EXISTS {_prefix_}comments;
-- query
CREATE TABLE `{_prefix_}comments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `postid` int(11) NOT NULL,
  `catid` int(11) NOT NULL,
  `userid` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `website` varchar(100) NOT NULL,
  `comment` text NOT NULL,
  `dated` datetime NOT NULL,
  `type` enum('Blog','Forum') NOT NULL,
  `status` enum('Active','Inactive') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- query
DROP TABLE IF EXISTS {_prefix_}coreresources;
-- query
CREATE TABLE `{_prefix_}coreresources` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `type` enum('Model','Module','Plugin','Component') NOT NULL DEFAULT 'Model',
  `version` varchar(200) NOT NULL DEFAULT '',
  `status` enum('Active','Inactive') NOT NULL,
  `info` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;
-- query
INSERT INTO {_prefix_}coreresources VALUES ('1', 'Admin', 'Model', '0.1.0', 'Active', '');
-- query
INSERT INTO {_prefix_}coreresources VALUES ('2', 'Category', 'Model', '0.1.0', 'Active', '');
-- query
INSERT INTO {_prefix_}coreresources VALUES ('3', 'Config', 'Model', '0.1.0', 'Active', '');
-- query
INSERT INTO {_prefix_}coreresources VALUES ('4', 'Coreresource', 'Model', '0.1.0', 'Active', '');
-- query
INSERT INTO {_prefix_}coreresources VALUES ('5', 'Developer', 'Model', '0.1.0', 'Active', '');
-- query
INSERT INTO {_prefix_}coreresources VALUES ('6', 'Home', 'Model', '0.1.0', 'Active', '');
-- query
INSERT INTO {_prefix_}coreresources VALUES ('7', 'Infodata', 'Model', '0.1.0', 'Active', '');
-- query
INSERT INTO {_prefix_}coreresources VALUES ('8', 'Information', 'Model', '0.1.0', 'Active', '');
-- query
INSERT INTO {_prefix_}coreresources VALUES ('9', 'Log', 'Model', '0.1.0', 'Active', '');
-- query
INSERT INTO {_prefix_}coreresources VALUES ('10', 'Member', 'Model', '0.1.0', 'Active', '');
-- query
INSERT INTO {_prefix_}coreresources VALUES ('11', 'My', 'Model', '0.1.0', 'Active', '');
-- query
INSERT INTO {_prefix_}coreresources VALUES ('12', 'Page', 'Model', '0.1.0', 'Active', '');
-- query
INSERT INTO {_prefix_}coreresources VALUES ('13', 'appslide', 'Component', '0.1.0', 'Active', 'a:1:{s:11:"installdate";s:19:"2012-02-24 19:49:06";}');
-- query
INSERT INTO {_prefix_}coreresources VALUES ('14', 'homepress', 'Component', '0.1.0', 'Active', 'a:1:{s:11:"installdate";s:19:"2012-02-24 18:31:08";}');
-- query
INSERT INTO {_prefix_}coreresources VALUES ('15', 'contactus', 'Component', '0.1.0', 'Active', 'a:1:{s:11:"installdate";s:19:"2012-02-05 03:45:02";}');
-- query
DROP TABLE IF EXISTS {_prefix_}infodata;
-- query
CREATE TABLE `{_prefix_}infodata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `ioption` varchar(250) NOT NULL,
  `ivalue` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=703 DEFAULT CHARSET=utf8;
-- query
INSERT INTO {_prefix_}infodata VALUES ('1', '1', 'title', 'Templates and Theme');
-- query
INSERT INTO {_prefix_}infodata VALUES ('2', '1', 'linked-to', '2');
-- query
INSERT INTO {_prefix_}infodata VALUES ('3', '1', 'status', 'Active');
-- query
INSERT INTO {_prefix_}infodata VALUES ('4', '2', 'title', 'GET STARTED');
-- query
INSERT INTO {_prefix_}infodata VALUES ('5', '2', 'image', 'get_started.jpg');
-- query
INSERT INTO {_prefix_}infodata VALUES ('6', '2', 'description', '<h1>
	GET STARTED YOUR DEVELOPMENT</h1>
<p>
	First login to the&nbsp;admin panel and&nbsp;discover all&nbsp;&nbsp;the features. All necessary tools have been developed&nbsp; for you to use.&nbsp; The Website Template is segmented to place and add&nbsp;content&nbsp; and&nbsp; you can even&nbsp;do &ldquo;Server Side Scripting&rdquo;. You can Change the&nbsp;theme, components and common settings to adjust as per your requirements. <br />
	<br />
	Please go through the manual section in appRain Official website for&nbsp;any queries you may have.</p>
');
-- query
INSERT INTO {_prefix_}infodata VALUES ('7', '2', 'status', 'Active');
-- query
INSERT INTO {_prefix_}infodata VALUES ('8', '3', 'title', 'ORGANIZE PAGES');
-- query
INSERT INTO {_prefix_}infodata VALUES ('9', '3', 'image', 'pagemanager.jpg');
-- query
INSERT INTO {_prefix_}infodata VALUES ('10', '3', 'description', '<h1>
	ORGANIZE YOUR PAGES</h1>
<p>
	The &quot;Page Manager&quot; is one of the sections to manage content in the website. You can place content in the&nbsp;website like a&nbsp;Menu, Header, Footer, Body etc.You can use a&nbsp;&quot;Snip&quot; to write direct PHP code inside a static page and access any core or user defined library by attaching a&nbsp;Snip.&nbsp;<br />
	&nbsp;<br />
	&nbsp;You can also&nbsp;use the&nbsp;Theme setting and App Editor to update direct code from the&nbsp;admin panel.</p>
');
-- query
INSERT INTO {_prefix_}infodata VALUES ('11', '3', 'status', 'Active');
-- query
INSERT INTO {_prefix_}infodata VALUES ('12', '4', 'title', 'COMPONENTS');
-- query
INSERT INTO {_prefix_}infodata VALUES ('13', '4', 'image', 'components.jpg');
-- query
INSERT INTO {_prefix_}infodata VALUES ('14', '4', 'description', '<h1>
	MORE FEATURES</h1>
<p>
	Component is the &quot;Addition Module House&quot; of appRain. You can activate necessary pre-made components from admin panel. Simply go in &ldquo;Component&rdquo; tab and click to activate it. <br />
	<br />
	Most of the common features like Blog, Forum, E-Commerce, Multi-Galleries, Report Builder and lots of others bits and pieces are available in present version. Components are also available in appRain official website.</p>
');
-- query
INSERT INTO {_prefix_}infodata VALUES ('15', '4', 'status', 'Active');
-- query
INSERT INTO {_prefix_}infodata VALUES ('16', '5', 'title', 'SETTINGS');
-- query
INSERT INTO {_prefix_}infodata VALUES ('17', '5', 'image', 'settings.jpg');
-- query
INSERT INTO {_prefix_}infodata VALUES ('18', '5', 'description', '<h1>
	CONFIGURE YOUR WEBSITE</h1>
<p>
	Configuration is one of the most&nbsp;important parts to control the system and enrich your website. Go to the &quot;Preference&quot; tab to view all common settings. <br />
	<br />
	The &quot;Admin Settings&quot; and &quot;Site Option&quot; help you to configure the&nbsp;website&#39;s common parameters. &quot;Email Templates&quot; helps to update external email formatting. Use &quot;Configuration&quot; to update system core parameters. You can change the&nbsp;look and feel of the website from the&nbsp;&quot;Theme&quot; section.</p>
');
-- query
INSERT INTO {_prefix_}infodata VALUES ('19', '5', 'status', 'Active');
-- query
INSERT INTO {_prefix_}infodata VALUES ('20', '6', 'title', 'Components');
-- query
INSERT INTO {_prefix_}infodata VALUES ('21', '6', 'linked-to', '5');
-- query
INSERT INTO {_prefix_}infodata VALUES ('22', '6', 'status', 'Active');
-- query
INSERT INTO {_prefix_}infodata VALUES ('23', '7', 'title', 'Resources');
-- query
INSERT INTO {_prefix_}infodata VALUES ('24', '7', 'linked-to', '7');
-- query
INSERT INTO {_prefix_}infodata VALUES ('25', '7', 'status', 'Active');
-- query
INSERT INTO {_prefix_}infodata VALUES ('26', '8', 'title', 'DEVELOPERS');
-- query
INSERT INTO {_prefix_}infodata VALUES ('27', '8', 'image', 'developer.jpg');
-- query
INSERT INTO {_prefix_}infodata VALUES ('28', '8', 'description', '<h1>
	DEVELOP IN LARGE SCALE</h1>
<p>
	The Framework Part is mostly developer oriented. Most of the programming design patterns are implemented here and most of them&nbsp;directly interact with the&nbsp;CMS parts. Create new components for unique features that help you to move code&nbsp;to other projects easily. Each component maintains a standalone MVC pattern and can hook inside. <br />
	<br />
	Avoid editing the core resource and create extended class to attach more functionality in core helpers.</p>
');
-- query
INSERT INTO {_prefix_}infodata VALUES ('29', '8', 'status', 'Active');
-- query
INSERT INTO {_prefix_}infodata VALUES ('30', '9', 'templatetype', 'ContactUs');
-- query
INSERT INTO {_prefix_}infodata VALUES ('31', '9', 'subject', 'One message sent  by {FirstName}{LastName}');
-- query
INSERT INTO {_prefix_}infodata VALUES ('32', '9', 'message', 'Following message sen by {FirstName}{LastName}

{Message}

<hr />

Subject:  {Subject}

Sender Email:  {Email}

<a href="{baseurl}">View Website</a> <a href="{baseurl}/admin">View Admin</a>');
-- query
INSERT INTO {_prefix_}infodata VALUES ('33', '7', 'shortdesc', 'appRain has combined most of the latest Programming Design Patterns.  The base of the framework is developed on Factory Pattern and Singleton Pattern to optimize the resource utilization. We control the Data flow by Modified MVC (Model-View-Controller) pattern, EAV Model.   

We have other modules like a URI Manager, an Interface Builder, a Category Set Manager, a Page Manager, a Web Service (Soap by Reflection API), Cron Job, Object Exporting, Multi Domain, Multi User Facilities and lots of other modules. A team is updating it regularly and expect your suggestion.  
');
-- query
INSERT INTO {_prefix_}infodata VALUES ('34', '6', 'shortdesc', 'You can activate components when you need to add new features in a website. You can use default components or develop new ones. The most common components have already been developed by the appRain team.  You can also download components from the appRain official website.

Components are movable modules to other projects. This concept always saves time and effort in development. A extensive feature like e-Commerce or a Forum can be developed by a single component. You can create an installer to make it easily implementable and distributable. ');
-- query
INSERT INTO {_prefix_}infodata VALUES ('35', '1', 'shortdesc', 'The Template always helps you to brand the website to your specific purpose. You can change and personalize the template from within the control panel. There is a  gallery inside the control panel to change the template.

Each template has some default settings enabling you to change the Logo, Banners, menu etc.  You can change the color scheme and structure by editing the CSS and HTML code. You can use the appEditor inside control panel to change the code.  We recommend you  update the code by using the text editor and upload to the server. ');
-- query
INSERT INTO {_prefix_}infodata VALUES ('36', '10', 'templatetype', 'MemberRegistration');
-- query
INSERT INTO {_prefix_}infodata VALUES ('37', '10', 'subject', 'Member Registration notification');
-- query
INSERT INTO {_prefix_}infodata VALUES ('38', '10', 'message', 'Dear {FirstName} {LastName},
Registration is almost click the following link to complete the registration

{VerificationLink}

<hr />
<a href="{baseurl}/contact-us">Click here</a> to contact with administrator

');
-- query
INSERT INTO {_prefix_}infodata VALUES ('39', '11', 'templatetype', 'ForgotPassword');
-- query
INSERT INTO {_prefix_}infodata VALUES ('40', '11', 'subject', 'Password reset request');
-- query
INSERT INTO {_prefix_}infodata VALUES ('41', '11', 'message', 'Dear {FirstName} {LastName},
Click the following link to reset password

{PasswordResetLink}

<hr />
<a href="{baseurl}/contact-us">Click here</a> to contact with administrator');
-- query
DROP TABLE IF EXISTS {_prefix_}information;
-- query
CREATE TABLE `{_prefix_}information` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `link_to` int(11) NOT NULL DEFAULT '0',
  `adminref` int(11) NOT NULL DEFAULT '0',
  `fkey` int(11) NOT NULL DEFAULT '0',
  `generic` varchar(200) NOT NULL,
  `type` varchar(50) NOT NULL,
  `entry_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `threshold` int(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=140 DEFAULT CHARSET=utf8;
-- query
INSERT INTO {_prefix_}information VALUES ('1', '0', '1', '0', '10', 'home-synopsis', '2012-02-26 22:58:35', '2012-02-26 22:58:35', '0');
-- query
INSERT INTO {_prefix_}information VALUES ('2', '0', '1', '0', '10', 'home-press', '2012-02-19 07:11:00', '2012-02-19 07:11:00', '0');
-- query
INSERT INTO {_prefix_}information VALUES ('3', '0', '1', '0', '11', 'home-press', '2012-02-19 07:12:08', '2012-02-19 07:12:08', '0');
-- query
INSERT INTO {_prefix_}information VALUES ('4', '0', '1', '0', '12', 'home-press', '2012-02-19 06:45:36', '2012-02-19 06:45:36', '0');
-- query
INSERT INTO {_prefix_}information VALUES ('5', '0', '1', '0', '14', 'home-press', '2012-02-19 07:12:59', '2012-02-19 07:12:59', '0');
-- query
INSERT INTO {_prefix_}information VALUES ('6', '0', '1', '0', '12', 'home-synopsis', '2012-02-26 22:58:29', '2012-02-26 22:58:29', '0');
-- query
INSERT INTO {_prefix_}information VALUES ('7', '0', '1', '0', '13', 'home-synopsis', '2012-02-26 22:58:20', '2012-02-26 22:58:20', '0');
-- query
INSERT INTO {_prefix_}information VALUES ('8', '0', '1', '0', '15', 'home-press', '2012-02-19 07:13:45', '2012-02-19 07:13:45', '0');
-- query
INSERT INTO {_prefix_}information VALUES ('9', '0', '1', '0', '', 'email-template', '2012-02-05 03:44:54', '2012-02-05 03:44:54', '0');
-- query
INSERT INTO {_prefix_}information VALUES ('10', '0', '1', '0', '', 'email-template', '2012-02-26 00:21:10', '2012-02-26 00:21:10', '0');
-- query
INSERT INTO {_prefix_}information VALUES ('11', '0', '1', '0', '', 'email-template', '2012-02-26 00:23:20', '2012-02-26 00:23:20', '0');
-- query
DROP TABLE IF EXISTS {_prefix_}log;
-- query
CREATE TABLE `{_prefix_}log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fkey` int(11) NOT NULL,
  `type` varchar(20) NOT NULL,
  `dated` datetime NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- query
DROP TABLE IF EXISTS {_prefix_}members;
-- query
CREATE TABLE `{_prefix_}members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `photo` varchar(50) NOT NULL,
  `name_title` varchar(200) NOT NULL,
  `f_name` varchar(200) NOT NULL,
  `l_name` varchar(200) NOT NULL,
  `password` varchar(200) NOT NULL,
  `email` varchar(200) NOT NULL,
  `address` text NOT NULL,
  `state` varchar(50) NOT NULL,
  `zipcode` varchar(15) NOT NULL,
  `country` varchar(50) NOT NULL,
  `gmcoordinate` varchar(50) NOT NULL,
  `exp_date` date NOT NULL DEFAULT '0000-00-00',
  `website` varchar(100) NOT NULL,
  `note` text NOT NULL,
  `signup_date` date NOT NULL DEFAULT '0000-00-00',
  `phone_no` varchar(50) NOT NULL,
  `status` enum('Applied','Accepted','Active','Inactive','Defaulter') NOT NULL DEFAULT 'Applied',
  `resetid` varchar(250) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
-- query
INSERT INTO {_prefix_}members VALUES ('1', '', 'Mr.', 'appRain', 'CMF', 'afdd0b4ad2ec172c586e2150770fbf9e', 'info@apprain.com', 'appCity, appCountry', 'dhaka', '1209', 'BD', '', '0000-00-00', 'www.apprain.com', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean volutpat consequat rhoncus. Pellentesque pharetra dictum viverra. Vivamus nisl leo, malesuada ut commodo eu, laoreet sit amet dolor. Duis scelerisque viverra rutrum. Cras et bibendum libero. Vivamus ante diam, volutpat et gravida posuere, adipiscing tristique sapien. Donec eget tortor vitae erat pharetra dapibus et eu lectus. Nullam interdum mollis nisl at commodo. Duis vestibulum nunc in risus placerat ac rhoncus mi fringilla.', '2009-03-28', '1209', 'Active', '1284736279');
-- query
DROP TABLE IF EXISTS {_prefix_}pages;
-- query
CREATE TABLE `{_prefix_}pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fkey` int(11) NOT NULL DEFAULT '0',
  `page_title` varchar(80) NOT NULL,
  `meta_keywords` varchar(200) NOT NULL,
  `meta_description` varchar(150) NOT NULL,
  `name` varchar(200) NOT NULL,
  `title` varchar(200) NOT NULL,
  `content` text NOT NULL,
  `hook` varchar(255) NOT NULL,
  `userdefinehook` varchar(256) NOT NULL,
  `richtexteditor` enum('Yes','No') NOT NULL, 
  `rendertype` enum('h_link','smart_h_link','text') NOT NULL,
  `contenttype` enum('Content','Snip') NOT NULL DEFAULT 'Content',
  PRIMARY KEY (`id`),
  UNIQUE KEY `fkey` (`fkey`,`name`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;
-- query
INSERT INTO {_prefix_}pages VALUES ('1', '0', 'About appRain:  PHP Content  Management Framework | Content Management System | ', 'About Content Management System, PHP Framework, PHP Content Management System, PHP CMS, Web Development Tool, Project Development Tool', 'A PHP Content Management Framework is Combination of CMS(Content Management System) and Framework (Rapid Development Framework) the best Agile Web Dev', 'aboutus', 'About Us', '<h1>
	About appRain</h1>
<p>
	appRain is one of the first officially released Open Source Content Management Framework (CMF). CMF is a new web engineering concept where &quot;CMS (Content Management System)&quot; and Rapid Development Framework perform side by side to produce endless varieties of output in a very limited time.<br />
	<br />
	It&#39;s&nbsp;is developed&nbsp;on a daily basis&nbsp;drawing on extensive&nbsp; project experience . A common problem that we all face in framework is that&nbsp;we need to redevelop some common modules in each project. In CMS sometimes we get&nbsp;stuck&nbsp;driving our development due to strict development&nbsp;conventions. So&nbsp;the a common question is,&nbsp;why there is no CMS integrated with Framework? It was actually this first concept&nbsp;that gave&nbsp;birth to the&nbsp;appRain development. It is&nbsp;now published with many extensive features to reduce development work time&nbsp;and give a&nbsp;high quality output.<br />
	<br />
	CMS and Framework are very popular and staple terms in web development. These two tools work in two different ways. One we use for rapid development and another one for more customizable output. AppRain is&nbsp;a merging&nbsp;of these two web development&nbsp;technologies. It is extremely&nbsp;fast, flexible&nbsp;and makes it&nbsp;easy to complete tasks in a very short time period. It is&nbsp;also expandable and scaleable.<br />
	<br />
	&nbsp;The CMS part in appRain contains all configurable tools so that we&nbsp;will make the development faster. It helps to avoid repeating tasks. The&nbsp;Framework Part is used when it become difficult to complete the requirements with CMS tools. It contains all core programming tools so that we can move the development as&nbsp;and when we&nbsp;need it.<br />
	&nbsp;<br />
	&nbsp;The&nbsp;initiative is&nbsp;to make web technology&nbsp;simplified and&nbsp;easlily optimized.</p>
', 'sitemenu,quicklinks,template_footer_after_footer_menu','', 'Yes', 'smart_h_link', 'Content');
-- query
INSERT INTO {_prefix_}pages VALUES ('2', '0', 'Template and Themes: Easy Template setup in appRain Content Management Framework', 'themes, templates, web, development', '', 'template-and-theme', 'Template and Themes ', '<p>
	See some of the&nbsp;common features that you will require to begin development.</p>
<h2>
	Select/Setup theme:</h2>
<p>
	You can enable and disable the&nbsp;existing&nbsp;theme from the&nbsp;following location in the admin panel:<br />
	&gt; Preference &gt;Theme <br />
	You can see the&nbsp;selected theme under the&nbsp;&ldquo;Current Theme&rdquo; section. Click on the&nbsp;&ldquo;Install&rdquo; link to change to an&nbsp;alternative theme.</p>
<h2>
	Theme Settings:</h2>
<p>
	Most of the themes have setting sections. You can configure some of the&nbsp;common settings from this section.&nbsp;The most common task we perform from settings are, change the&nbsp;logo, enable or disabled member functionalities in the&nbsp;website front side etc.<br />
	Location: &gt;Preference &gt;Theme &gt;Settings</p>
<h2>
	Render Content inside Theme:</h2>
<p>
	There are several process to render content inside a theme. &quot;Page Manager&quot; is a common tool that we use to manage content and configure SEO. You can assign new page in the&nbsp;site menu or post content&nbsp;on other pages. Enable &quot;Show Hook Position&quot; from Preference &gt; Configuration to view the places holders.&nbsp;</p>
<p>
	Use Snip to write PHP code in side page manager.</p>
<h2>
	Edit Theme HTML and CSS:</h2>
<p>
	You can edit template HTML and CSS from the&nbsp;appEditor or Theme Menu inside &quot;Preference&quot; tab. The system always keeps a backup of edited files for further recovery.</p>
<h2>
	Develop new Theme:</h2>
<p>
	You will&nbsp;need some programming skill to develop a theme from a&nbsp;very basic form. Theme is a part of MVC pattern. First you have to create a new theme folder inside &quot;view&quot; and a definition XML file introduce the theme in System Environment.</p>
<p>
	Themes follow Common MVC rule to adjust themes with the&nbsp;Controller URL.&nbsp; A template that comes from Component can render inside theme. You can define the &quot;Hook&quot; information in definition XML to make it available in page manager.</p>
', 'quicklinks,template_footer_before_footer_menu','', 'Yes', 'smart_h_link', 'Content');
-- query
INSERT INTO {_prefix_}pages VALUES ('3', '0', '', '', '', 'samplephp', '', '<?php
/**
* Write PHP Code
*
* Example:
* $Config = App::Config()->siteInfo();
* pre($Config);
*/
?>

<?php echo App::Helper(''Date'')->getDate(''Y-m-d H:i:s'');?>', '','', 'Yes', 'h_link', 'Snip');
-- query
INSERT INTO {_prefix_}pages VALUES ('4', '0', 'Contact Us: We welcome your feedback please do not hesitate', 'Open source, framework, web development, cms, code', 'Open-source Content Management Framework (CMF) from appRain for rapid website development', 'contact-us', 'Contact us any time', '<p>
	appRain is one of the first officially released Opensource Content Management Framework (CMF). CMF is a new web engineering concept where &quot;CMS (Content Management System)&quot; and &quot;Framework&quot; perform together to produce endless varieties of output in a very limited time. <br />
	<br />
	appRain, published with lots of extensive features to reduce our development work time. It satisfies both Clients and&nbsp; Developers with a safe and quality output.</p>
<p>
	We welcome your feedback please do not hesitate to contact us&nbsp;<br />
	&nbsp;</p>
<p>
	<br />
	<strong>appRain</strong><br />
	<em>Content Management Framework</em><br />
	For Endless Rapid Development <br />
	<a href="http://www.apprain.com">info@apprain.com<br />
	http://www.apprain.com</a></p>
', '', '', 'Yes','h_link', 'Content');
-- query
INSERT INTO {_prefix_}pages VALUES ('5', '0', 'Component: Access unlimited features in appRain Content Management Framework ', 'Blog, Store, Forum, Gallery, News, Videos ', 'Add more features in website by a single click ', 'component', 'Component', '<p>
	Components are mostly dynamic tools that will help you to integrate additional features in your&nbsp;website.&nbsp;They are&nbsp;common features that help us in the initial stages of website development.</p>
<h2>
	The Effectiveness of Components:</h2>
<p>
	A Component is a moveable part of your website. It&rsquo;s easy to install and simple to distribute. If you develop a component&nbsp;then you never have to develop the same feature again for other projects.&nbsp;It saves time and helps you&nbsp;to mature and develop&nbsp;your code. <br />
	<br />
	The appRain default version already contains essential components and&nbsp;you can also download other components&nbsp;from the appRain&nbsp;official website. &nbsp;</p>
<h2>
	Install/Uninstall components:</h2>
<p>
	Go to the component tab in the&nbsp;admin panel and click &ldquo;Activate&rdquo; link to install default components.&nbsp; It will develop all additional admin panel features and database during the&nbsp;installation. &nbsp;<br />
	<br />
	Download the&nbsp;other components from the&nbsp;appRain official website and install&nbsp;them from the&nbsp;admin panel.</p>
<p>
	Browse component .zip file from your component tab and click the&nbsp;&ldquo;Install&rdquo; button. The system will then&nbsp;automatically extract the source code and automatically&nbsp;install it. <br />
	<br />
	Click on the&nbsp;&quot;Deactivate&quot; link to temporary uninstall the component. You can also remove&nbsp;the component&nbsp;by clicking on the&nbsp;&quot;Remove&quot; link.</p>
<h2>
	Develop Component:</h2>
<p>
	Component is a Complete MVC module that plug with base MVC framework and execute operation. You can register &quot;Controller&quot;, &quot;Model&quot;, &quot;View&quot;, &quot;Helper&quot;, &quot;Information Set&quot;, &quot;Category Set&quot;, &quot;Interface Builder&quot;,&quot;URI Manager&quot;, &quot;Addons&quot; and most of the other base parts. <br />
	<br />
	To develop a component first you have to create &quot;register.php&quot; and &quot;definition.xml&quot; to introduce the Component and information in the system. &nbsp;<br />
	<br />
	Each components has a base function &quot;init ()&quot; inside register.php. We register all our resources in that base function to load resources. We have two common trigger functions &quot;init_on_install()&quot;, &quot;init_on_uninstall()&quot; . These two function runs during install and uninstall a component.</p>
<h2>
	Caution:</h2>
<p>
	In Components we have to access all resource by App factory. For example you have to use App::Config()-&gt;baseUrl() instated of&nbsp; $this-&gt;baseUrl() in the&nbsp;component environment. <br />
	<br />
	Most of the time we update Database and other common resource in&nbsp; &quot;init_on_install&quot; method. We always recommend to clear all unnecessary data during uninstall in &quot;init_on_uninstall&quot; also please check proper existence of object before create at the begining of the&nbsp;installation. <br />
	<br />
	Never remove any&nbsp;required data like Order information or&nbsp;Payment information&nbsp; when you uninstall component. <br />
	<br />
	Always create an Installer of your component to re-distribute it. <br />
	<br />
	You have to&nbsp;use a&nbsp;component reference to call a helper which is registered by the&nbsp;component. For example - App::Component(&lsquo;appStore&rsquo;)-&gt;Helper(&lsquo;Orderprocess&rsquo;). &nbsp;</p>
<h2>
	Performance:</h2>
<p>
	Components always gives you a&nbsp;better performance because it plugs all external resource and it goes into&nbsp;sleep mode when uninstalled. <br />
	<br />
	It helps to distribute your work easily and saves working time.&nbsp;If&nbsp;&nbsp;you have developed a complete project by a single component so we recommend component focused development.</p>
', 'quicklinks,template_footer_before_footer_menu', '', 'Yes','smart_h_link', 'Content');
-- query
INSERT INTO {_prefix_}pages VALUES ('6', '0', 'appRain:  Content  Management Framework is a combination of Content Management S', 'Content Management System, PHP Framework, PHP Content Management System, PHP CMS, Web Development Tool, Project Development Tool', 'A PHP Content Management Framework combining  CMS(Content Management System) and Framework (Rapid Development Framework) to enable fast Web Developmen', 'home-page', 'What is appRain  Content Management Framework?', '<p>
	appRain is one of the first officially released Opensource Content Management Framework (CMF). CMF is a new web engineering concept where &quot;CMS (Content Management System)&quot; and &quot;Framework&quot; perform together to produce endless varieties of output in a very limited time.</p>
<p>
	appRain, published with lots of extensive features to reduce our development work time. It satisfies both Client and Developers with a safe and quality output.</p>
', '', '', 'Yes','smart_h_link', 'Content');
-- query
INSERT INTO {_prefix_}pages VALUES ('7', '0', 'Resources : appRain optimized the resources usages ', 'MVC, Components, Modules, Page Manager, Helper, Plugin, Auto Load, Web service, JavaScript,  ', 'appRain optimized and utilize resource usages ', 'resources', 'Resources', '<p>
	The main strength of appRain is best utilization of resource. When we require developing an uncommon feature that does not support by default tools and components then we directly move to Framework functionally to get the desired support. Here you are going get a brief touch to get started:</p>
<h2>
	MVC (Model-View-Controller) Pattern:</h2>
<p>
	You will get all resource in&nbsp;&nbsp; &quot;development&quot; folder. Your will see all Controllers and Models are saved in &quot;controller&quot; and &quot;Model&quot; folder. A function in controller create a new page only if we add a keyword &quot;Action&quot; at end of the name.This way helps to avoid a function to hide from web access.</p>
<pre>public function searchAction(){
}</pre>
<p>
	General purpose of a model is to manage data from database. We access a model through &quot;App&quot; factory like</p>
<pre>App::Model(&#39;Member&#39;)-&gt;findALL()</pre>
<p>
	Some other major purposes of a model are data validation, installation and execute call back functions.</p>
<p>
	<strong>Model</strong> installer helps to auto execute SQL statement based on model version. System always looks for update version of a model to execute command and adjust the new version in repository.</p>
<p>
	<strong>Call back functions</strong> run in different event&nbsp;&nbsp; like After Save, Before Save, On Validation Success, and On Validation failed. All these are auxiliary function in a Model Class.</p>
<p>
	<strong>View</strong> always helps to display any output. In appRain we divide View in different &quot;Theme&quot; inside &quot;View&quot; folder. Each theme directory contains template files of each controller and on additional we have other folder &quot;Definition&quot;, &quot;Element&quot; and &quot;Layout&quot;. Layout is a common placeholder where every template include itself. Element helps to split a template in multiple parts to reuse a single resource.</p>
<p>
	Definition folder content common setting, author information and Logo and UI Hook information. UI Hook is a dynamic &quot;Shortcut Link&quot; to allow an administrator to put&nbsp; static content or PHP Content in website. An UI hook is simply like bellow:</p>
<pre>App::Hook(&#39;UI&#39;)-&gt;Render(&#39;home_page_banner&#39;);</pre>
<p>
	If a developer add a hook in anywhere in the template then Administrator can place number of content dynamically. Most easy way is to add the Hook Name in info.xml to display that directly page manager select list.</p>
<h2>
	Helper, Plugin, Auto Load:</h2>
<p>
	You have enough function and resource already developed for use. Helper is one of the common resources you can use. You have to call a helper like App::Helper(&lsquo;Config&rsquo;)-&gt;baseUrl(). All default helpers are developer inside &quot;appRain/base/modules&rdquo;. Common helpers are Config, CronJob, Date, EmailTemplate, Html, Javascript, Log, Search, Toolbar, Utility, validation. If you like to add any function in a helper then you have to extend function in &quot;development/helper&rdquo;.</p>
<p>
	Plugin is like helper but this process used to integrate any third party PHP class. We copy plugins in &quot;development/plugin&rdquo; folder. A class name must be come with it&#39;s path name . See following example</p>
<pre>class Development_Plugin_Paypal_Standard {
}
</pre>
<p>
	Any class in appRain is auto loaded if we assign class name by path name. If we save a class in appRain/module/remote.php then class name will be</p>
<pre>class appRain_module_remove{
}
</pre>
<h2>
	Information Set, Category Set</h2>
<p>
	We use information Set and category Set to create data update form and database table automatically. It always save time and make the development faster. We save category set and information Set in <br />
	development/definition/categoryset and development/definition/informationset</p>
<p>
	Interface Builder, Site Settings, System Configuration, URI Manager<br />
	All these module are simple XML configuration and it develop admin interface quick and easily. All these definitions are available in &ldquo;development/definition&rdquo; folder in respective folders.</p>
<p>
	Interface Builder is used to develop admin Menu and render a page inside it. It automatically add in user ACL(Access control Limit).</p>
<p>
	Site setting create different type of setting interface. It&rsquo;s a quick process to create section for administrator to change website parameters.</p>
<p>
	Site Configuration section helps to change common setting of website.</p>
<p>
	URI Manager is used to change website URL patterns to make it user friendly.</p>
<h2>
	Addons:</h2>
<p>
	Add-ons helper to add third-party&nbsp; Non-PHP libraries. We create a XML configuration for each addons and save in development/definition/addons folder. We can configure it to load from Controller method or auto load in every page. It&rsquo;s always save us from unnecessary resource loading.</p>
<h2>
	Web Service:</h2>
<p>
	It&rsquo;s very simple to create a web service in appRain. You have a helper in &ldquo;development/helper/api&rdquo; to create WSDL automatically.&nbsp; We have to create a class like</p>
<pre>class Development_Helper_Api_testService {
}</pre><pre>The WSDL will be like www.example.com/developer/webservice/testservice/wsdl</pre>
<h2>
	JavaScript</h2>
<p>
	Specially library is developed of AJAX, Validation. A simple line of code will cover all your purposes. Example:</p>
<pre>App::Helper(&#39;JavaScript&#39;)-&gt;setAjax(array(&quot;debug&quot;=&gt;false,&quot;autoHide&quot;=&gt;true))-&gt;appForm(&#39;.{_prefix_}contact&#39;);</pre>
<h2>
	Components:</h2>
<p>
	Component is an external module that we keep out side of actual development code in &ldquo;component&rdquo; directory in different folder. Each component is a framework itself which execute with help of base framework. We can create Model, View, Controller, Information Set, Category Set, Interface Builder, URI Manager and every other part that we can do in development folder. But the main advantaged is we can move full source code just coping the Component Base folder in other project.</p>
<p>
	Each component has two basic files register.php to register all necessary resource and definition.xml to enter author information, Help etc .</p>
<p>
	In component we always use App factory to access resources for example App:: Config()-&gt;siteInfo() instated of $this-&gt; Config()-&gt;siteInfo()</p>
<h2>
	Admin Interface</h2>
<p>
	To create base Admin Panel structure we use &quot;Interface Builder&quot; and &quot;Site setting&quot;. Beside these we have other tools to create admin interface like Tool Bar, Data Grid, Notification, Message Box, row manager etc.</p>
<p>
	Toolbar helps to create top and bottom tool bar with button. Top toolbar always contain a title and in bottom tool be we never pass that</p>
<pre>App::Helper(&#39;Toolbar&#39;)-&gt;setTitle(&quot;Account Information&quot;)-&gt;setBtnBack()-&gt;Render(array(&#39;code&#39;=&gt;&#39;member_account_view_top&#39;,&#39;id&#39;=&gt;$member_info[&#39;id&#39;]));</pre>
<p>
	Each toolbar can be passed in a call back function for component. We identify a tool bar by code and additional data pass in the array inside Render function.</p>
<p>
	Data Grid always helps to present data in tabular or form view. See following example:</p>
<pre>$Grid = App::Module(&#39;DataGrid&#39;)-&gt;setDisplay(&#39;FormListing&#39;)
     -&gt;addRow(&#39;First Name&#39;, &#39;Jhon&#39;)
     -&gt;addRow(&#39;Last Name&#39;, &#39;Regan&#39;)
     -&gt;addRow(&#39;Email&#39;, App::Helper(&#39;Html&#39;)-&gt;inputTag(&#39;data[Member][f_name]&#39;,&#39;jhon@yahoo.co&#39;))
     -&gt;Render();</pre>
<p>
	Notification is a helper that helps to display message on demand. It creates a session for a message and display bellow the right bar. See example bellow:</p>
<pre>App::Module(&#39;Notification&#39;)-&gt;Push(&quot;Database Imported successfully&quot;,&quot;Error&quot;);</pre>
<p>
	Message box is an element to display message inside template.</p>
<pre>echo $this-&gt;callElement(&#39;default/tools/message&#39;, array(&#39;caption&#39; =&gt;&#39;Message&#39;,&#39;type&#39; =&gt; &#39;error&#39;, &#39;message&#39; =&gt; &#39;No Data found));</pre>
<p>
	Row Manager is a addon the allow us to delete any row in a Data Grid or ask for confirmation. We have to add a link like bellow to make it a delete button:</p>
<pre>{lt}a title=&quot;Member_1&quot; class=&quot;link_delete icon&quot; href=&quot;javascript:void(0)&quot;{gt}Delete{lt}/a{gt}
</pre>
<p>
	First we have to add a title with id and source name separated by underscore(_) and a class &ldquo;link_delete&rdquo;. Source name can be a Model Name, Information Set(Information), Category Set(Category).</p>
<h2>
	Static Page/Snip</h2>
<p>
	Page manger helps us to place content in different place of a website. We can render a page inside another page. Click on &ldquo;Code Link&rdquo; list in page manager to see the list of code. A page will render inside if you copy the code in content.</p>
<p>
	Snip we use to write PHP code and it render inside static page only. In Snip we have to access all resource by app factory.<br />
See Example: {{name=UI type=staticpage name=samplephp autoformat=off}}</p>
<h2>
	Object Exporting</h2>
<p>
	appRain shares all resource by App Factory. By including this factory you can use any resource outside of environment. To use resource you have to include app.php from appRain root.</p>
<p>
	This method widely used for multi-domain website and to execute a script in CLI(Command Line Interpreter)</p>
<h2>
	Common functions/Objects</h2>
<table border="0">
	<tbody>
		<tr>
			<td>
				<p>
					<strong>General Function/Objects</strong></p>
			</td>
			<td>
				<p>
					<strong>Comments</strong></p>
			</td>
		</tr>
		<tr>
			<td>
				<pre>App::Config()-&gt;siteInfo()</pre></td>
			<td>
				Retrieve site settings. It return full array if no respective value found</td>
		</tr>
		<tr>
			<td>
				<pre>App::Config()-&gt;setting()</pre></td>
			<td>
				Retrieve site site setting. Return empty string if no respective value found</td>
		</tr>
		<tr>
			<td>
				<pre>App::Config()-&gt;baseUrl()</pre></td>
			<td>
				Return base URL of the website</td>
		</tr>
		<tr>
			<td>
				<pre>App::Config()-&gt;baseDir()</pre></td>
			<td>
				Return base directory path of the website</td>
		</tr>
		<tr>
			<td>
				<pre>App::Config()-&gt;rootDir()</pre></td>
			<td>
				Return Root directory of the path</td>
		</tr>
		<tr>
			<td>
				<pre>App::Config()-&gt;skinUrl()</pre></td>
			<td>
				Return Theme URL of the website</td>
		</tr>
		<tr>
			<td>
				<pre>App::Config()-&gt;filemanagerurl()</pre></td>
			<td>
				Return file manager URL of the website</td>
		</tr>
		<tr>
			<td>
				<pre>App::Config()-&gt;filemanagerdir()</pre></td>
			<td>
				Return File Manager directory path of the website</td>
		</tr>
		<tr>
			<td>
				<pre>App::Config()-&gt;redirect()</pre></td>
			<td>
				Redirect the website URL in other URL</td>
		</tr>
		<tr>
			<td>
				<pre>App::Config()-&gt;transfer()</pre></td>
			<td>
				Redirect the website displaying a message</td>
		</tr>
		<tr>
			<td>
				<pre>App::Config()-&gt;getServerInfo()</pre></td>
			<td>
				Get Server value from server variable</td>
		</tr>
		<tr>
			<td>
				<pre>App::Config()-&gt;getProtocol ()</pre></td>
			<td>
				Get HTTP/HTTPS setting</td>
		</tr>
		<tr>
			<td>
				<pre>App::_Obj()</pre></td>
			<td>
				Create object of a Class</td>
		</tr>
		<tr>
			<td>
				<pre>App::Helper(&#39;Html&#39;)</pre></td>
			<td>
				Create HTML elements</td>
		</tr>
		<tr>
			<td>
				<pre>App::Helper(&#39;CronJob&#39;)</pre></td>
			<td>
				Create a cron job Service.</td>
		</tr>
		<tr>
			<td>
				<pre>App::Helper(&#39;Date&#39;)</pre></td>
			<td>
				Generate date values</td>
		</tr>
		<tr>
			<td>
				<pre>App::Helper(&#39;Emailtemplate&#39;)</pre></td>
			<td>
				Send email based on email templates</td>
		</tr>
		<tr>
			<td>
				<pre>App::Helper(&#39;JavaScript&#39;)</pre></td>
			<td>
				AJAX form submit and validation</td>
		</tr>
		<tr>
			<td>
				<pre>App::Helper(&#39;Log&#39;)</pre></td>
			<td>
				Create file/database log</td>
		</tr>
		<tr>
			<td>
				<pre>App::Helper(&#39;Search&#39;)</pre></td>
			<td>
				Create a general search result</td>
		</tr>
		<tr>
			<td>
				<pre>App::Helper(&#39;Utility&#39;)</pre></td>
			<td>
				All utility function available here</td>
		</tr>
		<tr>
			<td>
				<pre>App::Helper(&#39;Validation&#39;)</pre></td>
			<td>
				Create php validation</td>
		</tr>
		<tr>
			<td>
				<pre>App::pageManager()</pre></td>
			<td>
				Work with Page manager functionalists</td>
		</tr>
		<tr>
			<td>
				<pre>App::setUserStatusId()</pre></td>
			<td>
				Set User profile id. 0 for super admin and grater then zero for any appUser</td>
		</tr>
		<tr>
			<td>
				<pre>App::AdminManager()</pre></td>
			<td>
				Work with administrators</td>
		</tr>
		<tr>
			<td>
				<pre>App::MemberManager()</pre></td>
			<td>
				Work with website members</td>
		</tr>
		<tr>
			<td>
				<pre>App::CategorySet()</pre></td>
			<td>
				Work with Category Set</td>
		</tr>
		<tr>
			<td>
				<pre>App::InformationSet()</pre></td>
			<td>
				Work with Information Set</td>
		</tr>
		<tr>
			<td>
				<pre>App::Session()</pre></td>
			<td>
				Manage session</td>
		</tr>
		<tr>
			<td>
				<pre>App::Plugin()</pre></td>
			<td>
				Load and access plugin classes</td>
		</tr>
		<tr>
			<td>
				<pre>App::Model()</pre></td>
			<td>
				Work with model functions</td>
		</tr>
		<tr>
			<td>
				<pre>App::Component()</pre></td>
			<td>
				Load and access Components</td>
		</tr>
		<tr>
			<td>
				<pre>App::Hook()</pre></td>
			<td>
				Create any kind of hook</td>
		</tr>
		<tr>
			<td>
				<pre>App::Module(&#39;Acl&#39;)</pre></td>
			<td>
				Work with Access Control Limit</td>
		</tr>
		<tr>
			<td>
				<pre>App::Module(&#39;Cache&#39;)</pre></td>
			<td>
				Manage system Cache</td>
		</tr>
		<tr>
			<td>
				<pre>App::Module(&#39;Cookie&#39;)</pre></td>
			<td>
				Works with Cookies</td>
		</tr>
		<tr>
			<td>
				<pre>App::Module(&#39;Cryptography&#39;)</pre></td>
			<td>
				Generate encrypted value</td>
		</tr>
		<tr>
			<td>
				<pre>App::Module(&#39;Datagrid&#39;)</pre></td>
			<td>
				Crate Data Grid</td>
		</tr>
		<tr>
			<td>
				<pre>App::Module(&#39;DBImExport&#39;)</pre></td>
			<td>
				Inport,Export, backup database</td>
		</tr>
		<tr>
			<td>
				<pre>App::Module(&#39;Ftp&#39;)</pre></td>
			<td>
				Work with ftps</td>
		</tr>
		<tr>
			<td>
				<pre>App::Module(&#39;Notification&#39;)</pre></td>
			<td>
				Generate any adminpanel notifications</td>
		</tr>
		<tr>
			<td>
				<pre>App::Module(&#39;Remote&#39;)</pre></td>
			<td>
				Work with Remote Connection</td>
		</tr>
		<tr>
			<td>
				<pre>App::Module(&#39;Toolbar&#39;)</pre></td>
			<td>
				Create admin panel tools bar</td>
		</tr>
		<tr>
			<td>
				<pre>App::Module(&#39;Zip&#39;)</pre></td>
			<td>
				Zip/unzip data</td>
		</tr>
		<tr>
			<td>
				<pre>Before_render()</pre></td>
			<td>
				Call back function run before render output</td>
		</tr>
		<tr>
			<td>
				<pre>Before_admin_rende()</pre></td>
			<td>
				Runs after render output</td>
		</tr>
		<tr>
			<td>
				<pre>after_render()</pre></td>
			<td>
				Runs befor admin panel render</td>
		</tr>
		<tr>
			<td>
				<pre>after_adminpanel_render()</pre></td>
			<td>
				Runs After Adminpanel Render</td>
		</tr>
		<tr>
			<td>
				<pre>before_addon_load()</pre></td>
			<td>
				Runs befer each addon load</td>
		</tr>
		<tr>
			<td>
				<pre>after_addon_load()</pre></td>
			<td>
				Runs after each addon load</td>
		</tr>
		<tr>
			<td>
				<pre>on_information_set_view()</pre></td>
			<td>
				Runs when we view an Information Set in adminpanel</td>
		</tr>
		<tr>
			<td>
				<pre>on_information_set_delete()</pre></td>
			<td>
				Runs when we delete any information set</td>
		</tr>
		<tr>
			<td>
				<pre>before_information_set_save()</pre></td>
			<td>
				Runs before save any informationset</td>
		</tr>
		<tr>
			<td>
				<pre>after_information_set_save()</pre></td>
			<td>
				Runs after we save any information set</td>
		</tr>
		<tr>
			<td>
				<pre>_before_search_init()</pre></td>
			<td>
				Runs before we genearte serch result</td>
		</tr>
		<tr>
			<td>
				<pre>after_search_init()</pre></td>
			<td>
				Runs after we generte serch result</td>
		</tr>
		<tr>
			<td>
				<pre>on_uri_definition_init()</pre></td>
			<td>
				Runs when we crete URI definition</td>
		</tr>
	</tbody>
</table>
<p>
	Your will find reference in appRain website. Also these function and object are developerd in &#39;appRain/base/modules&#39; in different files. You can open and search for necessary functions.</p>
', 'quicklinks,template_footer_before_footer_menu', '', 'Yes','smart_h_link', 'Content');
-- query
DROP TABLE IF EXISTS {_prefix_}sconfigs;
-- query
CREATE TABLE `{_prefix_}sconfigs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fkey` int(11) NOT NULL DEFAULT '0',
  `soption` text NOT NULL,
  `svalue` text NOT NULL,
  `sort_order` varchar(5) NOT NULL,
  `section` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=90 DEFAULT CHARSET=utf8;
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('1', '0', 'site_title', 'Start with appRain', '13', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('2', '0', 'admin_email', 'info@site.com', '14', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('3', '0', 'admin_title', 'Start with appRain Admin', '15', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('4', '0', 'support_email', 'info@apprain.com', '16', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('5', '0', 'website_moto', 'Sed congue dolor egestas metus', '17', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('6', '0', 'currency', '$', '18', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('7', '0', 'default_pagination', '15', '19', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('8', '0', 'is_site_alive', 'Yes', '20', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('9', '0', 'large_image_width', '500', '21', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('10', '0', 'large_image_height', '500', '22', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('11', '0', 'time_zone', 'Asia/Dhaka', '23', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('12', '0', 'rich_text_editor', 'Yes', '24', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('13', '0', 'rich_text_editor_mode', 'Simple', '25', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('14', '0', 'replace_cache', 'No', '26', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('15', '0', 'disable_page_meta_options', 'No', '27', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('16', '0', 'theme', 'whitecloud', '28', 'hidden');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('17', '0', 'disable_accordion', 'Yes', '', 'opts');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('18', '0', 'site_logo_1', 'logo.gif', '', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('19', '0', 'site_logo_2', 'apprain-logo-yellow.gif', '', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('20', '0', 'copy_right_text', 'Copy Right [year] [website]', '', 'general');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('21', '0', 'activity_wiget', 'Yes', '', 'opts');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('22', '0', 'leave_amessage_wiget', 'Yes', '', 'opts');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('23', '0', 'whitecloud_disable_site_member_options', 'Yes', '', 'settings');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('24', '0', 'add_new_page_in_menu_automarically', 'Yes', '', 'opts');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('25', '0', 'disable_site_member_options', 'Yes', '', 'settings');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('26', '0', 'contactussettings_title', 'Contact Us', '', 'contactussettings');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('27', '0', 'contactussettings_replay_email_title', '', '', 'contactussettings');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('28', '0', 'contactussettings_replay_email', '', '', 'contactussettings');
-- query
INSERT INTO {_prefix_}sconfigs VALUES ('29', '0', 'contactussettings_create_sitemenu', 'Yes', '', 'contactussettings');
