<?php
/**
 * appRain CMF
 *
 * LICENSE
 *
 * This source file is subject to the MIT license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.opensource.org/licenses/mit-license.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@apprain.com so we can send you a copy immediately.
 *
 * @copyright  Copyright (c) 2010 appRain, Team. (http://www.apprain.com)
 * @license    http://www.opensource.org/licenses/mit-license.php MIT license
 *
 * HELP
 *
 * Official Website
 * http://www.apprain.com/
 *
 * Download Link
 * http://www.apprain.com/download
 *
 * Documents Link
 * http ://www.apprain.com/docs
 */


class memberModel extends appRain_Base_Model
{
    public $version         = "0.1.0";
	public $name = "Member";
	public $db_table = "members";
	public $relation = array();

    protected $model_validation = Array
    (
        "f_name"    => Array("rule"=>"notEmpty","message"=>"Please enter a first name"),
        "l_name"    => Array("rule"=>"notEmpty","message"=>"Please enter a first name"),
        "email"     => Array(
                                Array("rule"=>"email","message"=>"Invalide Email Address"),
                                Array("rule"=>"unique","message"=>"Email Address Already Exists")
                            ),
        "address"   => Array("rule"=>"notEmpty","message"=>"Enter a valid Address"),
        "country"   => Array("rule"=>"notEmpty","message"=>"Select country"),
        "signup_date"  => Array("rule"=>"date","message"=>"Invalide date entered"),
        "status"    => Array("rule"=>"inList","options"=>array("Applied","Active","Inactive"),"message"=>"Invalide Member Status"),
    );
}
