<?php
/**
 * appRain CMF
 *
 * LICENSE
 *
 * This source file is subject to the MIT license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.opensource.org/licenses/mit-license.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@apprain.com so we can send you a copy immediately.
 *
 * @copyright  Copyright (c) 2010 appRain, Team. (http://www.apprain.com)
 * @license    http://www.opensource.org/licenses/mit-license.php MIT license
 *
 * HELP
 *
 * Official Website
 * http://www.apprain.com/
 *
 * Download Link
 * http://www.apprain.com/download
 *
 * Documents Link
 * http ://www.apprain.com/docs
 */

class pageController extends appRain_Base_Core
{
    public $name = 'Page';

    /**
     * This function will reander the home page
     *
     * @return null
     */
    private function index()
    {
    }

    /**
     * Mange static page
     *
     * @parameter page_id integer
     * @return null
     */
    public function manageAction( $action = "update", $page_id = NULL )
    {
        // Check access
        $errors = Array();
        $this->setAdminTab('page_manager');
        $this->addons = array('rich_text_editor','linedtextarea','dialogs');

        // Save page
        if( !empty( $this->data ))
        {
			
            if( isset($this->post['Button']['button_delete']))
            {
                App::Load("Model/Page")->DeleteById($page_id);
                App::Module('Notification')->Push("Deleted successfully.");
                $this->redirect("/page/manage");
                exit;
            }
            else
            {
				if(isset($this->data['Page']['hook']) and !empty($this->data['Page']['hook'])){
					$this->data['Page']['hook'] = implode(',',$this->data['Page']['hook']);
				}
				else {
					$this->data['Page']['hook'] = '';
				}
				
                if( $action == 'create')
                {
                    $anpima = App::Config()->siteInfo('add_new_page_in_menu_automarically',1);
                    if($anpima != 'No')
                    {
                        $this->data['Page']['hook'] = 'sitemenu';
                        $this->data['Page']['rendertype'] = 'smart_h_link';
                    }
                }
                $this->data['Page']['fkey']= $this->getUserStatusId();
                if(isset($this->data['Page']['name']))
                {
                    $this->data['Page']['name'] = App::Helper('Utility')->text2NOrmalize($this->data['Page']['name']);
                }
                $result = App::Load("Model/Page")->Save($this->data);
                $errors = $result->getErrorInfo();

                if(empty($errors))
                {
                    App::Module('Notification')->Push("Updated successfully.");
                    $this->redirect("/page/manage/update/" . $result->getId());
                    exit;
                }
                else
                {
                    App::Module('Notification')->Push(implode("<br />",$errors),Array('level'=>'Error'));
                }

            }
        }

        if( $action == 'update' || $action == 'snip')
        {
            $page_arr = App::Pagemanager()->Pages("name_only");

            if(empty($page_arr))
            {
                $this->redirect("/page/manage/create");
                exit;
            }
            $this->set( 'static_page_arr', $page_arr);

            $page_id = isset(  $page_id )?  $page_id : key( $page_arr ) ;
            $this->set('page_id',$page_id);

            $page_current = App::PageManager()->Pages( $page_id );
            $this->set("page_current",$page_current );
        }
		else if ($action == 'ues'){
			$page = App::PageManager()->Pages( $page_id );
			$newstatus = ($page['richtexteditor'] == 'Yes') ? 'No' : 'Yes';
			$obj =App::Model('Page')->setId($page_id)
				->setRichtexteditor($newstatus)
				->Save();
			$this->redirect("/page/manage/update/{$page_id}");
			exit;
		}

        $title = isset($page_current['name']) ? $page_current['name'] : 'Create Page';
        $this->set("action",$action );
        $this->page_title= "{$title}" . app::__def()->SysConfig('ADMIN_PAGE_TITLE_SAPARATOR') . "Page Manager";
        $this->set("page_id",$page_id);
    }

    /**
     * View page content by default it set to about us
     *
     * @parameter page_name string
     * @return null
     */
    public function viewAction( $page_name = 'about_us' )
    {
        $page_content = $this->staticPageNameToMetaInfo($page_name);

        if($page_content['contenttype']== 'Snip')
        {
            $this->redirect("/");
            exit;
        }

        $this->set("selected",$page_name);
        $this->set("section_title",$page_content['title']);
        $this->set( 'page_content' ,$page_content );
    }
}