<?php
/**
 * appRain CMF
 *
 * LICENSE
 *
 * This source file is subject to the MIT license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.opensource.org/licenses/mit-license.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@apprain.com so we can send you a copy immediately.
 *
 * @copyright  Copyright (c) 2010 appRain, Inc. (http://www.apprain.com)
 * @license    http://www.opensource.org/licenses/mit-license.php MIT license
 *
 * HELP
 *
 * Official Website
 * http://www.apprain.com/
 *
 * Download Link
 * http://www.apprain.com/download
 *
 * Documents Link
 * http ://www.apprain.com/documents
 */
class rssController extends appRain_Base_Core
{
    public $name = 'RSS';


    public function indexAction()
    {
		$this->layout= 'blank';
		header("Content-Type: application/xml; charset=ISO-8859-1");

		$xml =
		'<?xml version="1.0" encoding="UTF-8" ?>
		<rss version="2.0">
		<channel>
				<title>' . App::Helper('Config')->siteInfo('site_title') . '</title>
				<description>RSS feed</description>
				<link>' . $this->baseUrl() . '</link>
				<lastBuildDate></lastBuildDate>
				<pubDate></pubDate>';

				$data = App::InformationSet('simple-rss')
                    ->findAllByStatus('Active');
				foreach($data['data'] as $val){
					$xml .=
					"<item>
						<title>{$val['title']}</title>
						<description>{$val['desc']}</description>
						<link>{$val['link']}</link>
						<guid>{$val['shortdesc']}</guid>
						<pubDate>{$val['last_modified']}</pubDate>
					</item>";
				}
		$xml .='</channel>
		</rss>';

		echo $xml;

    }
}
