<?php
/**
 * appRain CMF
 *
 * LICENSE
 *
 * This source file is subject to the MIT license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.opensource.org/licenses/mit-license.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@apprain.com so we can send you a copy immediately.
 *
 * @copyright  Copyright (c) 2010 appRain, Inc. (http://www.apprain.com)
 * @license    http://www.opensource.org/licenses/mit-license.php MIT license
 *
 * HELP
 *
 * Official Website
 * http://www.apprain.com/
 *
 * Download Link
 * http://www.apprain.com/download
 *
 * Documents Link
 * http ://www.apprain.com/documents
 */
class newsController extends appRain_Base_Core
{
    public $name = 'News';

    /**
     * Execute before the action
     */
    public function __preDispatch()
    {
		$this->page_title = "News";
        $this->set("section_title","News");
    }

    /**
     * This is blog starting page
     * We have configure this page from
     * URI_Manager >> Boot_Router
     */
    public function indexAction($id=null)
    {
		$obj = App::InformationSet('appnews');
		if(isset($id)){
			$news = $obj->findAllById($id);
		}
		else{
			$news = $obj->setPagination('Yes')
			    ->setLimit(10)
				->setSmartPagination('No')
				->findAll(
                    "1 ORDER By id DESC",
                    array(
                        array(
                            "status"=>"Active"
                        )
                    )
                );
		}
		$this->set('news',$news);
    }
}
