<?php

/**
 * appRain CMF
 *
 * LICENSE
 *
 * This source file is subject to the MIT license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.opensource.org/licenses/mit-license.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@apprain.com so we can send you a copy immediately.
 *
 * @copyright  Copyright (c) 2010 appRain, Team. (http://www.apprain.com)
 * @license    http://www.opensource.org/licenses/mit-license.php MIT license
 *
 * HELP
 *
 * Official Website
 * http://www.apprain.com/
 *
 * Download Link
 * http://www.apprain.com/download
 *
 * Documents Link
 * http ://www.apprain.com/docs
 */

class Component_appbanners_register extends appRain_Base_Component
{
    public function init()
    {
        App::Module('Hook')
            ->setHookName('CSS')
            ->setAction("register_css_code")
            ->Register(get_class($this),"register_css_code");

        App::Module('Hook')
            ->setHookName('Javascript')
            ->setAction("register_javascript_code")
            ->Register(get_class($this),"register_javascript_code");

        App::Module('Hook')
            ->setHookName('UI')
            ->setAction("home_page_banner")
            ->Register(get_class($this),"add_html");

        App::Module('Hook')
            ->setHookName('InterfaceBuilder')
            ->setAction("update_definition")
            ->Register(get_class($this),"interfacebuilder_update_definition");

        App::Module('Hook')
            ->setHookName('InformationSet')
            ->setAction("register_definition")
            ->Register(get_class($this),"register_informationset_defination");
    }

    public function init_on_install(){}

    public function init_on_uninstall(){}

    public function register_css_code()
    {
        return App::Helper('Utility')->fetchFile($this->attachMyPath('css/styles.css'));
    }

    public function register_javascript_code()
    {
        return App::Helper('Utility')->fetchFile($this->attachMyPath('js/appslide.js'));
    }

    public function add_html($send)
    {
        $bannerData = App::InformationSet('app-banner')
            ->find(
                "1 ORDER BY RAND() LIMIT 1",
                Array(
                    Array(
                        "status"=>"Active"
                    )
                )
            );

        return App::Helper('Utility')->callElementByPath($this->attachMyPath('elements/banner.phtml'),array('bannerData'=>$bannerData));
    }

    public function interfacebuilder_update_definition($send)
    {
        if(isset($send['component']['child']))
        {
            $send['component']['child'][] = Array(
                "title"=>"Banner Rotator",
                "items"=>Array(
                    array(
                        "title"=>"New Banner",
                        "link"=>"/information/manage/app-banner/add"
                    ),
                    array(
                        "title"=>"Manage Banner",
                        "link"=>"/information/manage/app-banner"
                    )
                ),
                "adminicon" => array(
                    "type"=>"filePath",
                    'location'=>'/component/appbanners/icon/bannermanager.jpg'
                )
            );

            return $send;
        }
    }

    public function register_informationset_defination()
    {
        $srcpaths = Array();
        $srcpaths[] = array(
            'type'=>'app-banner',
            'path'=>$this->attachMyPath('information_set/app-banner.xml')
        );
        return $srcpaths;
    }
}