<?php
/**
 * appRain CMF
 *
 * LICENSE
 *
 * This source file is subject to the MIT license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.opensource.org/licenses/mit-license.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@apprain.com so we can send you a copy immediately.
 *
 * @copyright  Copyright (c) 2010 appRain, Team. (http://www.apprain.com)
 * @license    http://www.opensource.org/licenses/mit-license.php MIT license
 *
 * HELP
 *
 * Official Website
 * http://www.apprain.com/
 *
 * Download Link
 * http://www.apprain.com/download
 *
 * Documents Link
 * http ://www.apprain.com/docs
 */

class myController extends appRain_Base_Core
{
    public $name = 'my';
    
    /**
     * Function Call before Page action method each time
     */
    public function __preDispatch()
    {
    }

    /**
     * Function Call before Page action method each time
     */
    public function __postDispatch()
    {
    }

    /**
     * To render usert index page
     */
    public function indexAction($name='Page1')
    {
		$pageData = App::PageManager()->getData($name);
		$this->set('pageData',$pageData);
    }

    /*
     * Start user website from here
     */
    public function siteAction(  $id = NULL)
    {
        $member_arr = $this->get_member_information($id);

        if( !empty( $member_arr ))
        {
            $this->redirect("/profile-user-information");
            exit;
        }
        else
        {
            $this->user = 0;
            pre(" Not a valide user. " . App::Load("Helper/Html")->linkTag($this->baseurl("/"),$this->get_config("site_title")));
        }
    }

    /**
     * Example function
     * Profile user information
     *
     * @return null
     */
    public function profile_user_informationAction()
    {
        // Check user login
        $this->check_user_login();

        // Sate page title
        $user_informaton = App::MemberManager()->thisMember();
        $this->page_title="{$user_informaton['name_title']} {$user_informaton['f_name']} {$user_informaton['l_name']}";


        // Fetch data saved by current user.
        $my_pages = App::PageManager()->getData();
        $this->set("section_title","{$user_informaton['name_title']} {$user_informaton['f_name']} {$user_informaton['l_name']}'s Page");
        $this->set("selected","profile");
        $this->set( "my_pages", $my_pages);
    }


    /**
     * A odinary member profile example
     * From this block you can see how to fetch data from member table
     *
     * @parameter id integer
     * @return null
     */
     public function app_user_profileAction()
     {

        // We can define any function like this in appcommon.php that we need to accessfrom
        // any controller or other section
        // Check login access
        $appuser = $this->checkAppUserLogin();

        // Read member information
        $member_info = App::Model('Member')->findById($appuser['id']);
        $this->page_title="{$member_info['name_title']} {$member_info['f_name']} {$member_info['l_name']}";

        // Set member information in template
        $this->set("member_info",$member_info);
        $this->set("selected","profile");
        $this->set("section_title","User Profile");
     }
}