<?php
/**
 * appRain CMF
 *
 * LICENSE
 *
 * This source file is subject to the MIT license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.opensource.org/licenses/mit-license.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@apprain.com so we can send you a copy immediately.
 *
 * @copyright  Copyright (c) 2010 appRain, Inc. (http://www.apprain.com)
 * @license    http://www.opensource.org/licenses/mit-license.php MIT license
 *
 * HELP
 *
 * Official Website
 * http://www.apprain.com/
 *
 * Download Link
 * http://www.apprain.com/download
 *
 * Documents Link
 * http ://www.apprain.com/documents
 */
class videopodcastController extends appRain_Base_Core
{
    public $name = 'Videopodcast';

    public function __preDispatch()
	{
		$this->page_title = 'Viewo Postcast';
	}

    public function indexAction($id=null)
    {
		if(isset($id)){
            $data = App::InformationSet('videopodcast')->setPagination('Yes')->findById($id);
			$this->page_title = $data['title'];
        }
		else{
            $data = App::InformationSet('videopodcast')
                ->setPagination('yes')
                ->setLimit(10)
                ->findAll(
                    '1 ORDER By id DESC',
                    array(
                        array(
                            'status'=>'Active'
                        )
                    )
                );
        }
		$this->set('id',$id);
		$this->set('data',$data);

		$this->set('section_title','Video Podcasting');
    }

    public function searchvideoAction($q=null)
    {
		$this->setAdmintab('component');
		$data = Array();
		if(isset($q)){
			$data = App::Component('Videopodcast')
                ->Helper('Youtube')
                ->set('q',$q)
                ->set('start-index','1')
                ->set('max-results','25')
                ->parse();
			$this->set('data',$data);
		}
		$this->set('section_title','Search video');
    }

	public function addtoListAction()
	{
		$this->setAdmintab('component');
		$data = unserialize(base64_decode($this->data['video']['data']));

		if(!empty($data)){
            $pdata = App::InformationSet('videopodcast')->findByTitle($data['title']);
            if(empty($pdata)){
                App::InformationSet('videopodcast')
                    ->setTitle($data['title'])
                    ->setDescription($data['description'])
                    ->setThumburl($data['thumbnail'])
                    ->setStatus('Active')
                    ->setVideocode($data['embaded'])
                    ->Save();
                echo('Video Added successfully');
            }
            else{
                echo("Video already exists with title '{$data['title']}'");
            }   
    	}
		exit;
	}
}
