<?php
/**
 * appRain CMF
 *
 * LICENSE
 *
 * This source file is subject to the MIT license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.opensource.org/licenses/mit-license.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@apprain.com so we can send you a copy immediately.
 *
 * @copyright  Copyright (c) 2010 appRain, Team. (http://www.apprain.com)
 * @license    http://www.opensource.org/licenses/mit-license.php MIT license
 *
 * HELP
 *
 * Official Website
 * http://www.apprain.com/
 *
 * Download Link
 * http://www.apprain.com/download
 *
 * Documents Link
 * http ://www.apprain.com/docs
 */

 /**
  * Component Name: Contact us
  * Auther: Reazaul Karim
  * Email: info@apprain.com
  */
class Component_Menusort_Register extends appRain_Base_Component
{
    public function init()
    {   
         App::Module('Hook')
            ->setHookName('Sitemenu')
            ->setAction("register_sitemenu")
            ->Register(get_class($this),"register_sitemenu");

         // Create admin menu
         App::Module('Hook')
            ->setHookName('InterfaceBuilder')
            ->setAction("update_definition")
            ->Register(get_class($this),"interfacebuilder_update_definition");

         App::Module('Hook')
            ->setHookName('Controller')
           ->setAction("register_controller")
           ->Register(get_class($this),"register_controller");

         App::Module('Hook')
            ->setHookName('Sitemenu')
           ->setAction("update_sitemenu")
           ->Register(get_class($this),"update_sitemenu");

    }

    public function init_on_install()
    {
    }

    public function init_on_uninstall()
    {
    }

    public function register_sitemenu($menu=null)
    {
        $menusortstaticlink = App::Component('Menusort')->Helper('Data')->getStaticlinks();
        foreach($menusortstaticlink as $row){
            $menu[] = array(App::Helper('Utility')->codeFormated($row['url']),$row['title'],$row['name']);
        }
        return $menu;
    }

    public function update_sitemenu($links=null)
    {

        $menusortsequence = App::Config()->siteInfo('menusortsequence',false);

        try{
            if(empty($menusortsequence)) { throw new AppException(); }
            
            $menus = preg_split('[\[|\]]',$menusortsequence);
            if(count($menus)!=5) { throw new AppException();  }
        
            $begain_seq = explode('|',$menus[1]);
            $end_seq = explode('|',$menus[3]);

            $a = array();
            $b = array();
            foreach($links as $key=>$link) {
                if(in_array($link[2],$begain_seq)){
                    $index = array_search($link[2],$begain_seq);
                    $a[$index] = $link;
                    unset($links[$key]);
                }
                if(in_array($link[2],$end_seq)){
                    $index = array_search($link[2],$end_seq);
                    $b[$index] = $link;
                    unset($links[$key]);
                }
            }
            ksort($a);
            ksort($b);
            $menu = array_merge($a,$links,$b);
            App::Module('Cache')->path = BYTE_STREAM;
            if(!App::Module('Cache')->exists('__menusortdate')){
                
                App::Module('Cache')->Write('__menusortdate',$menu);
            }

            return  App::Module('Cache')->Read('__menusortdate');
        }    
        catch(AppException $e){
            return $links;
        }
    }

    public function interfacebuilder_update_definition($send)
    {
        if(isset($send['component']['child']))
        {
            $send['component']['child'][] = Array(
                "title" => "Menu Sort",
                "items" => Array(
                    Array(
                        "title"=>"Sort Menu",
                        "link"=>"/menusort/"
                    ),
                    Array(
                        "title"=>"Manage Static Menu",
                        "link"=>"/menusort/manage"
                    )
                )
            );

            return $send;
        }
    }

    public function register_controller()
    {
        $srcpaths = Array();
        $srcpaths[] =   array(
            'name'=>'Menusort',
            'controller_path'=>$this->attachMyPath('controllers')
        );
        return $srcpaths;
    }
}