<?php
/**
 * appRain CMF
 *
 * LICENSE
 *
 * This source file is subject to the MIT license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.opensource.org/licenses/mit-license.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@apprain.com so we can send you a copy immediately.
 *
 * @copyright  Copyright (c) 2010 appRain, Inc. (http://www.apprain.com)
 * @license    http://www.opensource.org/licenses/mit-license.php MIT license
 *
 * HELP
 *
 * Official Website
 * http://www.apprain.com/
 *
 * Download Link
 * http://www.apprain.com/download
 *
 * Documents Link
 * http ://www.apprain.com/documents
 */

 /**
  *  Component Name: Contact us
  *  Auther : Reazaul Karim
  *  E-mail: info@apprain.com
  */
class menusortController extends appRain_Base_Core
{
	/**
	 * Controller Name
	 */
    public $name = 'Menusort';

    /**
     * Execute before the action
     */
    public function __preDispatch(){}

    /**
	 * Execute to response the ajax call
	 */
    public function indexAction($action=null)
    {
        $this->setAdminTab('component');

        if($action == 'clear'){
            App::Config()->setSiteInfo('menusortsequence',"");
            $this->redirect("/menusort");
            exit;
        }
        
        if(!empty($this->data)){

            $this->layout = 'empty';

            try{
                if($this->data['Menu']['item'] ==''){
                    throw new AppException("Please enter menu sequence.");
                }
                else {
                
                    $data = preg_split('[\;|\|]',$this->data['Menu']['item']);

                    $a = "";  $b = "";
                    for($i=0;$i<count($data); $i=$i+2) {
                        if($data[$i] == 'leftside'){
                            $a[] = $data[$i+1];
                        }

                        if($data[$i] == 'rightside'){
                            $b[] = $data[$i+1];
                        }
                    }
                    $stra = '';
                    if(!empty($a)){
                        $stra = ( implode('|',$a));
                    }
                    $strb = '';
                    if(!empty($b)){
                        $strb = ( implode('|',$b));
                    }
                    App::Config()->setSiteInfo('menusortsequence',"[{$stra}]**[{$strb}]");

                    App::Module('Cache')->path = BYTE_STREAM;
                    App::Module('Cache')->Delete('__menusortdate');
                    
                    $status ='Success';
                    throw new AppException("Saved successfully");
                }
            }
            catch(AppException $e){
                echo App::Load("Module/Cryptography")
                    ->jsonEncode(
                        array(
                            "_status" =>(isset($status) ? $status : 'Error'),
                            "_message"=>$e->getMessage()
                        )
                    );
            }
        }

        $menuSequence = App::Config()->SiteInfo('menusortsequence',false);
        $tmp = array();
        $begain_seq = array();
        $end_seq = array();
        if($menuSequence != ''){
            $tmp =  preg_split('[\[|\]]',$menuSequence);
            $begain_seq = explode('|',$tmp[1]);
            $end_seq = explode('|',$tmp[3]);
        }

        $menuArr = $this->siteMenuClear()->siteMenuRender('ARRAY');
        $a = array();
        $b = array();
        foreach($menuArr as $key=>$link) {
            if(in_array($link[2],$begain_seq)){
                $index = array_search($link[2],$begain_seq);
                $a[$index] = $link;
                unset($menuArr[$key]);
            }
            if(in_array($link[2],$end_seq)){
                $index = array_search($link[2],$end_seq);
                $b[$index] = $link;
                unset($menuArr[$key]);
            }
        }
        ksort($a);
        ksort($b);
        $this->set('a',$a);
        $this->set('b',$b);
        $this->set('menuArr',$menuArr);
    }

    public function manageAction($action=null,$name=null)
    {
        $this->setAdminTab('component');
        
        if($action == 'remove'){
            $menusortstaticlink = App::Component('Menusort')->Helper('Data')->getStaticlinks();
            $tmp=array();
            foreach($menusortstaticlink as $row){
                if($row['name'] != $name){
                    $tmp[] = $row;
                }
            }
            App::Config()->setSiteInfo('menusortstaticlink',serialize($tmp));
            App::Component('Menusort')->Helper('Data')->clearCache();
            $this->redirect('/menusort/manage');
            exit;
        }

        if(!empty($this->data)){
            $this->layout = 'empty';
            try{
                if($this->data['Menu']['title'] =='' or 
                    $this->data['Menu']['name'] =='' or 
                    $this->data['Menu']['url'] ==''){
                    throw new AppException($this->__('error'));
                }

                $menusortstaticlink = App::Component('Menusort')->Helper('Data')->getStaticlinks();
                $menusortstaticlink[] = $this->data['Menu'];
                App::Config()->setSiteInfo('menusortstaticlink',serialize($menusortstaticlink));
                App::Component('Menusort')->Helper('Data')->clearCache();
                throw new AppException($this->__('success'));
            }
            catch(AppException $e)
            {
                $this->redirect('/menusort/manage');
                exit;
            }
        }
        $menuArr = $this->siteMenuClear()->siteMenuRender('ARRAY');
        $this->set('menuArr',$menuArr);
    }
}
