<?php
/**
 * appRain CMF
 *
 * LICENSE
 *
 * This source file is subject to the MIT license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.opensource.org/licenses/mit-license.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@apprain.com so we can send you a copy immediately.
 *
 * @copyright  Copyright (c) 2010 appRain, Team. (http://www.apprain.com)
 * @license    http://www.opensource.org/licenses/mit-license.php MIT license
 *
 * HELP
 *
 * Official Website
 * http://www.apprain.com/
 *
 * Download Link
 * http://www.apprain.com/download
 *
 * Documents Link
 * http ://www.apprain.com/docs
 */
class  appRain_Base_Modules_MemberManager extends appRain_Base_Objects
{
    const STATUS_ACTIVE = 'Active';
    /**
     * Prepare Member Manage Module
     *
     * @param $options MIS
     * @return appRain_Base_Modules_MemberManager
     */
    public function memberManager()
    {
        $this->setFetchtype('membermanager');
        return $this;
    }
    
    /**
     * Retrun Member Information
     *
     * @param id Integer
     * @param select String
     * @return Mix
     */
    public function Members( $id = NULL, $select = NULL)
    {
        if( isset( $id ))
        {
            $tmp_arr = App::Load("Model/Member")->find("id=$id");
            if( $select ){
                if(!empty($tmp_arr)){
                    switch( strtolower($select)){
						case "name" :
							return  $tmp_arr['f_name'] . ' ' . $tmp_arr['l_name'];
							break;
						default:
							return $tmp_arr[$select];
							break;
                    }
                }
                else{
                    return "";
                }
            }
            else{
                return $tmp_arr;
            }
        }
        else{
            return App::Load("Model/Member")->findAll();
        }
    }


    /**
     * Retrun Cuttenty Logged In Member Information
     *
     * @param select String
     * @return Mix
     */
    public function thisMember($select = NULL)
    {
           $this_user_id = $this->loggedInId();
           $this_user_id = ($this_user_id) ? $this_user_id : $this->AppUserloggedInId();
           if ( $this_user_id > 0){
                return isset($select) ? $this->memberInformation($this_user_id,$select) :$this->memberInformation($this_user_id);
           }
           else{
           return isset($select) ? "" : Array();
           }
    }

    public function loggedInId()
    {
        App::setUserStatusId('RESET');
        $userSession =  App::Module("Session")->read('User');
        return isset($userSession['id']) ? $userSession['id'] : App::SUPPERADMINLOGINID;
    }

    public function AppUserloggedInId()
    {
        $userSession =  App::Module("Session")->read('AppUser');

        return isset($userSession['id']) ? $userSession['id'] : App::SUPPERADMINLOGINID;
    }

    /**
     * Return Member Information
     *
     * @param $this_user_id Integer
     * @param $select String
     * @return Mix
     */
    public function memberInformation($this_user_id = NULL,$select = NULL)
    {
        $_data = App::Load("Model/Member")->findById($this_user_id);

        if(empty($_data)){
            return isset($select) ? "" : Array();
        }
        else{
            return isset($_data[$select]) ? $_data[$select] : $_data;
        }
    }

    /**
     * An example function
     * Check is app user logged in
     *
     * @reture boolean
     */
    public function isAppUserLoggedin()
    {
       // Read session
       $appuser =  app::load("Module/Session")->read('AppUser');

        // Return nflag
        return empty($appuser) ? false : true;
    }

    public function isProfileUserLoggedin()
    {
        // Read session
        $profileuser =  app::load("Module/Session")->read('User');
        $profileuser['id'] = isset($profileuser['id']) ? $profileuser['id'] : 0;
        // Return nflag
        return ($profileuser['id'] > 0) ? true : false;
    }


    /**
     * An example function
     * Check app user login access
     *
     * @return null
     */
    public function checkAppUserLogin()
    {
       if(!$this->isAppUserLoggedin()){
           App::Helper('Config')->redirect("/member-login");
           exit;
       }
       else{
          return App::load("Module/Session")->read('AppUser');
       }
    }

    public function checkProfileUserLogin()
    {
       if(!$this->isProfileUserLoggedin()){
           App::Helper('Config')->redirect("/");
           exit;
       }

    }

    public function verifyRegistrationByResetkey($resetid=null)
    {
        $resetid = base64_decode($resetid);
        $memberInfo = App::Model('Member')->findByResetid($resetid);

        if(!empty($memberInfo)){
            $obj = App::Model('Member')
				->setId($memberInfo['id'])
				->setStatus(self::STATUS_ACTIVE)
				->setResetid('')
				->Save();

            App::Helper('Config')
				->transfer(
					App::Helper('Config')->baseurl('/member/login'),
					"Activation Completed..."
				);

        }
        else{
            App::Helper('Config')
				->transfer(
					App::Helper('Config')->baseurl('/')
					,"Link Expired!"
				);
        }
    }
}