<?php
include('config.inc.php');
function xml2array($xml) { //XMLת
	$return = array();
	preg_match_all('|<game_id>(.*?)<\/game_id>|is', $xml, $match);
	foreach($match[1] as $key => $value) {
		$return[$key]['game_id'] = $value;
	}
	preg_match_all('|<shortcut_target>(.*?)<\/shortcut_target>|is', $xml, $match);
	foreach($match[1] as $key => $value) {
		$return[$key]['shortcut_target'] = $value;
	}
	preg_match_all('|<run><\!\[CDATA\[(.*?)\]\]><\/run>|is', $xml, $match);
	foreach($match[1] as $key => $value) {
		$return[$key]['run'] = str_replace('"', '\'', $value);
	}
	preg_match_all('|<game_name><\!\[CDATA\[(.*?)\]\]><\/game_name>|is', $xml, $match);
	foreach($match[1] as $key => $value) {
		$return[$key]['game_name'] = $value;
	}
	preg_match_all('|<tag>(.*?)<\/tag>|is', $xml, $match);
	foreach($match[1] as $key => $value) {
		$return[$key]['tag'] = $value;
	}	
	preg_match_all('|<category_id>(.*?)<\/category_id>|is', $xml, $match);
	foreach($match[1] as $key => $value) {
		$return[$key]['category_id'] = $value;
	}
	preg_match_all('|<category_name>(.*?)<\/category_name>|is', $xml, $match);
	foreach($match[1] as $key => $value) {
		$return[$key]['category_name'] = $value;
	}
	preg_match_all('|<creat_time>(.*?)<\/creat_time>|is', $xml, $match);
	foreach($match[1] as $key => $value) {
		$value = substr($value, 0, -2);
		$value = str_replace('-', ' ', $value);
		$value = str_replace(':', ' ', $value);
		list($y, $m, $d, $h, $i, $s) = explode(' ', $value);
		$time = mktime($h, $i, $s, $m, $d, $y);
		$return[$key]['creat_time'] = $time;
	}
	preg_match_all('|<description><\!\[CDATA\[(.*?)\]\]><\/description>|is', $xml, $match);
	foreach($match[1] as $key => $value) {
		$return[$key]['description'] = $value;
	}
	preg_match_all('|<operation><\!\[CDATA\[(.*?)\]\]><\/operation>|is', $xml, $match);
	foreach($match[1] as $key => $value) {
		$return[$key]['operation'] = $value;
	}
	preg_match_all('|<image>(.*?)<\/image>|is', $xml, $match);
	foreach($match[1] as $key => $value) {
		$return[$key]['image'] = $value;
	}
	preg_match_all('|<language>(.*?)<\/language>|is', $xml, $match);
	foreach($match[1] as $key => $value) {
		$return[$key]['language'] = $value;
	}
	preg_match_all('|<company>(.*?)<\/company>|is', $xml, $match);
	foreach($match[1] as $key => $value) {
		$return[$key]['company'] = $value;
	}
	preg_match_all('|<helplink>(.*?)<\/helplink>|is', $xml, $match);
	foreach($match[1] as $key => $value) {
		$return[$key]['helplink'] = $value;
	}
	preg_match_all('|<avg_score>(.*?)<\/avg_score>|is', $xml, $match);
	foreach($match[1] as $key => $value) {
		$return[$key]['avg_score'] = $value;
	}
	preg_match_all('|<package_size>(.*?)<\/package_size>|is', $xml, $match);
	foreach($match[1] as $key => $value) {
		$return[$key]['package_size'] = $value;
	}
	return $return;
}

function parsedata($array) { //ݣKKSiteitemʽ
	global $thetime;
	$return = array();
	$item = array();
	$item['title'] = $array['game_name'];
	$item['keywords'] = str_replace(' ', ',', $array['tag']);
	$item['category'] = $array['category_id'];
	$item['aimurl'] = $array['run'];
	$pictures = explode(',', $array['image']);
	$thumb = 'http://'.str_replace('/loading.jpg', '/s_loading.jpg', array_shift($pictures));
	$item['picture'] = $thumb;
	$item['dateline'] = $array['creat_time'];
	$item['source'] = $array['game_id'];
	if(!empty($pictures)) $item['attach'] = 1;
	$item['avgscore'] = round($array['avg_score']);
	$item['orderby2'] = round($array['avg_score']);
	$return['item'] = $item;
	$return['attachments'] = array();
	foreach($pictures as $picture) {
		$attach['category'] = $item['category'];
		$attach['filename'] = 'http://'.preg_replace('/\/([0-9a-zA-Z_]*?).jpg/is', '/k_470_\\1.jpg', $picture);
		$attach['thumb'] = 'http://'.str_replace('-', '', $picture);
		$attach['dateline'] = $thetime;
		$return['attachments'][] = $attach;
	}
	$text = $array['description'];
	$return['text'] = $text;
	$ext = array();
	$ext['_language'] = $array['language'];
	$ext['_operation'] = $array['operation'];
	$ext['_company'] = $array['company'];
	$ext['_helplink'] = $array['helplink'];
	$ext['_package_size'] = number_format($array['package_size'] / 1024 / 1024, 2, '.', '');
	$return['ext'] = $ext;
	return $return;
}

function insertdata($data) { //
	global $db;
	if($data['item']['category'] <= 0) return false;
	if($db->get_by('id', 'items', "source='{$data['item']['source']}'")) return false;
	$data['item']['ext'] = 1;
	$db->insert('items', $data['item']);
	$id = $db->insert_id();
	foreach($data['attachments'] as $attach) {
		$attach['itemid'] = $id;
		$db->insert('attachments', $attach);
	}
	$db->insert('texts', array('itemid' => $id, 'text' => $data['text']));
	$ext = serialize($data['ext']);
	$db->insert('item_exts', array('id' => $id, 'value' => $ext));
}

function updatedata($data) { //
	global $db;
	if($data['item']['category'] <= 0) return false;
	if($db->get_by('id', 'items', "source='{$data['item']['source']}'")) {
		$data['item']['ext'] = 1;
		$id = $db->get_by('id', 'items', "source='{$data['item']['source']}'");
		$db->update('items', $data['item'] , "id='$id'");
		$attNum = count($data['attachments']);
		$i = 1;
		$attachid = $db->get_by('id', 'attachments', "itemid='$id'");
		//echo $id."<br/>".$attachid."<br/>".$attNum."<br/>";
		if ($i<=$attNum) {
			foreach($data['attachments'] as $attach) {
				$db->update('attachments', $attach , "id='$attachid'");
				$attachid ++;
				$i++;
			}
		}
		$db->update('texts', array('itemid' => $id, 'text' => $data['text']) , "itemid='$id'");
		$ext = serialize($data['ext']);
		$db->update('item_exts', array('id' => $id, 'value' => $ext) , "id='$id'");
	}
}

function ping(){
	global $dbname, $dbhost, $dbuser, $dbpw, $charset;
	$config['type'] = 'mysql';
	$config['dbname'] = $dbname;
	$config['dbhost'] = $dbhost;
	$config['dbuser'] = $dbuser;
	$config['dbpw'] = $dbpw;
	$config['charset'] = $charset;
	if(mysql_ping(@mysql_pconnect($config['dbhost'], $config['dbuser'], $config['dbpw']))){
	}elseif(mysql_ping(@mysql_connect($config['dbhost'], $config['dbuser'], $config['dbpw']))){
	}else{
		//echo "ݿʧ"
		global $db;
		$db->close();
		require_once(AK_ROOT.'include/db.mysql.php');
		$db = new mysqlstuff($config);
	}
}
?>