<?php
function addwatermark($source, $sourcesize) {
	global $setting_attachwatermarkposition;
	if(file_exists(AK_ROOT.'configs/images/watermark.png')) {
		$watermarkfile = AK_ROOT.'configs/images/watermark.png';
	} elseif(file_exists(AK_ROOT.'configs/images/watermark.gif')) {
		$watermarkfile = AK_ROOT.'configs/images/watermark.gif';
	} else {
		return $source;
	}
	$position = $setting_attachwatermarkposition;
	$position == 0 && $position = rand(1, 9);
	$watermarkinfo = getimagesize($watermarkfile);
	list($s_w, $s_h) = $sourcesize;
	list($w_w, $w_h) = $watermarkinfo;
	if($w_w > $s_w || $w_h > $s_h) return $source;
	switch($position) {
		case 1:
			$x = +5;
			$y = +5;
			break;
		case 2:
			$x = ($s_w - $w_w) / 2;
			$y = +5;
			break;
		case 3:
			$x = $s_w - $w_w - 5;
			$y = +5;
			break;
		case 4:
			$x = +5;
			$y = ($s_h - $w_h) / 2;
			break;
		case 5:
			$x = ($s_w - $w_w) / 2;
			$y = ($s_h - $w_h) / 2;
			break;
		case 6:
			$x = $s_w - $w_w - 5;
			$y = ($s_h - $w_h) / 2;
			break;
		case 7:
			$x = +5;
			$y = $s_h - $w_h - 5;
			break;
		case 8:
			$x = ($s_w - $w_w) / 2;
			$y = $s_h - $w_h - 5;
			break;
		case 9:
			$x = $s_w - $w_w - 5;
			$y = $s_h - $w_h - 5;
			break;
	}
	if(substr($watermarkfile, -4) == '.png') {
		$watermark = imageCreateFrompng($watermarkfile);
	} else {
		$watermark = imageCreateFromGIF($watermarkfile);
	}
	imagecopy($source, $watermark, $x, $y, 0, 0, $w_w, $w_h);
	return $source;
}

function corecaptcha($captcha) {
	$width = 38;
	$height = 15;
	$im = imagecreate($width, $height);

	$bg = imagecolorallocate($im, 255, 255, 255);
	$textcolor = imagecolorallocate($im, 0, 0, 255);
	for($i = 0; $i < $width; $i ++) {
		for($j = 0; $j < $height; $j ++) {
			$bgcrumb = imagecolorallocate($im, rand(200,255), rand(200,255), rand(200,255));
			if(empty($bgcrumb) || $bgcrumb == -1) $bgcrumb = rand(2, 255);
			imagefilledrectangle($im, $i, $j, $i + 1, $j + 1, $bgcrumb);
		}
	}
	imagestring($im, 5, 2, 0, $captcha, $textcolor);
	header("Content-type: image/png");
	imagepng($im);
}

function corecreatethumb($source, $target, $size) {
	if(strpos($size, ',') === false) return false;
	list($tw, $th) = explode(',', $size);
	if(!a_is_int($tw) || !a_is_int($th)) return false;
	$sourcesize = getimagesize($source);
	if($sourcesize == false) return false;
	list($sw, $sh) = $sourcesize;
	$ssh = min($sh, $sw * $th / $tw);
	$ssw = $ssh * $tw / $th;
	$x = ($sw - $ssw) / 2;
	$y = ($sh - $ssh) / 2;
	$sourceimg = imagecreatefromfile($source, $sourcesize);
	$targetimg = imagecreatetruecolor($tw, $th);
	imagecopyresampled($targetimg, $sourceimg, 0, 0, $x, $y, $tw, $th, $ssw, $ssh);
	ak_mkdir(dirname($target));
	imagejpeg($targetimg, $target, 100);
}

function reducepicture($sourceimg, $sourcesize, $size) {
	list($sw, $sh) = $sourcesize;
	if($size >= $sw) return $sourceimg;
	$tw = $size;
	$th = floor($tw * $sh / $sw);
	$targetimg = imagecreatetruecolor($tw, $th);
	imagecopyresampled($targetimg, $sourceimg, 0, 0, 0, 0, $tw, $th, $sw, $sh);
	return $targetimg;
}

function operateuploadpicture($source, $module) {
	global $setting_attachimagequality, $setting_attachwatermarkposition;
	if(!file_exists($source)) return false;
	$sourcesize = getimagesize($source);
	if($sourcesize['mime'] == 'image/gif') {
		$fp = fopen($source, 'r');
		$head = fread($fp, 11);
		fclose($fp);
		if($head == 'NETSCAPE2.0') return false;
		unset($head);
	}
	list($sw, $sh) = $sourcesize;
	if(!empty($module['data']['picturemaxsize']) && $module['data']['picturemaxsize'] < $sw) {
		$sourceimg = imagecreatefromfile($source, $sourcesize);
		$sourceimg = reducepicture($sourceimg, $sourcesize, $module['data']['picturemaxsize']);
		$tw = $module['data']['picturemaxsize'];
		$th = floor($tw * $sh / $sw);
		$sourcesize[0] = $tw;
		$sourcesize[1] = $th;
	}
	if($setting_attachwatermarkposition != -1) {
		if(!isset($sourceimg)) $sourceimg = imagecreatefromfile($source, $sourcesize);
		$sourceimg = addwatermark($sourceimg, $sourcesize);
	}
	imagejpeg($sourceimg, $source, $setting_attachimagequality);
}

function setimagequality($source, $quality) {
	$sourceimg = imagecreatefromfile($source);
	imagejpeg($sourceimg, $source, $quality);
}

function imagecreatefromfile($sourcefile, $sourceinfo = array()) {
	if(empty($sourceinfo)) $sourceinfo = getimagesize($sourcefile);
	switch($sourceinfo['mime']) {
		case 'image/jpeg':
			$source = imageCreateFromJPEG($sourcefile);
			break;
		case 'image/gif':
			$gifdata = readfromfile($sourcefile);
			if(strpos($gifdata, 'NETSCAPE2.0') !== false) return false;
			$source = imageCreateFromGIF($sourcefile);
			break;
		case 'image/png':
			$source = imageCreateFromPNG($sourcefile);
			break;
		default:
			return false;
	}
	return $source;
}
?>