
#
# Ľṹ `dts_action_list`
#

CREATE TABLE IF NOT EXISTS dts_action_list (
  actionlistID int(30) unsigned NOT NULL auto_increment,
  administratorsID int(30) unsigned NOT NULL default '0',
  actionID varchar(255) binary NOT NULL default '',
  PRIMARY KEY  (actionlistID),
  KEY administratorID (administratorsID)
) TYPE=MyISAM;

#
# Ľṹ `dts_administrators`
#

CREATE TABLE IF NOT EXISTS dts_administrators (
  administratorsID int(30) unsigned NOT NULL auto_increment,
  userGroupID int(6) unsigned NOT NULL default '0',
  administratorsName varchar(100) NOT NULL default '',
  nickName varchar(40) NOT NULL default '',
  email varchar(50) binary NOT NULL default '',
  passWord varchar(32) NOT NULL default '',
  ipAddress varchar(15) NOT NULL default '',
  isAdmin int(1) unsigned NOT NULL default '0',
  isInit int(1) unsigned NOT NULL default '0',
  isActive int(1) unsigned NOT NULL default '1',
  lastVisitTime int(11) unsigned NOT NULL default '0',
  loginNum int(6) unsigned NOT NULL default '0',
  createDate int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (administratorsID),
  KEY isAdmin (isAdmin),
  KEY isActive (isActive),
  KEY userGroupID (userGroupID)
) TYPE=MyISAM;

#
# Ľṹ `dts_administratorslog`
#

CREATE TABLE IF NOT EXISTS dts_administratorslog (
  administratorsLogID int(50) unsigned NOT NULL auto_increment,
  administratorsID int(30) unsigned NOT NULL default '0',
  operationTitle varchar(255) NOT NULL default '',
  operationIP varchar(32) NOT NULL default '',
  createDate int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (administratorsLogID),
  KEY administratorsID (administratorsID)
) TYPE=MyISAM;

#
# Ľṹ `dts_administratorsloginlog`
#

CREATE TABLE IF NOT EXISTS dts_administratorsloginlog (
  administratorsLoginLogID int(4) unsigned NOT NULL auto_increment,
  administratorsName varchar(50) NOT NULL default '',
  passWord varchar(30) NOT NULL default '',
  loginTime int(11) unsigned NOT NULL default '0',
  ipAddress varchar(15) NOT NULL default '',
  isAdminLogin int(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (administratorsLoginLogID),
  KEY isAdminLogin (isAdminLogin)
) TYPE=MyISAM;

#
# Ľṹ `dts_base_setting`
#

CREATE TABLE IF NOT EXISTS dts_base_setting (
  baseSettingID int(1) unsigned NOT NULL auto_increment,
  sendFrom varchar(40) NOT NULL default '',
  sendName varchar(40) NOT NULL default '',
  mailServer varchar(40) NOT NULL default '',
  smtp25 varchar(10) NOT NULL default '25',
  smtpName varchar(40) NOT NULL default '',
  smtpPassword varchar(40) NOT NULL default '',
  isSmtp enum('y','n') NOT NULL default 'n',
  isAllowIP int(1) unsigned NOT NULL default '0',
  license varchar(100) NOT NULL default '',
  licensetime varchar(100) NOT NULL default '',
  PRIMARY KEY  (baseSettingID)
) TYPE=MyISAM;

#
# Ľṹ `dts_documents`
#

CREATE TABLE IF NOT EXISTS dts_documents (
  documentsID int(30) unsigned NOT NULL auto_increment,
  documentsTitle varchar(254) binary NOT NULL default '',
  documentsContent text default '' NOT NULL,
  documentsDate date NOT NULL default '0000-00-00',
  documentsNum varchar(200) binary NOT NULL default '',
  documentsUnit varchar(200) binary NOT NULL default '',
  docCateID int(6) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  joinTime int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (documentsID),
  KEY docCateID (docCateID),
  KEY administratorsID (administratorsID)
) TYPE=MyISAM;

#
# Ľṹ `dts_documents_cate`
#

CREATE TABLE IF NOT EXISTS dts_documents_cate (
  docCateID int(6) unsigned NOT NULL auto_increment,
  docCateName varchar(60) binary NOT NULL default '',
  PRIMARY KEY  (docCateID)
) TYPE=MyISAM;

#
# Ľṹ `dts_documents_file`
#

CREATE TABLE IF NOT EXISTS dts_documents_file (
  fileID int(30) unsigned NOT NULL auto_increment,
  documentsID int(30) unsigned NOT NULL default '0',
  documentsFile varchar(200) binary NOT NULL default '',
  PRIMARY KEY  (fileID),
  KEY documentsID (documentsID)
) TYPE=MyISAM;

#
# Ľṹ `dts_documents_users`
#

CREATE TABLE IF NOT EXISTS dts_documents_users (
  documentsID int(30) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  isRead int(1) unsigned NOT NULL default '0',
  readPerson varchar(60) binary NOT NULL default '',
  readTime int(11) unsigned NOT NULL default '0',
  readIp varchar(16) binary NOT NULL default '',
  KEY administratorsID (administratorsID),
  KEY isRead (isRead),
  KEY documentsID (documentsID)
) TYPE=MyISAM;

#
# Ľṹ `dts_downs`
#

CREATE TABLE IF NOT EXISTS dts_downs (
  downsID int(3) unsigned NOT NULL auto_increment,
  downsName varchar(100) NOT NULL default '',
  downsContent text default '' NOT NULL,
  filename varchar(100) NOT NULL default '',
  filesize decimal(10,2) NOT NULL default '0.00',
  isPublic enum('y','n') NOT NULL default 'y',
  createDate int(11) unsigned NOT NULL default '0',
  updateDate int(11) unsigned NOT NULL default '0',
  orderByID int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (downsID)
) TYPE=MyISAM;

INSERT INTO dts_downs VALUES (1, 'EnableDTSϵͳûֲ', 'EnableDTSĴϵͳοֲ᣺ϵͳûֲ', 'EnableDTSUserManual.html', '1.00', 'y', 1250052832, 1250052832, 1);
#
# Ľṹ `dts_files`
#

CREATE TABLE IF NOT EXISTS dts_files (
  filesID int(30) unsigned NOT NULL auto_increment,
  filesTitle varchar(254) binary NOT NULL default '',
  filesContent text default '' NOT NULL,
  filesUnit varchar(200) binary NOT NULL default '',
  fileCateID int(6) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  joinTime int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (filesID),
  KEY administratorsID (administratorsID),
  KEY fileCateID (fileCateID)
) TYPE=MyISAM;

#
# Ľṹ `dts_files_cate`
#

CREATE TABLE IF NOT EXISTS dts_files_cate (
  fileCateID int(6) unsigned NOT NULL auto_increment,
  fileCateName varchar(60) binary NOT NULL default '',
  PRIMARY KEY  (fileCateID)
) TYPE=MyISAM;

#
# Ľṹ `dts_files_file`
#

CREATE TABLE IF NOT EXISTS dts_files_file (
  fileID int(30) unsigned NOT NULL auto_increment,
  filesID int(30) unsigned NOT NULL default '0',
  filesFile varchar(200) binary NOT NULL default '',
  PRIMARY KEY  (fileID),
  KEY filesID (filesID)
) TYPE=MyISAM;

#
# Ľṹ `dts_files_users`
#

CREATE TABLE IF NOT EXISTS dts_files_users (
  filesID int(30) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  isRead int(1) unsigned NOT NULL default '0',
  readPerson varchar(60) binary NOT NULL default '',
  readTime int(11) unsigned NOT NULL default '0',
  readIp varchar(16) binary NOT NULL default '',
  KEY administratorsID (administratorsID),
  KEY isRead (isRead),
  KEY filesID (filesID)
) TYPE=MyISAM;

#
# Ľṹ `dts_ip_allow`
#

CREATE TABLE IF NOT EXISTS dts_ip_allow (
  allowIpID int(6) unsigned NOT NULL auto_increment,
  startIP varchar(15) NOT NULL default '',
  endIP varchar(15) NOT NULL default '',
  PRIMARY KEY  (allowIpID)
) TYPE=MyISAM;

#
# Ľṹ `dts_ip_banned`
#

CREATE TABLE IF NOT EXISTS dts_ip_banned (
  bannedID int(30) unsigned NOT NULL auto_increment,
  ipAddress varchar(15) NOT NULL default '',
  PRIMARY KEY  (bannedID)
) TYPE=MyISAM;

#
# Ľṹ `dts_meetings`
#

CREATE TABLE IF NOT EXISTS dts_meetings (
  meetingsID int(30) unsigned NOT NULL auto_increment,
  meetingsTitle varchar(254) binary NOT NULL default '',
  meetingsContent text default '' NOT NULL,
  meetingsDate datetime NOT NULL default '0000-00-00 00:00:00',
  meetingsPlace varchar(254) binary NOT NULL default '',
  meetingsObject varchar(254) binary NOT NULL default '',
  meetingsUnit varchar(200) binary NOT NULL default '',
  isRequire int(1) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  joinTime int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (meetingsID),
  KEY administratorsID (administratorsID),
  KEY isRequire (isRequire)
) TYPE=MyISAM;

#
# Ľṹ `dts_meetings_file`
#

CREATE TABLE IF NOT EXISTS dts_meetings_file (
  fileID int(30) unsigned NOT NULL auto_increment,
  meetingsID int(30) unsigned NOT NULL default '0',
  meetingsFile varchar(200) binary NOT NULL default '',
  PRIMARY KEY  (fileID),
  KEY meetingsID (meetingsID)
) TYPE=MyISAM;

#
# Ľṹ `dts_meetings_users`
#

CREATE TABLE IF NOT EXISTS dts_meetings_users (
  meetingsID int(30) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  isRead int(1) unsigned NOT NULL default '0',
  readPerson varchar(60) binary NOT NULL default '',
  readTime int(11) unsigned NOT NULL default '0',
  readIp varchar(16) binary NOT NULL default '',
  feedTime int(11) unsigned NOT NULL default '0',
  feedBack text default '' NOT NULL,
  KEY isRead (isRead),
  KEY meetingsID (meetingsID),
  KEY administratorsID (administratorsID)
) TYPE=MyISAM;

#
# Ľṹ `dts_notices`
#

CREATE TABLE IF NOT EXISTS dts_notices (
  noticesID int(30) unsigned NOT NULL auto_increment,
  noticesTitle varchar(254) binary NOT NULL default '',
  noticesContent text default '' NOT NULL,
  administratorsID int(30) unsigned NOT NULL default '0',
  joinTime date NOT NULL default '0000-00-00',
  PRIMARY KEY  (noticesID),
  KEY administratorsID (administratorsID)
) TYPE=MyISAM;

#
# Ľṹ `dts_tasks`
#

CREATE TABLE IF NOT EXISTS dts_tasks (
  tasksID int(30) unsigned NOT NULL auto_increment,
  tasksTitle varchar(254) binary NOT NULL default '',
  tasksContent text default '' NOT NULL,
  tasksUnit varchar(200) binary NOT NULL default '',
  administratorsID int(30) unsigned NOT NULL default '0',
  joinTime int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (tasksID)
) TYPE=MyISAM;

#
# Ľṹ `dts_tasks_file`
#

CREATE TABLE IF NOT EXISTS dts_tasks_file (
  fileID int(30) unsigned NOT NULL auto_increment,
  tasksID int(30) unsigned NOT NULL default '0',
  tasksFile varchar(200) binary NOT NULL default '',
  PRIMARY KEY  (fileID),
  KEY tasksID (tasksID)
) TYPE=MyISAM;

#
# Ľṹ `dts_tasks_uploads`
#

CREATE TABLE IF NOT EXISTS dts_tasks_uploads (
  uploadsID int(30) unsigned NOT NULL auto_increment,
  tasksID int(30) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  uploadsFile varchar(200) binary NOT NULL default '',
  PRIMARY KEY  (uploadsID),
  KEY tasksID (tasksID),
  KEY administratorsID (administratorsID)
) TYPE=MyISAM;

#
# Ľṹ `dts_tasks_users`
#

CREATE TABLE IF NOT EXISTS dts_tasks_users (
  tasksID int(30) unsigned NOT NULL default '0',
  administratorsID int(30) unsigned NOT NULL default '0',
  isRead int(1) unsigned NOT NULL default '0',
  readPerson varchar(60) binary NOT NULL default '',
  readTime int(11) unsigned NOT NULL default '0',
  readIp varchar(16) binary NOT NULL default '',
  uploadTime int(11) unsigned NOT NULL default '0',
  KEY isRead (isRead),
  KEY administratorsID (administratorsID),
  KEY tasksID (tasksID)
) TYPE=MyISAM;

#
# Ľṹ `dts_user_group`
#

CREATE TABLE IF NOT EXISTS dts_user_group (
  userGroupID int(6) unsigned NOT NULL auto_increment,
  userGroupName varchar(60) NOT NULL default '',
  PRIMARY KEY  (userGroupID)
) TYPE=MyISAM;


#
# V2.20汾
#

#
# Ľṹ `dts_notices_file`
#

CREATE TABLE IF NOT EXISTS dts_notices_file (
  fileID int(30) unsigned NOT NULL auto_increment,
  noticesID int(30) unsigned NOT NULL default '0',
  noticesFile varchar(200) binary NOT NULL default '',
  PRIMARY KEY  (fileID),
  KEY noticesFile (noticesFile)
) TYPE=MyISAM;

ALTER TABLE `dts_notices` CHANGE  `joinTime`  `joinTime` INT( 11 ) UNSIGNED DEFAULT  '0' NOT NULL;

    
