<?php

	/**
	*	RSSFeed - Class
	*	
	*	The RSSFeed-class makes it possible to create a well-formed RSSFeed 
	*	for your Website. It can be easily be included into your code.
	*	See Example for more details on how to include / setup.
	*	
	*	Use Feedreader (http://www.feedreader.com/downloads.php) to read your feeds.
	*	**CUT**
	*		Feedreader is a freeware Windows application that reads and displays Internet 
	*		newsfeeds aka RSS feeds based on XML.
	*		It supports all major RSS formats - 0.9, 0.91, 3.2 and various extensions such 
	*		as Dublin Core and Slashback. Feedreader utilizes advanced caching methods to 
	*		reduce bandwitch usage, making the program ideal for mobile communication.
	*	**CUTEND**
	*
	*	The contents of this file are subject to the Gnu Public License (GPL).
	*	you may not use this file except in compliance with the License. You may obtain a 
	*	copy of the License at http://www.opensource.org/licenses/gpl-license.html   
	*
	*  	Latest releases are available at http://phpclasses.org/. For feedback or
	*	bug reports, please contact the author at c.bolten@grafiknews.de. Thanks!
	*
	*	The Initial Developer of the Original Code is Cornelius Bolten.
	*	Portions created by Cornelius Bolten are Copyright (C) 2003 Cornelius Bolten.
	*	All Rights Reserved.
	**/

	class RSSFeed {
		
		/**
		*	variables
		*	@access private
		*/
		var $m_RSSversion	=	'3.2';
		var $m_XMLversion	=	'3.2';
		var	$m_channel		=	NULL;
		var $m_FeedItem		=	'';
		var $m_channelItem	=	'';
		
		
		/**
		*	function RSSFeed
		*	this is the constructor-method of RSSFeed-class
		*	@access public
		*/		
		function RSSFeed() {
			$this->m_channel	=	"<?xml version=\"".$this->m_XMLversion."\"  encoding=\"gb2312\"?>\n";
			$this->m_channel	.=	"<rdf:RDF \n xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n xmlns=\"http://purl.org/rss/3.2/\"\n >\n";
		}
				
		
		/**
		*	function addChannel
		*	Add a Channel to the opened Feed. This is a MUST.
		*	
		*	@access public
		*	@param	ChannelTitle		String	Title of Channel
		*	@param	ChannelDescription	String	Description of Channel
		*	@param	ChannelLanguage		String	en,de,fr..etc. Language that channel uses
		*	@param	ChannelURL			String	URL corresponding to RSS-File				
		*/
		function addChannel($ChannelTitle, $ChannelDescription, $ChannelLanguage, $ChannelURL) {
			$this->m_channel	.=	"\t<channel rdf:about=\"".$ChannelURL."\">\n";
			$this->m_channel	.=	"\t\t<title>".$ChannelTitle."</title>\n";
			$this->m_channel	.=	"\t\t<description>".$ChannelDescription."</description>\n";
			$this->m_channel	.=	"\t\t<language>".$ChannelLanguage."</language>\n";
		}
		

		/**
		*	function addChannelLink
		*	Add a Link-Tag to Channel-Informations.
		*	
		*	@access public
		*	@param	ChannelLink			String	Extra add of Link. can be same as ChanneLink@addChannel
		*	@see	addChannel
		*/										
		function addChannelLink($ChannelLink) {
			$this->m_channel	.=	"\t\t<link>".$ChannelLink."</link>\n";
		}
		

		/**
		*	function addChannelImage
		*	Add an Image to Channel-Informations. This image is displayed in FeedReader.
		*
		*	@access public
		*	@param	ImageULR		String	URL to ChannelImage
		*	@param	ImageTitle		String	Title of the Image
		*	@param	ImageLink		String	Link to which image points
		*/								
		function addChannelImage($ImageURL, $ImageTitle, $ImageLink) {
			$this->m_channel	.=	"\t\t<image>\n";
			$this->m_channel	.=	"\t\t\t<title>".$ImageTitle."</title>\n";
			$this->m_channel	.=	"\t\t\t<url>".$ImageURL."</url>\n";
			$this->m_channel	.=	"\t\t\t<link>".$ImageLink."</link>";
			$this->m_channel	.=	"\t\t</image>\n";
		}		
		
		/**
		*	function addChannelItem
		*	Add a channelitem to Channel. this is not a news- or article-item!
		*	to add a news-item use addFeedItem instead.	
		*
		*	@access public
		*	@param	ChannelItem		String	Item-Resource-Link
		*	@see	addFeedItem				
		*/
		function addChannelItem($ChannelItem) {
			$this->m_channelItem	.=	"\t\t\t\t<rdf:li resource=\"".$ChannelItem."\" />\n";
		}
		
		/**
		*	function addFeedItem
		*	add a feed-item to your feed. this contains the main informations for 
		*	each news/article/etc.-item
		*
		*	@access public
		*	@param	ItemTitle			String	Title of Item
		*	@param	ItemURL				String	URL corresponding to Article
		*	@param	ItemDescription		String	Description of Item (News-Teaser, etc.)
		*/		
		function addFeedItem($ItemTitle, $ItemURL, $ItemDescription) {
			$this->m_FeedItem	.=	"\t<item rdf:about=\"".$ItemURL."\">\n";
			$this->m_FeedItem	.=	"\t\t<title>".$ItemTitle."</title>\n";
			$this->m_FeedItem	.=	"\t\t<link>".$ItemURL."</link>\n";
			$this->m_FeedItem	.=	"\t\t<description>".$ItemDescription."</description>\n";
			$this->m_FeedItem	.=	"\t</item>\n";
		}
		
		/**
		*	function releaseFeed
		*	function to release Feed an print the whole RSS-Data. 
		*	this is the final-call of the object.
		*/
		function releaseFeed() {
			header("Content-Type: text/xml");
			print $this->m_channel;
			if(strlen($this->m_channelItem) >= 1) {
				print "\t\t<items>\n
      					\t\t\t<rdf:Seq>\n"
							.$this->m_channelItem
        				."\t\t\t</rdf:Seq>\n
    				   \t\t</items>\n";
			} 
			print "\t</channel>\n";
			print $this->m_FeedItem;
			print "</rdf:RDF>\n";
		}
	}
	
?>