<?php 
class DdTpl{
	
	var $tpl_dir = 'DdTpl/htmltpl';		//模板文件的存放目录
	var $com_dir = 'DdTpl/comdir';		//编译文件的存放目录
	var $left_limit = '<{';			//左定界符
	var $right_limit = '}>';		//右定界符
	var $tpl_vars = array();		//变量数组
	
	function assign($tpl_var,$value = null){
		if($tpl_var != ''){
			$this->tpl_vars[$tpl_var] = $value;
		}
	}
	function tpl_path($path,$com){
		if($path != ''){
			$this->tpl_dir = $path;
		}
		if($com != ''){
			$this->com_dir = $com;
		}
	
	}
	function display($fileName){
		$tplFile = $this->tpl_dir.'/'.$fileName;
		if(!is_file($tplFile)){
			die("系统找不到 $tplFile 模板文件！");
		}
		$comFile = $this->com_dir.'/com_'.$fileName.'.php';
		if(!is_file($comFile)||filemtime($comFile)<filemtime($tplFile)){
			/*调用内部方法替换模板*/
			$repContent = $this->tpl_replace(file_get_contents($tplFile));
			file_put_contents($comFile,$repContent);
			}
			/*包含处理后的文件*/
			include($comFile);
	}
	
	function tpl_replace($content){
		$left = preg_quote($this->left_limit,'/');
		$right = preg_quote($this->right_limit,'/');
		$pattstr = array(
		'/'.$left.'\s*\$([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)\s*'.$right.'/i',
		'/'.$left.'\s*if\s*(.+?)\s*'.$right.'(.+?)'.$left.'\s*\/if\s*'.$right.'/ies',
	    '/'.$left.'\s*else\s*if\s*(.+?)\s*'.$right.'/ies',
		'/'.$left.'\s*else\s*'.$right.'/is',
		'/'.$left.'\s*loop\s+\$(\S+)\s+\$([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)\s*'.$right.'(.+?)'.$left.'\s*\/loop\s*'.$right.'/is',
		'/'.$left.'\s*loop\s+\$(\S+)\s+\$([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)\s*=>\s*\$(\S+)\s*'.$right.'(.+?)'.$left.'\s*\/loop\s*'.$right.'/is',
		'/'.$left.'\s*include\s+[\"\']?(.+?)[\"\']?\s*'.$right.'/ie'
		);
		$repl = array(
		'<?php  echo $this->tpl_vars["${1}"] ;?>',
		'$this->stripvtags(\'<?php  if(${1}){?>\',\'${2}<?php  } ?>\')',
		'$this->stripvtags(\'<?php  }elseif(${1})?>\',"")',
		'<?php  }else{ ?>',
		'<?php  foreach($this->tpl_vars["${1}"] as $this->tpl_vars["${2}"]) {?>${3}<?php  } }?>',
		'<?php  foreach($this->tpl_vars["${1}"] as $this->tpl_vars["${2}"] = > $this->tpl_vars["${3}"]){?> ${4} <?php  } ?>',
		'file_get_contents($this->tpl_dir."/${1}")'
		);
		$repContent = preg_replace($pattstr,$repl,$content);
		if(preg_match('/'.$left.'([^('.$right.')]{1,})'.$right.'/',$repContent)){
			$repContent = $this->tpl_replace($repContent);
		}
		return $repContent;
	}
	function stripvtags($expr,$statement=''){
	/*匹配变量的正则*/
	$var_pattern = '/\s*\$([a-zA-Z_\x7f-\xff][a-zA-Z0-9_\x7f-\xff]*)\s*/is';
	/*把变量替换为指*/
	$expr = preg_replace($var_pattern,'$this->tpl_vars["${1}"]',$expr);
	/*将开始标记中的引号转义去掉*/
	$expr = str_replace("\\\"","\"",$expr);
	/*替换语句体和技术标记中的引号*/
	$statement = str_replace("\\\"","\"",$statement);
	/*将处理后的条件语句相连后返回*/
	return $expr.$statement;
	}
}	