<?php
!defined('P_W') && exit('Forbidden');

/**
 * @author zuojie
 *
 */
class PW_Exception {
	/**
	 * @var int 쳣룬쳣
	 * @access protected
	 */
	var $_code;
	/**
	 * @var string 쳣Ķ
	 * @access protected
	 */
	var $_message;
	/**
	 * @var Pw_Exception һ쳣
	 * @access protected
	 */
	var $_previous;
	/**
	 * @param string $message
	 * @param int $code
	 * @param Pw_Exception $previous
	 * @return Pw_Exception
	 */
	function PW_Exception ($message = "", $code = 0, $previous = null) {
		$this->_message = (string)$message;
		$this->_code = (int)$code;
		if (is_a($previous, 'Pw_Exception')) {
			$this->_previous = $previous;
		}
		return $this;
	}

	/**
	 * @return number
	 */
	function getCode() {
		return $this->_code;
	}
	
	/**
	 * @return string
	 */
	function getMessage() {
		return $this->_message;
	}
	
	/**
	 * @return Pw_Exception
	 */
	function getPrevious() {
		return $this->_previous;
	}
}