<?php
!defined('P_W') && exit('Forbidden');

define('THREAD_INVALID_PARAMS',301);
define('THREAD_USER_NOT_RIGHT',302);
define('THREAD_FORUM_NOT_EXIST',303);
define('THREAD_USER_NOT_EXIST',304);
define('THREAD_ID_NOT_ILLEGAL',305);
define('THREAD_EDIT_TIME_LIMIT',306);
define('THREAD_USER_NOT_HTML_RIGHT',307);
define('THREAD_SYSTEM_ERROR',308);

class ThreadApi extends BaseApi{
    var $methodsType = array(
    		'get'           => 'GET',
    		'getdigestthreads'=>'GET',
    		'getlatestthreads'=>'GET',
    		'getimgthreads' => 'GET',
    		'getthreads' => 'GET',
			'gettopthreads' => 'GET',
            'post' 			=> 'POST',
            'delete' 		=> 'POST',
            'update' 		=> 'POST',
            'getcomments' 	=> 'GET',
            'reply' 	    => 'POST',
    		'gethotreply'	=> 'GET',
        );
		
    /**
     * 
     * ȡϸϢ
     * @param int $tid
     * @return array
     */
    function get($tid){
    	global $attachpath, $db_windpost;
    	if (intval($tid) <= 0){
            return $this->errMessage(THREAD_INVALID_PARAMS,'invalid params');
        }
		$threadService = L::loadClass('threads', 'forum');
        $threadData = $threadService->getThreads($tid,true);
        require_once(R_P . 'require/bbscode.php');
        $threadData['content'] = convert($threadData['content'], $db_windpost);
    	
        $query = $this->db->query("SELECT aid,attachurl,pid,type FROM pw_attachs WHERE pid=0 AND tid=" . S::sqlEscape($tid));
        $attachImg = '';
		while($rt = $this->db->fetch_array($query)){
			$str_match = '[attachment=' . $rt['aid'] . ']';
			if ($rt['type'] != 'img') {
				$threadData['content'] = str_replace($str_match, '', $threadData['content']);
			} else {
				if (strpos($threadData['content'], $str_match) !== false) {
					$threadData['content'] = str_replace($str_match, '<img src="' . $attachpath .'/'. $rt['attachurl'] . '" />', $threadData['content']);
				} else {
					$attachImg .= '<img src="' . $attachpath .'/'. $rt['attachurl'] . '" />';
				}
			}
		}
		
		!empty($attachImg) && $threadData['content'] .= $attachImg;
		
		$threadInfo = array(
			'tid'         => $threadData['tid'],
    		'fid'         => $threadData['fid'],
    		'icon'        => $threadData['icon'],
    		'author'      => $threadData['author'],
    		'authorid'    => $threadData['authorid'],
    		'subject'     => $threadData['subject'],
    		'type'        => $threadData['type'],
    		'posttime'    => $threadData['postdate'],
    		'lastreplytime' => $threadData['lastpost'],
    		'lastreplyauthor' => $threadData['lastposter'],
    		'hitcount'    => $threadData['hits'],
    		'replycount'  => $threadData['replies'],
    		'bookmarkcount' => $threadData['favors'],
    		'modelid'     => $threadData['modelid'],
    		'sharecount'  => $threadData['shares'],
    		'topped'      => $threadData['topped'],
    		'topforum'    => $threadData['topreplays'],
    		'locked'      => $threadData['locked'],
    		'digest'      => $threadData['digest'],
    		'special'     => $threadData['special'],
    		'hasupload'   => $threadData['ifupload'],
    		'state'       => $threadData['state'],
			'content'     => $threadData['content']
		);
		
        return array('threadinfo' => $threadInfo);
    }
    
     /**
     * 
     * ȡб
     * @param int $offset
     * @param int $limit
     */
	function getdigestthreads($offset = 1, $limit = 20){
		$offset = ($offset - 1) * $limit;
		$query = $this->db->query("SELECT t.* FROM pw_threads t WHERE t.ifcheck = 1 AND t.digest in (1,2,3) ORDER BY t.postdate DESC " . S::sqlLimit($offset,$limit));

		while($threadData = $this->db->fetch_array($query)){
			$threads[] = array(
				'tid'         => $threadData['tid'],
				'fid'         => $threadData['fid'],
				'icon'        => $threadData['icon'],
				'author'      => $threadData['author'],
				'authorid'    => $threadData['authorid'],
				'subject'     => $threadData['subject'],
				'type'        => $threadData['type'],
				'posttime'    => $threadData['postdate'],
				'lastreplytime' => $threadData['lastpost'],
				'lastreplyauthor' => $threadData['lastposter'],
				'hitcount'    => $threadData['hits'],
				'replycount'  => $threadData['replies'],
				'bookmarkcount' => $threadData['favors'],
				'modelid'     => $threadData['modelid'],
				'sharecount'  => $threadData['shares'],
				'topped'      => $threadData['topped'],
				'topforum'    => $threadData['topreplays'],
				'locked'      => $threadData['locked'],
				'digest'      => $threadData['digest'],
				'special'     => $threadData['special'],
				'hasupload'   => $threadData['ifupload'],
				'state'       => $threadData['state']
			);
		}
		
		$count = $this->db->get_value("SELECT count(*) FROM pw_threads t WHERE t.ifcheck = 1 AND t.digest IN (1,2,3)");
		return array('count' => $count,'threads' => $threads);
    }
    
    
    /**
     * ȡ
     * @param Integer $offset
     * @param Integer $limit
     * @return Array
     */
    function getlatestthreads($offset = 1, $limit = 20) {
    	$offset = ($offset - 1) * $limit;
    	$query = $this->db->query("SELECT t.* FROM pw_threads t WHERE t.ifcheck = 1 ORDER BY t.postdate DESC " . S::sqlLimit($offset,$limit));
    	
    	while($threadData = $this->db->fetch_array($query)){
			$threads[] = array(
			'tid'         => $threadData['tid'],
    		'fid'         => $threadData['fid'],
    		'icon'        => $threadData['icon'],
    		'author'      => $threadData['author'],
    		'authorid'    => $threadData['authorid'],
    		'subject'     => $threadData['subject'],
    		'type'        => $threadData['type'],
    		'posttime'    => $threadData['postdate'],
    		'lastreplytime' => $threadData['lastpost'],
    		'lastreplyauthor' => $threadData['lastposter'],
    		'hitcount'    => $threadData['hits'],
    		'replycount'  => $threadData['replies'],
    		'bookmarkcount' => $threadData['favors'],
    		'modelid'     => $threadData['modelid'],
    		'sharecount'  => $threadData['shares'],
    		'topped'      => $threadData['topped'],
    		'topforum'    => $threadData['topreplays'],
    		'locked'      => $threadData['locked'],
    		'digest'      => $threadData['digest'],
    		'special'     => $threadData['special'],
    		'hasupload'   => $threadData['ifupload'],
    		'state'       => $threadData['state']
			);
		}
		
    	return array('threads'=>$threads);
    }
    
    /**
     * ȡͼƬID
     * @param $offset
     * @param $limit
     * @return Array
     */
    function getimgthreads($offset = 1, $limit = 20) {
    	global $attachpath;
    	$offset = ($offset - 1) * $limit;
    	$query = $this->db->query("SELECT tid,attachurl FROM pw_attachs WHERE `pid`=0 AND `type`='img' GROUP BY tid ORDER BY uploadtime DESC " . S::sqlLimit($offset,$limit));
    	while ($rt = $this->db->fetch_array($query)) {
    		$data[] = array(
    			'tid' => $rt['tid'],
    			'imgurl' => $attachpath .'/'. $rt['attachurl']
    		);
    	}
    	$count = $this->db->get_value("SELECT count(distinct tid) FROM pw_attachs WHERE `pid`=0 AND `type`='img'");
    	
    	return array('count'=>$count, 'imgthreadids'=>$data);
    }
    
	/**
	 * ȡµͨб
	 * @param int $fid
	 * @param int $offset
	 * @param int $limit
	 */    
 	function getthreads($fid, $offset = 1, $limit = 20){
    	if (intval($fid) < 1){
    		return $this->errMessage(THREAD_INVALID_PARAMS,'invalid params');	
    	}

    	$offset = ($offset - 1) * $limit;
    	$threadlistService = L::loadClass("threadlist", 'forum');
    	$threadList = $threadlistService->getThreads($fid, $offset, $limit);
    	foreach ($threadList as $value){
    		$threads[] = array(
    			'tid'         => $value['tid'],
    			'fid'         => $value['fid'],
    			'icon'        => $value['icon'],
    			'author'      => $value['author'],
    			'authorid'    => $value['authorid'],
    			'subject'     => $value['subject'],
    			'type'        => $value['type'],
    			'posttime'    => $value['postdate'],
    			'lastreplytime' => $value['lastpost'],
    			'lastreplyauthor' => $value['lastposter'],
    			'hitcount'    => $value['hits'],
    			'replycount'  => $value['replies'],
    			'bookmarkcount' => $value['favors'],
    			'modelid'     => $value['modelid'],
    			'sharecount'  => $value['shares'],
    			'topped'      => $value['topped'],
    			'topforum'    => $value['topreplays'],
    			'locked'      => $value['locked'],
    			'digest'      => $value['digest'],
    			'special'     => $value['special'],
    			'hasupload'   => $value['ifupload'],
    			'state'       => $value['state']
    		);
    	}
    	
    	$threadCount = $this->db->get_value("SELECT count(*) FROM pw_threads WHERE fid=" . S::sqlEscape($fid) . " AND ifcheck=1 AND topped=0");
    	return array('count' => $threadCount,'threads' => $threads);
    }
    
    /**
     * 
     * ȡöб
     * @param int $fid
     */
	function gettopthreads($fid){
		if (intval($fid) < 1) {
			return $this->errMessage(FORUM_INVALID_PARAMS, 'invalid params');
		}
		$topthreads = $this->db->get_value("SELECT topthreads FROM pw_forumdata WHERE fid=" . S::sqlEscape($fid));
		$toptids = trim($topthreads,',');
		$threads = array();
		$count = 0;
    	if ($toptids) {
			$query = $this->db->query("SELECT * FROM pw_threads WHERE tid IN($toptids) ORDER BY topped DESC,lastpost DESC");
			while ($rt = $this->db->fetch_array($query)) {
				$threads[] = array(
	    			'tid'         => $rt['tid'],
	    			'fid'         => $rt['fid'],
	    			'icon'        => $rt['icon'],
	    			'author'      => $rt['author'],
	    			'authorid'    => $rt['authorid'],
	    			'subject'     => $rt['subject'],
	    			'type'        => $rt['type'],
	    			'posttime'    => $rt['postdate'],
	    			'lastreplytime' => $rt['lastpost'],
	    			'lastreplyauthor' => $rt['lastposter'],
	    			'hitcount'    => $rt['hits'],
	    			'replycount'  => $rt['replies'],
	    			'bookmarkcount' => $rt['favors'],
	    			'modelid'     => $rt['modelid'],
	    			'sharecount'  => $rt['shares'],
	    			'topped'      => $rt['topped'],
	    			'topforum'    => $rt['topreplays'],
	    			'locked'      => $rt['locked'],
	    			'digest'      => $rt['digest'],
	    			'special'     => $rt['special'],
	    			'hasupload'   => $rt['ifupload'],
	    			'state'       => $rt['state']
    			);
				$count++;
			}
		}
		
		return array('count' => $count,'threads' => $threads);
    }
    
    /**
     * 
     * @param int $fid ID
     * @param int $uid ûID
     * @param string $title ӱ
     * @param string $content 
     * @param string $tags ӱǩ
     * @param int $convert Ƿwindcodeת
     * @param int $usesign Ƿʹûǩ
     * @param int $usehtml
     * @param int $topped Ƿö
     * @param int $digest 
     * @param string $p_type
     * @param string $p_sub_type
     * @return array
     */
    function post($fid, $uid, $title, $content, $tags = '', $convert = 0, $usesign = 1, $usehtml = 0, $topped = 0, $digest = 0, $p_type = '', $p_sub_type = '') {
        global $winddb,$winduid,$windid,$groupid,$timestamp,$pwforum,$pwpost;
    	L::loadClass('forum', 'forum', false);
        $pwforum = new PwForum($fid);
        if (!$pwforum->isForum()) {
        	return $this->errMessage(THREAD_FORUM_NOT_EXIST,'forum dont exist');
        }

        $userService = L::loadClass('UserService', 'user');
        $winddb = $userService->get($uid,true,true);
        
        if (empty($winddb)) {
        	return $this->errMessage(THREAD_USER_NOT_EXIST,'user dont exist');
        }
        $winduid = $winddb['uid'];
        $groupid = $winddb['groupid'];
        $windid  = $winddb['username'];
        $groupid == '-1' && $groupid = $winddb['memberid'];

        if ($groupid == 6 || getstatus($winddb['userstatus'], PW_USERSTATUS_BANUSER)) {
            return $this->errMessage(THREAD_USER_NOT_RIGHT,'user has not right');
        }

        if (file_exists(D_P . "data/groupdb/group_$groupid.php")) {
            include S::escapePath(D_P . "data/groupdb/group_$groupid.php");
        } else {
            include(D_P . 'data/groupdb/group_1.php');
        }
        
        L::loadClass('post', 'forum', false);
        require_once(R_P . 'require/bbscode.php');
        $pwpost = new PwPost($pwforum);
        $pwpost->errMode = true;

        L::loadClass('topicpost', 'forum', false);
        $topicpost = new topicPost($pwpost);
        $topicpost->check();

        $postdata = new topicPostData($pwpost);

        include_once(D_P . 'data/bbscache/cache_post.php');
        include_once(D_P . 'data/bbscache/forum_typecache.php');
        $t_db = $topic_type_cache[$fid];
        $postdata->setWtype($p_type, $p_sub_type, 1, $t_db);
        $postdata->setTitle($title);
        $postdata->setContent($content);

        $postdata->setConvert($convert, 1);
        $postdata->setTags($tags);
        $postdata->setDigest($digest);
        $postdata->setTopped($topped);
        $postdata->setIfsign($usesign, $usehtml);

        if ($pwpost->errMsg && $msg = reset($pwpost->errMsg)) {
            return $this->errMessage(THREAD_SYSTEM_ERROR,"system error [$msg]");
        }
        
    	L::loadClass('attupload', 'upload', false);
		if (PwUpload::getUploadNum()) {
			$postdata->att = new AttUpload($uid);
			$postdata->att->check();
			$postdata->att->transfer();
			PwUpload::upload($postdata->att);
		}
        $topicpost->execute($postdata);
        $tid = $topicpost->getNewId();
        
        return array('threadid' => $tid);
    }
    
    /**
     * ɾ
     * @param array $tids
     * @param int $uid
	 * @return array|int
     */
    function delete($tids,$uid) {
        global $db_recycle,$db_ifpwcache;
        if (empty($tids) || intval($uid) <= 0){
            return $this->errMessage(THREAD_INVALID_PARAMS,'invalid params');
        }
        
        if (!is_array($tids)) $tids = array($tids);
        $delids = array();
        foreach ($tids as $value) {
            if (is_numeric($value)) {
                $delids[] = $value;
            }
        }

        if (!$delids) {
             return $this->errMessage(THREAD_INVALID_PARAMS, 'invalid params');
        }

        $delarticle = L::loadClass('DelArticle', 'forum');
        $readdb = $delarticle->getTopicDb('tid ' . $delarticle->sqlFormatByIds($delids));
        foreach ($readdb as $key => $read) {
            if ($read['authorid'] != $uid) {
                return $this->errMessage(THREAD_USER_NOT_RIGHT, 'user has not right');
            }
        }
        
        $delarticle->delTopic($readdb, 0);

        if ($db_ifpwcache ^ 1) {
            $this->db->update("DELETE FROM pw_elements WHERE type !='usersort' AND id IN(" . S::sqlImplode($delids) . ')');
        }
        P_unlink(D_P . 'data/bbscache/c_cache.php');
        return 1;
    }
    
	/**
     * 
     * @param int $tid ID
     * @param int $uid ûID
     * @param string $title ӱ
     * @param string $content ӱ
	 * @param int $fid Ӱ
     * @param string $tags ӱǩ
     * @param int $convert windcodeת
     * @param int $usesign ûǩ
     * @param int $usehtml
     * @param int $topped Ƿö
     * @param int $digest
     * @param string $p_type
     * @param string $p_sub_type
     * @return array
     */
    function update($tid, $uid, $title, $content, $fid = 0, $tags = '', $convert = 0, $usesign = 1, $usehtml = 0, $topped = 0, $digest = 0, $p_type = '', $p_sub_type = '') {
        global $winddb,$winduid,$windid,$groupid,$timestamp,$_G,$SYSTEM;
        if (intval($tid) <= 0 || intval($uid) <= 0 || intval($fid) < 0){
            $this->errMessage(THREAD_INVALID_PARAMS,'invalid params');
        }
        
        $threadService = L::loadClass('Threads','forum');
        $threadInfo = $threadService->getThreads($tid);
        (intval($fid) <= 0) && $fid = $threadInfo['fid'];
         
        L::loadClass('forum', 'forum', false);
        $pwforum = new PwForum($fid);
        if (!$pwforum->isForum()) {
            return $this->errMessage(THREAD_FORUM_NOT_EXIST,'forum dont exist');
        }
        
        $userService = L::loadClass('UserService', 'user');
        $winddb = $userService->get($uid, true, true);
        if (empty($winddb)) {
            return $this->errMessage(THREAD_USER_NOT_EXIST,'user dont exist');
        }
        $winduid = $winddb['uid'];
        $groupid = $winddb['groupid'];
        $windid  = $winddb['username'];
        $groupid == '-1' && $groupid = $winddb['memberid'];
        if (file_exists(D_P . "data/groupdb/group_$groupid.php")) {
            include S::escapePath(D_P . "data/groupdb/group_$groupid.php");
        } else {
            include(D_P.'data/groupdb/group_1.php');
        }
        L::loadClass('post', 'forum', false);
        require_once(R_P . 'require/bbscode.php');
        $pwpost = new PwPost($pwforum);
        $pwpost->errMode = true;

        L::loadClass('postmodify', 'forum', false);
        $postmodify = new topicModify($tid, 0, $pwpost);
        $atcdb = $postmodify->init();
        if (empty($atcdb) || $atcdb['fid'] != $fid) {
            return $this->errMessage(THREAD_ID_NOT_ILLEGAL,'thread id is not illegal');
        }

        if ($winduid != $atcdb['authorid'] && $groupid != 3 && $groupid != 4) {
            $authordb = $userService->get($atcdb['authorid']);       
            $pce_arr = explode(",",$GLOBALS['SYSTEM']['tcanedit']);
            if (($authordb['groupid'] == 3 || $authordb['groupid'] == 4 || $authordb['groupid'] == 5) && !in_array($authordb['groupid'],$pce_arr)) {
                return $this->errMessage(THREAD_USER_NOT_RIGHT, 'user has not right');
            }
        }

        if ($_G['edittime'] && ($timestamp - $atcdb['postdate']) > $_G['edittime'] * 60) {
            return $this->errMessage(THREAD_EDIT_TIME_LIMIT, 'time limit for thread update');
        }

        $postdata = new topicPostData($pwpost);

        include_once(D_P . 'data/bbscache/cache_post.php');
        $t_db = $topic_type_cache[$fid];
        $postdata->setWtype($p_type, $p_sub_type, 0, $t_db);
        $postdata->initData($postmodify);
        $postdata->setTitle($title);
        $postdata->setContent($content);
        $postdata->setConvert($convert, 1);
        $postdata->setTags($tags);
        $postdata->setDigest($digest);
        $postdata->setTopped($topped);
        $postdata->setIfsign($usesign, $usehtml);

        if ($pwpost->errMsg && $msg = reset($pwpost->errMsg)) {
            $errmsg = $this->getErrMsg($msg);
            return $this->errMessage($errmsg[0], $errmsg[1]);
        }

        $postmodify->execute($postdata);
        return 1;
    }
    
    
	/**
	 * IDȡظ
	 * @param Integer $tid ID
	 * @param Integer $offset ƫ
	 * @param Integer $limit 
	 * @return Array
	 */
	function getcomments($tid, $offset = 1, $limit = 20, $threaddetail = 0) {
		global $_G,$isGM,$pwSystem,$groupid,$attach_url,$db_onlinetime,$attachdir,$attachpath,$lpic,$ltitle,$imgpath,$db_windpost,$db_windpic,$db_signwindcode,$md_ifopen,$_MEDALDB,$rewardtype,$db_shield,$db_iftag,$db_readtag;
		if (intval($tid) < 1) {
			return $this->errMessage(THREAD_INVALID_PARAMS, 'invalid params');
		}
		require_once(R_P . 'require/bbscode.php');
		$offset = ($offset - 1) * $limit;
		
		$list = array();
		$pw_posts = $this->_getPtable($tid);
		$query = $this->db->query("SELECT * FROM $pw_posts WHERE tid=" . S::sqlEscape($tid) . " AND ifcheck='1' ORDER BY ifreward ASC, postdate ASC " . S::sqlLimit($offset, $limit));
		while ($rt = $this->db->fetch_array($query)) {
			$rt['content'] = convert($rt['content'], $db_windpost);
			$list[$rt['pid']] = array(
				'pid'      => $rt['pid'],
				'tid'      => $rt['tid'],
				'author'   => $rt['author'],
				'authorid' => $rt['authorid'],
				'posttime' => $rt['postdate'],
				'subject'  => $rt['subject'],
				'content'  => $rt['content']
			);
		}
		
		$query = $this->db->query("SELECT aid,attachurl,pid,type FROM pw_attachs WHERE pid!=0 AND tid=" . S::sqlEscape($tid));
		while($rt = $this->db->fetch_array($query)){
			$str_match = '[attachment=' . $rt['aid'] . ']';
			if ($rt['type'] != 'img') {
				$list[$rt['pid']]['content'] = str_replace($str_match, '', $list[$rt['pid']]['content']);
			} else {
				$list[$rt['pid']]['content'] = str_replace($str_match, '<img src="' . $attachpath .'/'. $rt['attachurl'] . '" />', $list[$rt['pid']]['content']);
			}
		}
		$commentList = array();
		foreach ($list as $value){
			$commentList[] = array('author'=>$value['author'], 'posttime'=>get_date($value['posttime']), 'content'=>$value['content']);
		}
		
		$treadInfo = '';
		if ($threaddetail != 0) $treadInfo = $this->get($tid);
		
		$count = $this->db->get_value("SELECT count(*) FROM $pw_posts WHERE tid=" . S::sqlEscape($tid) . " AND ifcheck='1'");
		return array('count' => $count,'comments' => $commentList, 'threadinfo'=> $treadInfo['threadinfo']);
	}
	
	/**
	 * 
	 * ظ
	 * @param int $tid
	 * @param string $author
	 * @param int $authorid
	 * @param string $subject
	 * @param string $content
	 * @param int $ifcheck
	 * @return int|array
	 */
	function reply($tid,$authorid,$subject,$content,$ifcheck = 1) {
		if (intval($tid) < 1 || trim($subject) == '' || trim($content) == '' || intval($authorid) < 1){
			return $this->errMessage(THREAD_INVALID_PARAMS, 'invalid params');
		}
		
		$threadService = L::loadClass('Threads','forum');
        $threadInfo = $threadService->getThreads($tid);
        $fid = $threadInfo['fid'];
        if (intval($fid) < 1){
			return $this->errMessage(THREAD_INVALID_PARAMS, 'invalid params');
        }
        $userService = $this->_getUserService();
		$data = array(
			'tid' => $tid,
			'fid' => $fid,
			'author' => $userService->getUserNameByUserId($authorid),
			'authorid' => $authorid,
		    'postdate' => $this->timestamp,
			'subject' => $subject,
			'content' => $content,
			'ifcheck' => $ifcheck,
			'ifconvert' => '0'
		);
		$pwSQL = S::sqlSingle($data);
		$postTable = $threadInfo['ptable'] ? 'pw_posts' . $threadInfo['ptable'] : 'pw_posts';
		$this->db->update("INSERT INTO $postTable SET $pwSQL");
		$this->db->update("UPDATE pw_threads SET replies=replies+1 WHERE tid=" . S::sqlEscape($tid));
		return 1;
	}
	
	/**
	 * Żظ
	 * @param Integer $num 
	 * @return Array
	 */
	function gethotreply($num = 20) {
		$elementService = $this->_getElementService();
		$data = $elementService->replySort(0, $num);
		$reply = array();
		foreach ($data as $item) {
			$reply[] = array(
				'tid' => $item['addition']['tid'],
				'fid' => $item['addition']['fid'],
				'author' => $item['addition']['author'],
				'authorid' => $item['addition']['authorid'],
				'subject' => $item['addition']['subject'],
				'hitcount' => $item['addition']['hits'],
				'replycount' => $item['addition']['replies'],
				'postdate' => $item['addition']['postdate'],
				'forumname' => $item['forumname'],
			);
		}
		
		return array('hotreply' => $reply);
	}
	
	/**
	 * ȡֱ
	 *
	 * @global array $db_plist
	 * @param int $tid id
	 * @return string
	 */
	function _getPtable($tid) {
		if ($GLOBALS['db_plist'] && is_array($plistdb = $GLOBALS['db_plist'])) {
			$postTableId = $this->db->get_value('SELECT ptable FROM pw_threads WHERE tid=' . S::sqlEscape($tid, false));
			if ((int) $postTableId > 0 && array_key_exists($postTableId, $plistdb)) {return 'pw_posts' . $postTableId;}
		}
		return 'pw_posts';
	}
	
	/**
	 * @return PW_UserService
	 */
	function _getUserService() {
		return L::loadClass('UserService', 'user');
	}
	
	/**
	 * @return PW_ElementService
	 */
	function _getElementService() {
		return L::loadClass('element');
	}
}