<?php
!defined('P_W') && exit('Forbidden');

define('FORUM_INVALID_PARAMS',401);
class ForumApi extends BaseApi {
	var $methodsType = array(
			'get'     => 'GET',
			'add'     => 'POST',
		);

	/**
	 * ȡϢ
	 * @param int $fid ID
	 * @return array
	 */
	function get($fid) {
        if (intval($fid) < 1){
			return $this->errMessage(FORUM_INVALID_PARAMS, 'invalid params');
		}

		L::loadClass("forum", 'forum', false);
        $forumService = new PwForum($fid);
        $forum = $forumService->get($fid);
		$forumData = $this->db->get_one("SELECT * FROM pw_forumdata WHERE fid=" . S::sqlEscape($fid));
        $forumInfo = array(
        	'fid'           => $forum['fid'],
			'parentid'      => $forum['fup'],
			'ischild'       => $forum['ifsub'],
			'childid'       => $forum['childid'],
			'name'          => $forum['name'],
			'description'   => $forum['descrip'],
			'logo'          => $forum['logo'],
			'type'          => $forum['type'],
			'vieworder'     => $forum['vieworder'],
			'visitlimit'    => $forum['allowvisit'],
			'readlimit'     => $forum['allowread'],
			'postlimit'     => $forum['allowpost'],
			'replylimit'    => $forum['allowrp'],
			'downloadlimit' => $forum['allowdownload'],
			'uploadlimit'   => $forum['allowupload'],
    		'todayposts'    => $forumData['tpost'],
    		'topiccount'    => $forumData['topic'],
    		'threadcount'   => $forumData['article']
        );
        return array('forum' => $forumInfo);
    }
    
    /**
     * ȡб
     * @param int $offset
     * @param int $limit
     * @return int
     */
	function getforums(){
    	$forumQuery = $this->db->query("SELECT f.*,fd.tpost AS todayposts,fd.topic AS topiccount,fd.article AS threadcount FROM pw_forums f LEFT JOIN pw_forumdata fd ON fd.fid=f.fid");
    	$forums = array();
    	while ($row = $this->db->fetch_array($forumQuery)){
    		$forums[] = array(
				'fid'           => $row['fid'],
				'parentid'      => $row['fup'],
				'ischild'       => $row['ifsub'],
				'childid'       => $row['childid'],
				'name'          => $row['name'],
				'description'   => $row['descrip'],
				'logo'          => $row['logo'],
				'type'          => $row['type'],
				'vieworder'     => $row['vieworder'],
				'visitlimit'    => $row['allowvisit'],
				'readlimit'     => $row['allowread'],
				'postlimit'     => $row['allowpost'],
				'replylimit'    => $row['allowrp'],
				'downloadlimit' => $row['allowdownload'],
				'uploadlimit'   => $row['allowupload'],
    			'todayposts'    => $row['todayposts'],
    			'topiccount'    => $row['topiccount'],
    			'threadcount'   => $row['threadcount']
			);
    	}
    	
    	$forumCount = $this->db->get_value("SELECT count(*) FROM pw_forums");
    	return array('count' => $forumCount,'forums' => $forums);
    }
   	
	/**
	 * 
	 * @param string $name
	 * @param string $fup
	 * @param string $descrip
	 * @param string $linkurl
	 * @return array
	 */
	function add($name, $fup = 0,$descrip = '',$linkurl = '') {
		if (trim($name) == '') {
			return $this->errMessage(FORUM_INVALID_PARAMS, 'invalid params');
		}
		
		$forum = array();
		@include_once(D_P.'data/bbscache/forum_cache.php');
		$forumtype = $forum[$fup]['type'] == 'category' ? 'forum' : ($forum[$fup]['type'] == 'forum' ? 'sub' : 'sub2');
		
		$this->db->update(pwQuery::insert('pw_forums', array(
			'fup'			=> $fup,
			'type'			=> $forumtype,
			'name'			=> $name,
			'descrip'		=> $descrip,
			'cms'			=> 0,
			'ifhide'		=> 1,
			'allowtype'		=> 3
		)));

		$fid = $this->db->insert_id();
		$this->db->update("INSERT INTO pw_forumdata SET fid=".S::sqlEscape($fid));

		$forumset = array(
			'lock'		=> 0,		'cutnums'		=> 0,			'threadnum'		=> 0,			'readnum'		=> 0,
			'newtime'	=> 0,		'orderway'		=> 'lastpost',	'asc'			=> 'DESC',		'allowencode'	=> 0,
			'anonymous'	=> 0,		'rate'			=> 0,			'dig'			=> 0,			'inspect'		=> 0,
			'watermark'	=> 0,		'commend'		=> 0,			'autocommend'	=> 0,			'commendlist'	=> '',
			'commendnum'=> 0,		'commendlength' => 0,			'commendtime'	=> 0,			'addtpctype'	=> 0,
			'ifrelated'	=> 0,		'relatednums'	=> 0,			'relatedcon'	=> 'ownpost',	'relatedcustom'	=> array(),
			'rvrcneed'	=> 0,		'moneyneed'		=> 0,			'creditneed'	=> 0,			'postnumneed'	=> 0,
			'sellprice'	=> array(),	'uploadset'		=>'money 0',	'rewarddb'		=> '',			'allowtime'		=>''
		);
		$forumset['link'] = $linkurl;
		$forumset = serialize($forumset);
		$this->db->update("INSERT INTO pw_forumsextra SET " . S::sqlSingle(array(
			'fid'			=> $fid,
			'forumset'		=> $forumset
		)));

		P_unlink(D_P.'data/bbscache/c_cache.php');
		require_once(R_P . 'admin/cache.php');
		updatecache_f();
		require_once(R_P . 'require/updateforum.php');
		$forumtype != 'category' && updatetop();

		return array('forumid' => $fid);
	}
}