<?php
!defined('P_W') && exit('Forbidden');

/**
 * OpenIMչصclass
 * @author zuojie
 *
 */
class PW_OpenImLamp {
	/**
	 * @var bool Ƿ
	 */
	var $_lampIsEnabled = true;
	/**
	 * ƵûID
	 * @var array
	 */
	var $_openImUserIds = array();
	/**
	 * @var int ǰ鿴ûuid
	 */
	var $_viewerUserId;
	/**
	 * @var string ҳı
	 */
	var $_encoding = 'gbk';
	/**
	 * @var string ҳı
	 */
	var $_clientDownloadUrl;
	
	/**
	 * վid
	 * @var int
	 */
	var $_siteId;
	
	/**
	 * ȡ
	 * @return PW_OpenImLamp
	 */
	function &getInstance()
	{
		static $instance = null;
		if ($instance == null) {
			$instance = new PW_OpenImLamp();
			$instance->_init();
		}
		return $instance;
	}
	
	function _init()
	{
		$openimService = L::loadClass('OpenIm', 'openim');
		$this->setSiteId($openimService->getSiteId());
		global $charset, $db_bbsurl, $winduid;
		if ($charset) {
			$this->setEncoding($charset);
		}
		if ($db_bbsurl) {
			$this->setClientDownloadUrl($db_bbsurl . '/yunliao.php');
		}
		if ($winduid) {
			$this->setViewerUserId($winduid);
		}
	}
	/**
	 * ƿ״̬
	 * @param bool $bool
	 * @return PW_OpenImLamp
	 */
	function enableLamp($bool = true) {
		$this->_lampIsEnabled = $bool ? true : false;
	}
	
	/**
	 * ر
	 * @return PW_OpenImLamp
	 */
	function disableLamp() {
		return $this->enableLamp(false);
	}
	
	/**
	 * վId
	 * @return number
	 */
	function getSiteId() {
		return $this->_siteId;
	}
	
	/**
	 * վid
	 * @param int $siteId
	 * @return PW_OpenImLamp
	 */
	function setSiteId($siteId) {
		$this->_siteId = (int)$siteId;
	}
	
	/**
	 * Ƿ״̬
	 * @return bool Ƿʼ
	 */
	function lampIsEnabled() {
		return $this->_lampIsEnabled ? true : false; 
	}
	
	/**
	 * OpenIMʺݵı룬ȡOpenIM״̬URLʹ
	 * @param string $encoding
	 * @return PW_OpenImLamp
	 */
	function setEncoding($encoding) {
		$this->_encoding = $encoding;
	}
	
	/**
	 * OpenIMͻ˵صַ
	 * @param string $url
	 * @return PW_OpenImLamp
	 */
	function setClientDownloadUrl($url) {
		$this->_clientDownloadUrl = $url;
	}
	
	/**
	 * صǰȡ״̬OpenIMʺŸ
	 * @return number
	 */
	function _getAccountCount() {
		return count($this->_openImUserIds);
	}
	
	/**
	 * ҳ鿴ߵuidڵͼϢò鿴ߵOpenIMʺ
	 * @param int $userId
	 * @return PW_OpenImLamp
	 */
	function setViewerUserId($userId) {
		$userId = (int)$userId;
		if ($userId < 1) return $this;
		$this->_viewerUserId = $userId;
	}

	/**
	 * طû״̬HTML
	 * @param int $uid
	 * @return string ŵƵHTML
	 */
	function getLamp($uid, $isBig = true) {
		if (!$this->lampIsEnabled()) return '';
		$uid = (int)$uid;
		if ($uid < 1) return '';
		$number = $this->_addUserId($uid) - 1;
		//Ŵ0ʼ
		return '<span id="openImNo' . $number . '" class="' .($isBig ? 'openim_big' : 'openim_small'). '"></span>';
	}
	/**
	 * ȡϢûID
	 * @param int $userId
	 * @return number|number ɺûID
	 */
	function _addUserId($userId) {
		$userId = (int)$userId;
		if ($userId < 1) return count($this->_openImUserIds);
		if (!is_array($this->_openImUserIds)) {
			$this->_openImUserIds = array();
		}
		return array_push($this->_openImUserIds, $userId);
	}
	
	/**
	 * ȡȡϢûOpenIMʺŵϢ
	 * @return Array Ϊarray(1 => array('uid' => 2, 'openimpre' => 'cntaobao', 'openimid' => 'someone'))
	 */
	function _getOpenImAccounts() {
		$newArray = array_unique($this->_openImUserIds);
		if (count($newArray) == 0) {
			return array();
		}
		$userService = $this->_getUserService();
		$usersInfo = $userService->getByUserIds($newArray);
		$openImAccounts = array();
		foreach ($this->_openImUserIds as $id => $userId) {
			if (isset($usersInfo[$userId])) {
				$openImAccounts[$id] = array('uid' => (int)$userId, 'openimpre' => 'cnphpwnd' . $this->getSiteId(), 'openimid' => $usersInfo[$userId]['username']);
			} else {
				$openImAccounts[$id] = array('uid' => (int)$userId, 'openimpre' => '', 'openimid' => '');
			}
		}
		return $openImAccounts;
	}
	/**
	 * ȡûOpenIMʺϢ
	 * @param int $uid
	 * @return array OpenIMʺϢΪarray('uid' => 1, 'openimpre' => 'cntaobao', 'openimid' => 'someone')
	 */
	function _getOpenImUserInfo($uid) {
		if ($this->_openImUsersInfo[$uid]) return $this->_openImUsersInfo[$uid];
		$userService = $this->_getUserService();
		$userInfo = $userService->get($uid);
		if ($userInfo) {
			$userInfo = array('uid' => (int)$userInfo['uid'], 'openimpre' => 'cnphpwnd' . $this->getSiteId(), 'openimid' => $userInfo['username']);
			return $userInfo;
		}
		return null;
	}
	/**
	 * չƵHTML
	 * @return string ʾƵHTML
	 */
	function getShowLamp() {
		if (!$this->lampIsEnabled()) return ''; //״̬չ
		/* @var $return string ҪصHTML*/
		$return = '';
		//ȡҳ鿴ߵOpenIMʺ
		$viewerUserId = $this->_viewerUserId;
		$viewerOpenImPre = $viewerOpenImId = '';
		if ($viewerUserId) {
			$viewerOpenImInfo = $this->_getOpenImUserInfo($viewerUserId);
			$viewerOpenImPre = $viewerOpenImInfo['openimpre'];
			$viewerOpenImId = $viewerOpenImInfo['openimid'];
		}
		/* @var $clientDownloadUrl string OpenIMͻصַ*/
		$clientDownloadUrl = $this->_clientDownloadUrl;
		/* @var $count int չƵOpenIMʺŸ */
		$count = $this->_getAccountCount();
		if ($count == 0) return ''; //ʺҪչ
		
		$return .= "\n" . '<script type="text/javascript">
	var openImPrefix	= \'' . $viewerOpenImPre . '\';
	var openImId	= \'' . $viewerOpenImId . '\';
	var openImClientDownloadUrl = \'' . $clientDownloadUrl . '\';
	var openImAccounts = new Array();' . "\n";
		/* @var $fullOpenImAccount array OpenIMʺţcntaobaosomeonecnaliyunsomeone@aliyun.com*/
		$fullOpenImAccount = array();
		$i=$j=0;
		foreach ($this->_getOpenImAccounts() as $openImUserInfo) {
			if ($openImUserInfo['openimpre'] == '' || $openImUserInfo['openimid'] == '') {
				$j++;
				continue;
			}
			$fullOpenImAccount[] = $openImUserInfo['openimpre'] .'@'. $openImUserInfo['openimid'];
			$return .= "\t" . 'openImAccounts[' . $i . '] = new Array(\'' . $openImUserInfo['openimpre'] . '\', \'' . $openImUserInfo['openimid']. '\', \'openImNo' . $j . '\');' . "\n";
			$i++;
			$j++;
		}
		if ($i == 0) return '';
		$return .= '	var online = new Array(' . intval($i)  . ');
	for(var i=0;i<online.length;i++){
		online[i] = 0;
	}' . "\n";
		$return .= '</script>' . "\n";
		/* @var $openImAccountUrlString string ȡ״̬URLĲ*/
		$openImAccountUrlString = implode(';', $fullOpenImAccount);
		//ṩĽӿֻ֧gbkΪURLҪת
		$encoding = $this->_encoding;
		if (strtolower($encoding) != 'gbk') {
			$openImAccountUrlString = pwConvert($openImAccountUrlString, 'gbk', $encoding);
		}
		$openImAccountUrlString = rawurlencode($openImAccountUrlString);
		
		//ȡ״̬jsΪonline
		$return .= '<script src="http://amos.im.alisoft.com/mullidstatus.aw?beginnum=0&uids=' . $openImAccountUrlString . '" type="text/javascript"></script>' . "\n";
		//ȡͼӦjs
		/*require_once(R_P . 'lib/utility/platformapisdk/client.class.php');
		global $db_sitehash, $db_siteownerid;
		$platformApiClient = new PlatformApiClient($db_sitehash, $db_siteownerid);
		$platformBaseUrl = rtrim($platformApiClient->getPlatformApiBaseUrl(), '/');*/
		$platformBaseUrl = 'http://apps.phpwind.net';
		$return .= '<script type="text/javascript" src="'.$platformBaseUrl.'/openim/js/taoyou.js" charset="utf-8"></script>' . "\n";
		//صչƵjs
		$return .= '<script type="text/javascript" src="js/openim.js"></script>' . "\n";
		//showLampչֳ
		$return .= '<script type="text/javascript">
showLamp(online, openImAccounts, openImPrefix, openImId, openImClientDownloadUrl);
</script>' . "\n";
		return $return;
	}
	/**
	 * @return PW_UserService
	 */
	function _getUserService() {
		return L::loadClass('UserService', 'user');
	}
}