<?php
!function_exists('readover') && exit('Forbidden');

class PW_OpenImFeed {
	var $platformApiClient;
	
	function initPlatformApiClient($db_sitehash,$db_siteownerid, $charset = null){
		$this->_loadPlatformApiSdk();
	    $this->platformApiClient = new PlatformApiClient($db_sitehash, $db_siteownerid, $charset);
	}
	
	/**
	 * RSSͻ
	 * @param string $windid û
	 * @param string $content ǩ
	 * @return json
	 */
    function subscribe($winduid,$feedUrl,$cid){
	    $data = array(
	    	'bbsuid' => $winduid,
	    	'feedurl'  => $feedUrl,
	    	'cid'      => $cid,
	    	'format'   => 'json'
	    );
	    return $this->platformApiClient->get('openim.feed.subscribe', $data, true);
	}
	
	function getUserCategory($winduid){
		$params = array(
	    	'bbsuid' => $winduid,
	    	'format'   => 'json'
	    );
	    return $this->platformApiClient->get('openim.feed.getusercategory', $params, true);
	}
	
	function hassubscribed($winduid,$feedUrl){
		$params = array(
	    	'bbsuid' => $winduid,
			'feedurl'  => $feedUrl,
	    	'format'   => 'json'
	    );
	    return $this->platformApiClient->get('openim.feed.hassubscribed', $params, true);
	}
	
	function _loadPlatformApiSdk(){
		require_once(R_P . 'lib/utility/platformapisdk/client.class.php');
	}
}