<?php
!defined('R_P') && exit('Forbidden');
require_once('message.ms.php');
require_once('message.ms.php');
/**
 * @author zuojie
 *
 */
class MS_Openimmessage extends MS_Message {
	/**
	 * @var int Ϣֽ
	 */
	var $MAX_MESSAGE_SUBJECT_LENGTH = 200;
	/**
	 * @param int $userId
	 * @param array $userNames
	 * @param array $messageInfo
	 * @param unknown_type $typeId
	 * @access public
	 * @return true|PW_Service_MessageException
	 */
	function _sendMessage($userId,$userNames,$messageInfo,$typeId = null){
		$userId = intval($userId);
		$result = $this->setSender($userId);
		if (isException($result)) return $result;
		if( 1 > $userId || "" == $userNames || !$messageInfo || !is_array($userNames) ){
			return new PW_Service_MessageException('invalid param', 101);
		}
		$result = $this->checkMessageInfo($messageInfo);
		if (isException($result)) return $result;
		$typeId = ($typeId) ? $typeId : $this->getmap($this->_sms_message);
		if(isException($result = $this->__checkUserLevel($this->_sms,count($userNames),$typeId))){
			return $result;
		}
		list($userNames,$categoryId,$typeId) = $this->_checkReceiver($userNames,$this->_sms,$typeId);
		if(!$userNames) return new PW_Service_MessageException('invalid receiver', -102);
		list($userIds,$userNames) = $this->_getUserByUserNames($userNames,true);
		//modded by zuojie
		if (is_array($userIds) && in_array($userId, $userIds)) {
			return new PW_Service_MessageException('cannot send message to oneself', -104);
		}
		if(!$userIds) return new PW_Service_MessageException('receiver does not exist', -103);
		if( 2 <= count($userIds)){
			$userIds = array_slice($userIds,0,$this->_receiver);
			$messageId = $this->_sendMulti($userId,$userIds,$userNames,$categoryId,$typeId,$messageInfo);
		}else{
			$messageId = $this->_sendSingle($userId,$userIds[0],$userNames[0],$categoryId,$typeId,$messageInfo);			
		}
		if(!$messageId) return new PW_Service_MessageException('failure in inserting message to db', -105);
		$this->_doReply($userId,$messageId,$messageInfo);
		$this->_updateStatisticsByUserNames($userIds,false,$category,1);
		$this->_updateUserMessageNumbers($userIds);
		return $messageId;
	}
	
	function _sendReply($userId,$relationId,$parentId,$messageInfo) {
		$userId = (int)$userId;
		$parentId = (int)$parentId;
		$relationId = (int)$relationId;
		if( $userId < 1 || $parentId < 1 || $relationId < 1 || !$messageInfo ){
			return new PW_Service_MessageException('invalid param', 101);
		}
		$result = $this->setSender($userId);
		if (isException($result)) return $result;
		
		$typeId = $this->getmap($this->_sms_message);
		if(isException($result = $this->__checkUserLevel($this->_sms,1,$typeId))){
			return $result;
		}
		$messagesDao = $this->getMessagesDao();
		if(!($message = $messagesDao->get($parentId))){
			return new PW_Service_MessageException('parent message does not exist', -601);
		}
		$relationsDao = $this->getRelationsDao();
		if(!($relation = $relationsDao->getRelation($userId,$relationId)) || $relation['mid'] != $parentId ){
			return new PW_Service_MessageException('invalid relation id', -602);
		}
		$result = $this->checkMessageInfo($messageInfo);
		if (isException($result)) return $result;
		if(!($result = $this->_doReply($userId,$parentId,$messageInfo))){
			return new PW_Service_MessageException('failure in doing reply', -603);
		}
		$messagesDao->update(array('modified_time'=>$this->_timestamp,'content'=>$messageInfo['content']),$parentId);
		$fieldData = array('status'=>$this->_s_new_reply,'modified_time'=>$this->_timestamp);
		// history to normal type
		$expand = ($message['expand']) ? unserialize($message['expand']) : array();
		if( $relation['categoryid'] == $this->getMap($this->_history)){
			$expand = ($message['expand']) ? unserialize($message['expand']) : array();
			$expand && $fieldData['categoryid'] = $expand['categoryid'];
		}
		$categoryId = ($fieldData['categoryid']) ? $fieldData['categoryid'] : $relation['categoryid'];
		$relationsDao->updateRelationsByMessageId($fieldData,$parentId);
		$this->_updateStatisticsByCategoryId($categoryId,$message,$userId);
		return $result;
	}
	/**
	 * ȫּûǷϢȨ
	 * @param unknown_type $category
	 * @param unknown_type $number
	 * @param unknown_type $typeId
	 * @access protected
	 * @return true|PW_Service_MessageException Уtrue򣬷exception
	 */
	function __checkUserLevel($category,$number = 1,$typeId = null) {
		//ϢǷ
		if($this->_super){
			return true;
		}
		if(!in_array($category,array($this->_sms,$this->_groupsms))){
			return true;
		}
		$typeIds = $this->_getSpecialMap(array($this->_sms_message,$this->_groupsms_normal));
		if($typeId && !in_array($typeId,$typeIds)){
			return true;
		}
		if(!isset($this->_userGroup['allowmessege']) || !$this->_userGroup['allowmessege'] ){
			return new PW_Service_MessageException('user group not allowed to send message', -501);
		}
		if( $number > 1 && (!isset($this->_userGroup['multiopen']) || !$this->_userGroup['multiopen'])){
			return new PW_Service_MessageException('user group not allowed to batch-send message', -502);
		}
		// ÿϢĿ
		$relationsDao = $this->getRelationsDao();
		//$this->_userGroup['maxsendmsg'] = ($this->_userGroup['maxsendmsg']) ? $this->_userGroup['maxsendmsg'] : 20;
		if(isset($this->_userGroup['maxsendmsg']) && $this->_userGroup['maxsendmsg'] > 0){
			if( $this->_userGroup['maxsendmsg' ] - 1 < ( $total = $relationsDao->countSelfByUserId($this->_userId,$this->_nodeTime))){
				return new PW_Service_MessageException('message daily sending quota limit reached', -503, null, $this->_userGroup['maxsendmsg']);
			}
		}
		// ûϢ
		if(isset($this->_userGroup['maxmsg']) && $this->_userGroup['maxmsg'] > 0){
			$userInfo = $this->_countUserNumbers(array($this->_userId));
			if( $userInfo && $this->_userGroup['maxmsg' ] - 1 < $userInfo[$this->_userId] ){
				return new PW_Service_MessageException('message quota limit reached', -504, null, $this->_userGroup['maxmsg']);
			}
		}
		return true;
	}
	/**
	 * ÷ߵID
	 * @param int $userId
	 * @return MS_Base|PW_Service_MessageException
	 */
	function setSender($userId) {
		global $winduid;
		$userId = (int)$userId;
		if ($userId < 1) return new PW_Service_MessageException('invalid param', 501);
		//ûڲ뵱ǰûһ£ֱӷ
		if ($userId == $winduid) return $this;
		$userService = L::loadClass('UserService', 'user');
		$userInfo = $userService->get($userId);
		if (!$userInfo) return new PW_Service_MessageException('sender not found', -511);
		$groupId = $userInfo['groupid'] == -1 ? $userInfo['memberid'] : $userInfo['groupid'];
		if ($groupId == '') {
			return new PW_Service_MessageException('invalid group id', -512);
		}
		if (file_exists(D_P."data/groupdb/group_$groupId.php")) {
			require S::escapePath(D_P."data/groupdb/group_$groupId.php");
		} else {
			require(D_P.'data/groupdb/group_1.php');
		}
		$this->_userId = $userInfo['uid'];
		$this->_userName = $userInfo['username'];
		$this->_groupId = $groupId;
		$this->_userGroup = $_G;
		return $this;
	}
	/**
	 * ˽мϢݺ
	 * @param $messageInfo
	 * @return unknown_type
	 */
	function _checkInfo($messageInfo){
		//дʹ
		//modded by zuojie
		$filterUtil = L::loadClass('filterutil', 'filter');
		$messageInfo['title'] = $filterUtil->convert($messageInfo['title']);
		$messageInfo['content']   = $filterUtil->convert($messageInfo['content']);
		return parent::_checkInfo($messageInfo);
	}
	/**
	 * @param array $messageInfo
	 * @return true|PW_Service_MessageException
	 */
	function checkMessageInfo ($messageInfo) {
		if (strlen($messageInfo['title']) > $this->MAX_MESSAGE_SUBJECT_LENGTH) {
			return new PW_Service_MessageException('message subject too long', -121, null, $this->MAX_MESSAGE_SUBJECT_LENGTH);
		}
		$groupAuth = $this->_userGroup;
		if (isset($groupAuth['messagecontentsize']) && $groupAuth['messagecontentsize'] > 0 && strlen($messageInfo['content']) > $groupAuth['messagecontentsize']) {
			return new PW_Service_MessageException('message body too long', -122, null, $groupAuth['messagecontentsize']);
		}
		return true;
	}
	
	function getTimestampOfLatestUnreadMessageOrNotice($uid) {
		$uid = (int)$uid;
		if ($uid < 1) return null;
		$relationsDao = $this->getRelationsDao();
		$timestamp = $relationsDao->getTimestampOfLatestUnreadMessageOrNotice($uid);
		if ($timestamp && $timestamp > 0) return $timestamp;
		return null;
	}
	
	function getRelationByUserIdAndMessageId($userId, $messageId) {
		$userId = (int)$userId;
		$messageId = (int)$messageId;
		if ($userId < 1 || $messageId < 1) return null;
		$relationsDao = $this->getRelationsDao();
		$result = $relationsDao->getRelationByUserIdAndMessageId($userId, $messageId);
		return $result ? $result : null;
	}
}