<?php
!defined('P_W') && exit('Forbidden');
require_once(R_P . 'openapi/library/register.class.php');

define('USER_INVALID_PARAMS',201);
define('USER_INVALID_USERNAME',202);
define('USER_UPDATE_ERROR',203);
define('USER_DELETE_ERROR',204);

class UserApi extends BaseApi {
	var $methodsType = array(
            'get'           => 'GET',
            'getbyname'     => 'GET',
            'add'           => 'POST',
			'update'        => 'POST',
			'delete'        => 'POST',
			'login'         => 'POST',
			'checkauth'     => 'GET',
			'logout'        => 'GET',
			'register'      => 'POST',
			'getusergroups' => 'GET',
        );
	
	/**
	 * ȡûϢ
	 * @param int $uid ûID
	 * @return array
	 */
	function get($uid) {
		if (intval($uid) < 1) {
			return $this->errMessage(USER_INVALID_PARAMS, 'invalid params');
		}
		 
		$userService = L::loadClass('UserService', 'user');
		$userInfo = $userService->get($uid);
		require_once(R_P . 'require/showimg.php');
		$iconInfo = showfacedesign($userInfo['icon'], 1, 'm');
		$userInfo['icon'] = $iconInfo[0];
		$userInfo = $userInfo === null ? array() : $this->_filterField($userInfo);
		return array('userinfo' => $userInfo);
	}
	
	/**
	 * ͨûȡûϢ
	 * @param int $username û
	 * @return array
	 */
	function getbyname($username){
		if (trim($username) == ''){
			return $this->errMessage(USER_INVALID_PARAMS, 'invalid params');
		}
		
		$userService = L::loadClass('UserService', 'user');
		$userInfo = $userService->getByUserName($username);
		require_once(R_P . 'require/showimg.php');
		$iconInfo = showfacedesign($userInfo['icon'], 1, 'm');
		$userInfo['icon'] = $iconInfo[0];
		$userInfo = $userInfo === null ? array() : $this->_filterField($userInfo);
		return array('userinfo' => $userInfo);
	}
	
	/**
	 * ûע
	 * @param string $registerCode 
	 * @return array
	 */
	function register($registerCode) {
      if (trim($registerCode) == ''){
         return $this->errMessage(USER_INVALID_PARAMS, 'invalid params');
      }
      
      $userCodeInfo = encryptString($registerCode,false);

      $json = new Services_JSON(true);
      $userCodeInfo = (array)$json->decode($userCodeInfo, false);

      $userName = pwConvert($userCodeInfo['username'], $this->openApi->charset, 'utf-8');
      $password = md5($userCodeInfo['password']);
      $email = $userCodeInfo['email'];

      $register = new Register($userName,$password,$email);
      $return = $register->execute($userName,$password,$email);
      
      if (is_array($return)){
         return $this->errMessage($return[0],$return[1]);
      }
      return array('userid' => $return);
   }
		

	/**
	 * ɾû
	 * @param int|array $uid ûID
	 * @return int|array
	 */
	function delete($uid) {
		if (empty($uid)){
			return $this->errMessage(USER_INVALID_PARAMS, 'invalid params');
		}
		
		$userService = L::loadClass('UserService', 'user'); 
		$result = $userService->delete($uid);
		if (!$result){
			return $this->errMessage(USER_DELETE_ERROR, 'delete user error');
		}

		return 1;
	}
	
	/**
	 * ûϢϷ
	 * @param string $userCode ûϢ
	 * @return int
	 */
	function checkauth($userCode){
      	if (trim($userCode) == ''){
        	return $this->errMessage(USER_INVALID_PARAMS, 'invalid params');
      	}

      	$userCodeInfo = encryptString($userCode,false);
      	$json = new Services_JSON(true);
      	$userCodeInfo = (array)$json->decode($userCodeInfo, false);

      	$windid = $userCodeInfo['username'];
      	$windpwd = $userCodeInfo['password'];
      
      	if (empty($windid) || empty($windpwd)){
        	return $this->errMessage(USER_INVALID_PARAMS, 'invalid params');
      	}
      
      	$userService = $this->_getUserService();
      	$userInfo = $userService->getByUserName($windid);
		if (empty($userInfo)){
			return $this->errMessage(USER_INVALID_USERNAME, 'invalid username');
		}
		
      	if (md5($windpwd) == $userInfo['password']){
        	return array('userid' => $userInfo['uid']);
      	}
      
      	return -1;
   	}
	
	/**
	 * ȡվȫûϢ
	 * @return array
	 */
	function getusergroups() {
		$query = $this->db->query("SELECT gid,gptype,grouptitle FROM pw_usergroups");
        $userGroup = array();
		while($rt = $this->db->fetch_array($query)) {
            $userGroup[] = $rt;
        }
        
        return array('usergroups' => $userGroup);
	}
		
	/**
	 * ûֶ
	 * @param array $data
	 * @return array
	 */
	function _filterField($data) {
		$filedMap = array(
			'uid'          => $data['uid'],
			'username'     => $data['username'],
			'gender'       => $data['gender'],
			'email'        => $data['email'],
			'icon'         => $data['icon'],
			'registertime' => $data['regdate'],
			'signature'    => $data['signature'],
			'introduce'    => $data['introduce'],
			'oicq'         => $data['oicq'],
			'aliwangwang'  => $data['aliww'],
			'icq'          => $data['icq'],
			'msn'          => $data['msn'],
			'yahoo'        => $data['yahoo'],
			'website'      => !empty($data['website']) ? $data['website'] : null,
            'location'     => $data['location'],
			'birthday'     => $data['bday'],
			'isverified'   => $data['yz'],
			'groupid'      => $data['groupid'],
			'memberid'     => $data['memberid'],
			'groups'       => $data['groups'],
			'honor'        => $data['honor']
		);
		
		return $filedMap;
	}
	
	/**
	 * @return PW_UserService
	 */
	function _getUserService(){
		return L::loadClass('UserService', 'user');
	}
}