<?php
!defined('P_W') && exit('Forbidden');

/**
 * ÿѶ
 * @author zuojie
 *
 */
class Openim_HotStoryApi extends BaseApi {

	var $methodsType = array(
		'get' => 'POST',
	);

	/**
	 * ȡÿѶ
	 * 
	 * Դ̳ҳĸ
	 * @return array
	 */
	function get() {
		return array(
			'headline' => $this->_getHeadline(),
			'image' => $this->_getImage(),
			'article' => $this->_getArticle()
		);
	}
	
	/**
	 * ȡƼ
	 * @return array array(array('url' => 'http://exmaple.com/foo', 'subject' => 'foo', 'summary' => 'bar'))
	 */
	function _getHeadline()
	{
		$tplGetData = $this->_getDataService();
		$partOne = $tplGetData->getData('@̳ҳ', 'ͷ1');
		$partTwo = $tplGetData->getData('¶̬@̳ҳ', 'ͷ2');
		$partThree = $tplGetData->getData('Ƽ@̳ҳ', 'ͷ3');
		$merged = array_merge($partOne, $partTwo, $partThree);
		
		//ɾظ
		$hashArray = array();
		$returned = array();
		foreach ($merged as $value) {
			$url = $this->_getAbsoluteUrl($value['url']);
			$subject = (string)$this->_stripHtml($value['title']);
			$summary = (string)$this->_stripHtml($value['descrip']);
			
			$hash = $this->_getHash(array($url, $subject, $summary)); //ݵhash
			if (!in_array($hash, $hashArray)) { //hashͬΪظ
				$returned[] = array('url' => $url, 'subject' => $subject, 'summary' => $summary);
				$hashArray[] = $hash;
			}
		}
		return $returned;
	}
	
	/**
	 * ȡͼƬ
	 * @return array array(array('url' => 'http://exmaple.com/foo', 'subject' => 'foo', 'imgurl' => 'http://exmaple.com/bar.jpg'))
	 */
	function _getImage()
	{
		$tplGetData = $this->_getDataService();
		$partOne = $tplGetData->getData('õƬ@̳ҳ', 'ͼƬ');
		
		//ɾظ
		$hashArray = array();
		$returned = array();
		foreach ($partOne as $value) {
			$url = $this->_getAbsoluteUrl($value['url']);
			$imageUrl = $this->_getAbsoluteUrl($value['image']);
			$subject = (string)$this->_stripHtml($value['title']);
			$hash = $this->_getHash(array($url, $subject, $imageUrl)); //ݵhash
			if (!in_array($hash, $hashArray)) { //hashͬΪظ
				$returned[] = array('url' => $url, 'subject' => $subject, 'imgurl' => $imageUrl);
				$hashArray[] = $hash;
			}
		}
		return $returned;
	}
	
	/**
	 * ȡͨѶ
	 * @return array array(array('url' => 'http://exmaple.com/foo', 'subject' => 'foo'))
	 */
	function _getArticle()
	{
		$tplGetData = $this->_getDataService();
		$partOne = $tplGetData->getData('@̳ҳ', 'б1');
		$partTwo = $tplGetData->getData('¶̬@̳ҳ', 'б2');
		$partThree = $tplGetData->getData('Ƽ@̳ҳ', 'б3');
		
		$merged = array_merge($partOne, $partTwo, $partThree);
		
		//ɾظ
		$hashArray = array();
		$returned = array();
		foreach ($merged as $value) {
			$url = $this->_getAbsoluteUrl($value['url']);
			$subject = (string)$this->_stripHtml($value['title']);
			
			$hash = $this->_getHash(array($url, $subject)); //ݵhash
			if (!in_array($hash, $hashArray)) { //hashͬΪظ
				$returned[] = array('url' => $url, 'subject' => $subject);
				$hashArray[] = $hash;
			}
		}
		return $returned;
	}
	
	/**
	 * @return PW_tplGetData
	 */
	function _getDataService()
	{
		return L::loadClass('tplgetdata', 'area');
	}
	
	/**
	 * ؾԵַ
	 * @param string $url ԻԵַ
	 * @return string Եַ
	 */
	function _getAbsoluteUrl($url)
	{
		if (parse_url($url, PHP_URL_SCHEME)) {
			return $url;
		}
		global $db_bbsurl;
		return rtrim($db_bbsurl, '/') . '/' . ltrim($url, '/');
	}
	
	/**
	 * ȡݵhashֵ
	 * @param mixed $data
	 * @return string hashֵ
	 */
	function _getHash($data)
	{
		$string = '';
		if (is_array($data)) {
			foreach ($data as $element) {
				$string .= $this->_getHash($element);
			}
		} else {
			$string .= (string)$data;
		}
		return md5($string);
	}
	
	/**
	 * ɾHTML Tag
	 * @param string $string
	 * @return string
	 */
	function _stripHtml($string)
	{
		$string = str_replace('&#160;', ' ', str_replace('&nbsp;', ' ', $string));
		$string = strip_tags($string);
		return $string;
	}
}