<?php
!defined('P_W') && exit('Forbidden');
define('OpenIm_Config_INVALID_PARAMS', 1001);
class Openim_ConfigApi extends BaseApi {
	var $methodsType = array(
        'setisopen' => 'POST',
		'setconfig' => 'POST'
    );
    
	/*
 	 * set openim service configure if open
	 * @param string $key
	 * @param string $value
 	 */
    function setisopen($value = 0) {
        if (intval($value) < 0){
    		return $this->errMessage(OpenIm_Config_INVALID_PARAMS, 'invalid params');
    	}
        require_once(R_P . 'admin/cache.php');
		setConfig('db_openim_isopen', $value);
		updatecache_c();
		return 1;
    }
    
    /*
 	 * set openim service configure
	 * @param string $key
	 * @param string $value
 	 */
    function setconfig($value){
    	if (empty($value)){
    		return $this->errMessage(OpenIm_Config_INVALID_PARAMS, 'invalid params');
    	}
    	require_once(R_P . 'admin/cache.php');
		setConfig('db_openim_config', $value);
		updatecache_c();
		return 1;	
    }
}