<?php
!defined('P_W') && exit('Forbidden');

define('GROUP_INVALID_PARAMS',301);
class GroupApi extends BaseApi{
	var $methodsType = array(
            'getgroups'      => 'GET',
            'get'            => 'GET',
            'getusergroups'  => 'GET'
        );

	/**
     * ȡȫȺϢ
	 * @param int $offset
	 * @param int $limit
	 * @return array
     */
    function getgroups($offset = 1, $limit = 20){
		global $db_bbsurl,$attachpath;
		$offset = ($offset - 1) * $limit;
        $sqlStr = "SELECT * FROM pw_colonys" . S::sqlLimit($offset,$limit);
        $query = $this->db->query($sqlStr);
        $groups = array();
        while($g = $this->db->fetch_array($query)) {
            $g['cnimg'] = $g['cnimg'] ? $attachpath . '/cn_img/' . $g['cnimg'] : $db_bbsurl . '/images/apps/groupnopic.gif';
            $groups[] = $g;
        }
        
        $count = $this->db->get_value("SELECT count(*) FROM pw_colonys");
        return array('count' => $count, 'groups' => $groups);
    }
    
	/**
     * ȡĳȺϢ
	 * @param int $gid
	 * @return array
     */
    function get($gid){
        global $db_bbsurl,$attachpath;
		if (intval($gid) <= 0) {
            return $this->errMessage(Group_INVALID_PARAMS,'invalid params');
        }
        $groupInfo = array();
        $groupInfo = $this->db->get_one("SELECT * FROM pw_colonys WHERE id=" . S::sqlEscape($gid));
        $query = $this->db->query("SELECT cm.uid,cm.username,cm.realname,cm.ifadmin,cm.gender,cm.tel,cm.email,cm.colonyid,cm.address,cm.introduce,cm.addtime,cm.lastvisit,cm.lastpost FROM pw_cmembers cm WHERE colonyid=" . S::sqlEscape($gid));
        $groupInfo['cnimg'] = $groupInfo['cnimg'] ? $attachpath . '/cn_img/' . $groupInfo['cnimg'] : $db_bbsurl . '/images/apps/groupnopic.gif';
        $groupInfo['members'] = array();
        while($m = $this->db->fetch_array($query)) {
            $groupInfo['members'][] = $m;
        }
        
        return array('group' => $groupInfo);
    }
    
	/**
     * ȡûȺ
	 * @param int $uid
	 * @return array
     */
    function getusergroups($uid){
        if (intval($uid) <= 0) {
            return $this->errMessage(Group_INVALID_PARAMS,'invalid params');
        }
        $groups['groups'] = array();
        $query = $this->db->query("SELECT cn.* FROM pw_cmembers cm LEFT JOIN pw_colonys cn ON cn.id=cm.colonyid WHERE cm.uid=" . S::sqlEscape($uid));
        while ($rt = $this->db->fetch_array($query)) {
            $groups['groups'][] = $rt;
        }
        return $groups;
    }
}