<?php
!function_exists('readover') && exit('Forbidden');

class PW_OpenImUser {
	/**
	 * ͬͷƽ̨
	 * @param int $windid 
	 * @param string $avatarUrl ͷԵַ
	 * @param string $db_sitehash
	 * @param string $db_siteownerid
	 * @param string $charset
	 * @return bool ɹ
	 */
	
	function syncAvatarToPlatform($winduid, $avatarUrl, $db_sitehash, $db_siteownerid, $charset){
		L::loadClass('client', 'utility/platformapisdk', false);
		$client = new PlatformApiClient($db_sitehash, $db_siteownerid, $charset);
		$jsonResultFromPlatform = $client->get('openim.user.updateim', array('bbsuId' => $winduid, 'icon' => $avatarUrl, 'version' => '1.2', 'format' => 'json'), true);
		require_once R_P . 'lib/utility/json.class.php';
		$jsonService = new Services_JSON(true);
		$phpResultFromPlatform = $jsonService->decode($jsonResultFromPlatform);
		if (is_null($phpResultFromPlatform)) {
			return false;
		}
		$phpResultFromPlatform = (array) pwConvert($phpResultFromPlatform, $charset, 'utf8');
		if (!$phpResultFromPlatform || !isset($phpResultFromPlatform['code']) || intval($phpResultFromPlatform['code']) != 0) {
			return false;
		}
		return true;
	}
	
	
	/**
	 * ȡһ֪ͨƽ̨ûPMʱ
	 * @param int $uid
	 * @return int
	 */
	function getPmNotifyTimestamp($uid) {
		$uid = (int)$uid;
		if ($uid <= 0) {
			return false;
		}
		$openImUserDb = $this->_getOpenImUserDb();
		$openImUserInfo = $openImUserDb->get($uid);
		if (!$openImUserInfo) {
			return 0;
		}
		return $openImUserInfo['pmnotifytimestamp'];
	}
	
	function setPmNotifyTimestamp($uid, $timestamp) {
		$uid = (int)$uid;
		$timestamp = (int)$timestamp;
		if ($uid <= 0 || $timestamp < 0) {
			return false;
		}
		$openImUserDb = $this->_getOpenImUserDb();
		return $openImUserDb->update($uid, array('pmnotifytimestamp' => $timestamp));
	}
	/**
	 * ûǷʹùOpenIM
	 * @param int $winduid
	 * @return boolean
	 */
	function hasUsedService($winduid) {
		$winduid = (int)$winduid;
		if ($winduid < 0) return false;
		$openImUserDb = $this->_getOpenImUserDb();
		return $openImUserDb->get($winduid) ? true : false;
	}
	
	/**
	 * ûʹùOpenIM
	 * @param int $winduid
	 * @return NULL|boolean
	 */
	function setHasUsedService($winduid) {
		$winduid = (int)$winduid;
		if ($winduid < 0) return null;
		if ($this->hasUsedService($winduid)) return false;
		$openImUserDb = $this->_getOpenImUserDb();
		$openImUserDb->insert($winduid, array());
		return true;
	}
	
	/**
	 * @return PW_OpenImUserDB
	 */
	function _getOpenImUserDb() {
		return L::loadDB('OpenImUser', 'openim');
	}
}