<?php
!function_exists('readover') && exit('Forbidden');
require_once(R_P . 'require/exception.php');
/**
 * Ѷ
 * @author zuojie
 *
 */
class PW_OpenImPush {
	var $_platformApiClient;
	
	/**
	 * ȡƽ̨ͻ
	 * @return PlatformApiClient
	 */
	function _getPlatformApiClient() {
		if ($this->_platformApiClient) {
			return $this->_platformApiClient;
		}
		L::loadClass('client', 'utility/platformapisdk', false);
		global $db_sitehash, $db_siteownerid, $charset;
		$this->_platformApiClient = new PlatformApiClient($db_sitehash, $db_siteownerid, $charset);
		return $this->_platformApiClient;
	}
	
	/**
	 * ͵ϵͳϢ
	 * @param string $subject
	 * @param string $link
	 * @param string $body
	 * @return boolean ɹ
	 */
	function pushPopNotice($subject, $link, $body) {
		$subject = (string)$subject;
		$link = (string)$link;
		$body = (string)$body;
		if ($subject == "" || $link == "" || $body == "") {
			return false;
		}
		
		$client = $this->_getPlatformApiClient();
		$client->setFormat('json');
		$jsonResult = $client->post('openim.popnotice.push', 
			array('subject' => $subject, 'link' => $link, 'body' => $body), 
			true
		);
		
		if ($jsonResult) {
			return $this->_parseJsonResult($jsonResult);
		}
		return false;
	}
	/**
	 * ͵ÿѶƼ
	 * @param string $subject
	 * @param string $link
	 * @param string $summary
	 * @return boolean ɹ
	 */
	function pushHotStoryHeadline($subject, $link, $summary) {
		$subject = (string)$subject;
		$link = (string)$link;
		$summary = (string)$summary;
		if ($subject == "" || $link == "" || $summary == "") {
			return false;
		}
		
		$client = $this->_getPlatformApiClient();
		$client->setFormat('json');
		$jsonResult = $client->post('openim.hotstory.push', 
			array('position' => 'headline', 'subject' => $subject, 'link' => $link, 'summary' => $summary), 
			true
		);
		
		if ($jsonResult) {
			return $this->_parseJsonResult($jsonResult);
		}
		return false;
	}
	
	/**
	 * ͵ÿѶͼƬ
	 * @param string $subject
	 * @param string $link
	 * @param string $imageUrl
	 * @return boolean ɹ
	 */
	function pushHotStoryImage($subject, $link, $imageUrl) {
		$subject = (string)$subject;
		$link = (string)$link;
		$imageUrl = (string)$imageUrl;
		if ($subject == "" || $link == "" || $imageUrl == "") {
			return false;
		}
		
		$client = $this->_getPlatformApiClient();
		$client->setFormat('json');
		$jsonResult = $client->post('openim.hotstory.push', 
			array('position' => 'image', 'subject' => $subject, 'link' => $link, 'imageurl' => $imageUrl), 
			true
		);
		
		if ($jsonResult) {
			return $this->_parseJsonResult($jsonResult);
		}
		return false;
	}
	
	/**
	 * ͵ÿѶͨѶ
	 * @param string $subject
	 * @param string $link
	 * @param string $imageUrl
	 * @return boolean ɹ
	 */
	function pushHotStoryArticle($subject, $link) {
		$subject = (string)$subject;
		$link = (string)$link;
		if ($subject == "" || $link == "") {
			return false;
		}
		
		$client = $this->_getPlatformApiClient();
		$client->setFormat('json');
		$jsonResult = $client->post('openim.hotstory.push', 
			array('position' => 'article', 'subject' => $subject, 'link' => $link), 
			true
		);
		
		if ($jsonResult) {
			return $this->_parseJsonResult($jsonResult);
		}
		return false;
	}
	
	/**
	 * ƽ̨صjsonַǷɹ
	 * @param string $jsonString
	 * @return boolean
	 */
	function _parseJsonResult($jsonString) {
		global $charset;
		require_once(R_P. 'lib/utility/json.class.php');
		$jsonService = new Services_JSON(SERVICES_JSON_LOOSE_TYPE);
		$phpResult = $jsonService->decode($jsonString);
		$phpResult = (array) pwConvert($phpResult, $charset, 'utf8');
		if ($phpResult['code'] == '0') { //ɹ
			return true;
		}
		if (isset($phpResult['content']['msg']) && isset($phpResult['code'])) {
			return new PW_Exception($phpResult['content']['msg'], (int)$phpResult['code']);
		}
		return new PW_Exception('δ֪', -1);
	}
}