<?php
!defined('P_W') && exit('Forbidden');
define('USERNAME_LENGTH_ERROR',211);
define('USERNAME_LOWER_ERROR',212);
define('USERNAME_SAME_ERROR',213);
define('USERNAME_ILLEGAL_ERROR',214);

define('PASSWORD_ILLEGAL_ERROR',215);

define('EMAIL_SAME_ERROR',216);
define('EMAIL_ILLEGAL_ERROR',217);

define('SYSTEM_ERROR',218);

class Register{
	var $db;
	var $data;
	var $illegalChar;
	var $uid;
	
	function Register($username,$password,$email) {
		global $db;
		$this->db = & $db;
		$this->data = array(
			'username' => $username,
			'password' => $password,
			'email' => $email
		);
		$this->illegalChar = array(
			"\\", '&', ' ', "'", '"', '/', '*', ',', '<', '>', "\r", "\t", "\n", '#', '%', '?', ''
		);
	}
	
	function execute() {
		$checkNameReturn = Register::checkName($this->data['username']);
		if ($checkNameReturn !== true){
			return $checkNameReturn;
		}
		
		$checkPwdReturn = Register::checkPwd($this->data['password']);
		if ($checkPwdReturn !== true){
			return $checkPwdReturn;
		}
		
		$checkEmailReturn = Register::checkEmail($this->data['email']);
		if ($checkEmailReturn !== true){
			return $checkEmailReturn;
		}
		
		require_once (R_P . 'uc_client/uc_client.php');
		if (($winduid = uc_user_register($this->data['username'], $this->data['password'], $this->data['email'])) < 0) {
			switch ($winduid) {
				case -1:
					return array(USERNAME_ILLEGAL_ERROR,'illegal username error');
					break;
				case -2:
					return array(USERNAME_SAME_ERROR,'same username error');
					break;
				case -3:
					return array(EMAIL_ILLEGAL_ERROR,'illegal username error');
					break;
				case -4:
					return array(EMAIL_SAME_ERROR,'illegal username error');
					break;
				default:
					return array(SYSTEM_ERROR,'system error');
			}
		}
		$this->uid = $winduid;
		$this->_setMemberid();
		$this->_setGroupid();
		$this->_insertUser();
		
		return $winduid;
	}
	
	function _insertUser() {
		global $timestamp, $onlineip, $credit;
		$pwSQL = S::sqlSingle(array(
			'uid' => $this->uid,
			'username' => $this->data['username'],
			'password' => $this->data['password'],
			'email' => $this->data['email'],
			'groupid' => $this->data['groupid'],
			'memberid' => $this->data['memberid'],
			'regdate' => $timestamp,
			'newpm' => 0
		));
		$this->db->update("REPLACE INTO pw_members SET $pwSQL");
		$pwSQL = S::sqlSingle(array(
			'uid' => $this->uid,
			'postnum' => 0,
			'lastvisit' => $timestamp,
			'thisvisit' => $timestamp,
			'onlineip' => $onlineip
		));		
		$this->db->pw_update(
			'SELECT uid FROM pw_memberdata WHERE uid=' . S::sqlEscape($this->uid),
			'UPDATE pw_memberdata SET ' . $pwSQL . ' WHERE uid=' . S::sqlEscape($this->uid),
			'INSERT INTO pw_memberdata SET ' . $pwSQL
		);
		
		require_once (R_P . 'require/credit.php');
		$credit->addLog('reg_register', L::reg('rg_regcredit'), array(
			'uid' => $this->uid,
			'username' => stripslashes($this->data['username']),
			'ip' => $onlineip
		));
		$credit->sets($this->uid, L::reg('rg_regcredit'), false);
		$credit->runsql();
		
		$this->db->update("UPDATE pw_bbsinfo SET newmember=" . S::sqlEscape($this->data['username']) . ",totalmember=totalmember+1 WHERE id='1'");
	}
	
	function _setMemberid() {
		global $db_upgrade;
		is_array($upgradeset = unserialize($db_upgrade)) || $upgradeset = array();
		$usercredit = L::reg('rg_regcredit');
		isset($usercredit['rvrc']) && $usercredit['rvrc'] *= 10;
		require_once(R_P . 'require/functions.php');
		$this->data['memberid'] = getmemberid(CalculateCredit($usercredit, $upgradeset));
	}
	
	function _setGroupid() {
		if ($this->data['groupid'] == 0) {
			$this->data['groupid'] = L::reg('rg_ifcheck') ? 7 : -1;
		}
	}
	
	/**
	 * @static
	 */
	function checkName($regname) {
		if (!Register::checkNameLen(strlen($regname))) {
			return array(USERNAME_LENGTH_ERROR,'username length error');
		}
		
		if (str_replace($this->illegalChar, '', $regname) != $regname) {
			return array(USERNAME_ILLEGAL_ERROR,'illegal username error');
		}
		
		if (!L::reg('rg_rglower') && !Register::checkRglower($regname)) {
			return array(USERNAME_LOWER_ERROR,'username lower error');
		}
		
		if (S::inArray(strtolower($regname), array(
			'guest',
			'system'
		))) {
			return array(USERNAME_ILLEGAL_ERROR,'illegal username error');
		}
		
		$banname = explode(',', L::reg('rg_banname'));
		foreach ($banname as $key => $value) {
			if ($value !== '' && strpos($regname, $value) !== false) {
				return array(USERNAME_ILLEGAL_ERROR,'illegal username error');
			}
		}
		
		require_once (R_P . 'require/functions.php');
		if ($regname !== Sql_cv($regname)) {
			return array(USERNAME_ILLEGAL_ERROR,'illegal username error');
		}
		
		return true;
	}
	
	/**
	 * @static
	 */
	function checkNameLen($len) {
		list($regminname, $regmaxname) = explode("\t", L::reg('rg_namelen'));
		return ($len >= $regminname && $len <= $regmaxname);
	}
	
	/**
	 * @static
	 */
	function checkPwd($regpwd) {
		if (str_replace($this->illegalChar, '', $regpwd) != $regpwd) {
			return array(PASSWORD_ILLEGAL_ERROR,'illegal password error');
		}
		
		return true;
	}
	
	/**
	 * @static
	 */
	function checkEmail($regemail) {
		if (empty($regemail) || !preg_match("/^[-a-zA-Z0-9_\.]+\@([0-9A-Za-z][0-9A-Za-z-]+\.)+[A-Za-z]{2,5}$/", $regemail)) {
			return array(EMAIL_ILLEGAL_ERROR,'illegal email error');
		}
				
		$email_check = $this->db->get_one('SELECT COUNT(*) AS count FROM pw_members WHERE email=' . S::sqlEscape($regemail));
		if (intval($email_check['count'])) {
			return array(EMAIL_SAME_ERROR,'same email error');
		}
		return true;
	}
	
	/**
	 * @static
	 */
	function checkRglower($username) {
		global $db_charset;
		
		$namelen = strlen($username);
		for ($i = 0; $i < $namelen; $i++) {
			if (ord($username[$i]) > 127) {
				$i += 'utf-8' != $db_charset ? 1 : 2;
			} else {
				if (ord($username[$i]) >= 65 && ord($username[$i]) <= 90) {
					return false;
				}
			}
		}
		return true;
	}
}