<?php 
!defined('P_W') && exit('Forbidden');

define('API_SIGN_ERROR', 1);
define('API_CLASS_NOT_EXISTS', 2);
define('API_METHOD_NOT_EXISTS', 3);
define('API_HTTP_METHOD_NOT_MATCH', 4);

require_once R_P . 'lib/utility/json.class.php';
require_once R_P . 'openapi/library/apixml.class.php';
require_once R_P . 'openapi/library/base.class.php';

class OpenApi {
    var $charset;
	var $apikey;
	var $classdb;
    var $format;
    var $json;

    function OpenApi($siteownerid,$charset) {
		$this->charset     = $charset;
		$this->apikey      = $siteownerid;
        $this->classdb     = array();
        $this->format      = 'json';
		$this->json        = new Services_JSON(true);
    }

    function response($requestObject) {
    	$request = $requestObject->getRequest();
    	if (function_exists('get_magic_quotes_gpc') && get_magic_quotes_gpc()) {
    		$request = $this->_stripSlash($request);
    	}

        if (isset($request['format']) && in_array(strtolower($request['format']),array('xml','json'))){
            $this->setFormat($request['format']);
        }
        
        ksort($request);
        reset($request);
        $arg = '';
        foreach ($request as $key => $value) {
            if ($value && $key != 'sign') {
                $arg .= "$key=$value&";
            }
        }
        
        header("content-type:application/" . $this->format);
        if (empty($this->apikey) || md5($arg . $this->apikey) != $request['sign']) {
            return $this->errMessage(API_SIGN_ERROR, 'Error Sign');
        }
        
        $callback = $request['callback'];
        $params   = isset($request['params']) ? $this->json->decode($request['params']) : array();
        
        $params = (array)$params;
        $requestCharset = '';
		if ($params && isset($request['charset'])) {
            $params = pwConvert($params, $this->charset, $request['charset']);
			$requestCharset = $request['charset'];
        }
        S::slashes($params);
        return $this->callback($callback, $params, $requestCharset);
    }

    function callback($callback, $params, $requestCharset) {
        $callbackArr = explode('.', $callback);
        
        $method = array_pop($callbackArr);
        $classFile  = array_pop($callbackArr);
        $classDir = !empty($callbackArr) ? str_replace('.', '/', implode('.', $callbackArr)) . '/' : '';
    	$class = $classDir ? str_replace('/','_',$classDir) . $classFile : $classFile;
    	$class = $class . 'Api';
    	
 		$classPath = R_P . 'openapi/api/' . $classDir . strtolower($classFile) . '.class.php';
 		if (!isset($this->classdb[$class])) {
			if (!file_exists($classPath)) {
                return $this->errMessage(API_CLASS_NOT_EXISTS, "Class($class) Not Exists");
            }
            require_once S::escapePath($classPath);
            $this->classdb[$class] = new $class($this);
        }
        
        if (!method_exists($this->classdb[$class], $method)) {
            return $this->errMessage(API_METHOD_NOT_EXISTS, "Method($method of $class) Not Exists");
        }
		$httpMethod = isset($this->classdb[$class]->methodsType[$method]) ? $this->classdb[$class]->methodsType[$method] : 'GET';
        if (!isAllowMethod($httpMethod)){
            return $this->errMessage(API_HTTP_METHOD_NOT_MATCH, "HTTP Method($method of $class) Not match");
        }
        
        !is_array($params) && $params = array();
        $return = call_user_func_array(array(&$this->classdb[$class], $method), $params);
		return $this->_format($return,$requestCharset);
    }
    
    function errMessage($errCode, $errMesssage){
    	return $this->_format(array('errCode' => $errCode, 'errMessage' => $errMesssage));
    }
    
    function setFormat($format){
        $this->format = strtolower($format);
    }
    
    function _format($data,$requestCharset = '') {
		if (!empty($requestCharset)){
			$data = pwConvert($data,$requestCharset,$this->charset);
		}
    	$dataPlus = array('response' => $data);
		$charset = empty($requestCharset) ? $this->charset : $requestCharset;
        if ($this->format == 'xml'){
            $array2xml = new Array2Xml($dataPlus,$charset);
            return $array2xml->getXml();
        }
        return $this->json->encode($dataPlus);
    }
    
    function _stripSlash($param) {
        if (is_array($param)) {
            foreach ($param as $key => $value) {
                $param[$key] = $this->_stripSlash($value);
            }
        } else {
            $param = stripslashes($param);
        }
        return $param;
    }
}