<?php
!defined('P_W') && exit('Forbidden');

define('WEIBO_INVALID_PARAMS',801);
define('WEIBO_DELETE_ERROR',802);
define('WEIBO_USER_HAS_EXIST',803);
define('WEIBO_USER_ALREADY_FLOLLOW',804);
define('WEIBO_USER_IN_PRIVACY',805);
define('WEIBO_USER_NOT_FLOLLOW',806);
define('WEIBO_COMMENT_SEND_FAIL',807);

class WeiboApi extends BaseApi {	
	var $weiboService;
	var $methodsType = array(
			'send'               => 'POST',
			'getfollowedweibos'  => 'GET',
			'getuserweibos'      => 'GET',
			'getreferweibos'     => 'GET',
			'delete'             => 'POST',
			'update'             => 'POST',
			'get'                => 'GET',
			'getallweibos'       => 'GET',
			'getfollows'         => 'GET',
			'getfans'            => 'GET',
			'follow'             => 'POST',
			'unfollow'           => 'POST',
			'comment'			 => 'POST',
        );
		
	function init() {
        parent::init();
        $this->weiboService = $this->_getWeiboService();
    }
	
	/**
     * 
     * @param int $uid
     * @param string $content
	 * @param string $type
	 * @param int $typeid
	 * @param array $extra
     * @return array
     */
	function send($uid, $content, $type = 'weibo' ,$typeid = 0, $extra = array()) {
		if (intval($uid) <= 0 || '' == trim($content)){
			return $this->errMessage(WEIBO_INVALID_PARAMS,'invalid params');
		}
		
		$weiboId = $this->weiboService->send($uid, $content, $type, $typeid, $extra);
		return array('weiboid' => $weiboId);
	}
	
	/**
     * ȡûעĺѵĵ
     * @param int $uid
	 * @param int $offset
	 * @param int $limit
     * @return array
     */
	function getfollowedweibos($uid,$offset = 1,$limit = 20){
		if (intval($uid) <= 0){
			return $this->errMessage(WEIBO_INVALID_PARAMS,'invalid params');
		}
		$result = $this->weiboService->getUserAttentionWeibosNotMe($uid,$offset,$limit);
		$weibos = array();
		foreach ($result as $value){
			unset($value['password']);
			if (isset($value['extra']['photos'])) {
				foreach ($value['extra']['photos'] as $item) {
					$_photos[] = $item;
				}
				$value['extra']['photos'] = $_photos;
			}
			$weibos[] = $value; 
		}
		$count = $this->weiboService->getUserAttentionWeibosNotMeCount($uid);
		return array('count' => $count,'weibos' => $weibos);
	}
	
	
	/**
     * ȡû
     * @param int $uid
	 * @param int $offset
	 * @param int $limit
     * @return array
     */
	function getuserweibos($uid,$offset = 1,$limit = 20){
		if (intval($uid) <= 0){
			return $this->errMessage(WEIBO_INVALID_PARAMS,'invalid params');
		}
		$result = $this->weiboService->getUserWeibos($uid, $offset, $limit);
		$weibos = array();
		foreach ($result as $value){
			unset($value['password']);
			if (isset($value['extra']['photos'])) {
				foreach ($value['extra']['photos'] as $item) {
					$_photos[] = $item;
				}
				$value['extra']['photos'] = $_photos;
			}
			$weibos[] = $value; 
		}
		$count = $this->weiboService->getUserWeibosCount($uid);
		return array('count' => $count,'weibos' => $weibos);
	}
	
	
	/**
     * ȡᵽû
     * @param int $uid
	 * @param int $offset
	 * @param int $limit
     * @return array
     */
	function getreferweibos($uid, $offset = 1, $limit = 20){
		if (intval($uid) <= 0){
			return $this->errMessage(WEIBO_INVALID_PARAMS,'invalid params');
		}
		
		$result = $this->weiboService->getRefersToMe($uid,$offset,$limit);
		$weibos = array();
		foreach ($result as $value){
			unset($value['password']);
			if (isset($value['extra']['photos'])) {
				foreach ($value['extra']['photos'] as $item) {
					$_photos[] = $item;
				}
				$value['extra']['photos'] = $_photos;
			}
			$weibos[] = $value; 
		}
		$count = $this->weiboService->getRefersToMeCount($uid);
		return array('count' => $count,'weibos' => $weibos);
	}
	
	
	/**
     * ɾ
     * @param int|array $mids
     * @return int|array
     */
	function delete($mids){
		$return = $this->weiboService->deleteWeibos($mids);
		if ($return) return 1;
		return $this->errMessage(WEIBO_DELETE_ERROR,'weibo delete error');
	}

	/**
     * 
     * @param int|array $mid
     * @param array $data
	 * @return int|array
     */
	function update($mid, $data) {
		$mid = intval($mid);
		if ($mid < 1 || !is_array($data)) {
			return $this->errMessage(WEIBO_INVALID_PARAMS,'invalid params');
		}
		$this->weiboService->update($data, $mid);
		return 1;
	}
	
	/**
     * ȡϸϢ
     * @param int|array $mids
     * @param int $comment Ϊ1ȡ20
     * @return array
     */
	function get($mids, $comments = 0) {
		require_once(R_P . 'require/showimg.php');
		if (empty($mids)){
			return $this->errMessage(WEIBO_INVALID_PARAMS,'invalid params');
		}
		$weiboInfo = $this->weiboService->getWeibosByMid($mids);
		foreach ($weiboInfo as $key=>$item) {
			$item['extra'] = unserialize($item['extra']);
			if ($comments == 0) continue;
			
			$wiboCommentService = $this->_getWiboCommentService();
			$item['commentcount'] = $wiboCommentService->getCommentsCountByMid($item['mid']);
			$data = $wiboCommentService->getCommentsByMid($item['mid']);
			$item['comment'] = $this->_buildComment($data);
		}
		return count($weiboInfo) > 1 ? array('weibos' => $weiboInfo) : array('weibo' => $weiboInfo[0]);
	}
	
	/**
     * ȡȫվ
     * @param int $offset
     * @param int $limit
     * @return array
     */
	function getallweibos($offset = 1, $limit = 20) {
		$result = $this->weiboService->getWeibos($offset, $limit);
		
		$weibos = array();
		foreach ($result as $value){
			unset($value['password']);
			if (isset($value['extra']['photos'])) {
				foreach ($value['extra']['photos'] as $item) {
					$_photos[] = $item;
				}
				$value['extra']['photos'] = $_photos;
			}
			$weibos[] = $value; 
		}
		$count = $this->weiboService->getWeibosCount();
		return array('count' => $count,'weibos' => $weibos);
	}
	
	
	/**
     * ȡûעĺ
     * @param int $uid
     * @param int $offset
     * @param int $limit
     * @return array
     */
	function getfollows($uid, $offset = 1, $limit = 20){
		if (intval($uid) <= 0){
			return $this->errMessage(WEIBO_INVALID_PARAMS,'invalid params');
		}
		
		$attentionService = $this->_getAttentionService();
		$return = $attentionService->getFollowListInPage($uid, $offset, $limit);
		$follows = array();
		foreach ($return as $value){
			$follows[] = $value;
		}
		$count = $attentionService->countFollows($uid);
		return array('count' => $count,'follows' => $follows);
	}
	
	/**
     * ȡעûĺ
     * @param int $uid
     * @param int $offset
     * @param int $limit
     * @return array
     */
	function getfans($uid, $offset = 1, $limit = 20){
		if (intval($uid) <= 0){
			return $this->errMessage(WEIBO_INVALID_PARAMS,'invalid params');
		}
				
		$attentionService = $this->_getAttentionService();
		$return = $attentionService->getFansListInPage($uid, $offset, $limit);
		foreach ($return as $value){
			$fans[] = $value;
		}
		$count = $attentionService->countFans($uid);
		return array('count' => $count,'fans' => $fans);
	}
	
	/**
     * ע
     * @param int $uid
     * @param int $touid
     * @return array|int
     */
	function follow($uid,$touid){
		if (intval($uid) <= 0 || intval($touid) <= 0){
			return $this->errMessage(WEIBO_INVALID_PARAMS,'invalid params');
		}
		
		$attentionService = $this->_getAttentionService();
		if ($attentionService->isFollow($uid, $touid)) {
			return $this->errMessage(WEIBO_USER_ALREADY_FLOLLOW,'attention already exists');
		}
		
		if ($attentionService->isInBlackList($touid, $uid)) {
			return $this->errMessage(WEIBO_USER_IN_PRIVACY,'user is in privacy');
		}
		
		$attentionService->addFollow($uid, $touid);
		return 1;
	}
	
	/**
     * ע
     * @param int $uid
     * @param int $friendid
     * @return array|int
     */
	function unfollow($uid, $friendid){
		if (intval($uid) <= 0 || intval($friendid) <= 0){
			return $this->errMessage(WEIBO_INVALID_PARAMS,'invalid params');
		}
		
		$attentionService = $this->_getAttentionService();
		if (!$attentionService->isFollow($uid, $friendid)) {
			return $this->errMessage(WEIBO_USER_NOT_FLOLLOW,'user is not in follows');
		}
		$attentionService->delFollow($uid,$friendid);
		return 1;
	}
	
	/**
	 * ȡ΢
	 * @param Integer $mid
	 * @param Integer $offset
	 * @param Integer $limit
	 * @return Array
	 */
	function getcomments($mid, $offset=1, $limit=20) {
		require_once(R_P . 'require/showimg.php');
		if (intval($mid) <= 0){
			return $this->errMessage(WEIBO_INVALID_PARAMS,'invalid params');
		}
		
		$data = array();
		$wiboCommentService = $this->_getWiboCommentService();
		$data = $wiboCommentService->getCommentsByMid($mid, $offset, $limit);
		$comment = $this->_buildComment($data);
		
		$count = $wiboCommentService->getCommentsCountByMid($mid);
		return array('count' => $count, 'comment' => $comment);
	}
	
	/**
	 * ΢
	 * @param Integer $uid
	 * @param Integer $mid
	 * @param Integer $content
	 * @param Array $extra
	 * @return Integer
	 */
	function comment($uid,$mid,$content,$extra = array()) {
		if (intval($mid) <= 0 || intval($uid) <=0 || empty($content)){
			return $this->errMessage(WEIBO_INVALID_PARAMS,'invalid params');
		}
		$wiboCommentService = $this->_getWiboCommentService();
		if (!$wiboCommentService->comment($uid,$mid,$content,$extra)) {
			return $this->errMessage(WEIBO_COMMENT_SEND_FAIL, 'comment fail');
		}
		
		return 1;
	}
	
	function _buildComment($data) {
		$comment = array();
		foreach ($data as $key=>$item) {
			$comment[] = array(
				'mid' => $item['mid'],
				'cid' => $item['cid'],
				'uid' => $item['uid'],
				'username' => $item['username'],
				'content' => $item['content'],
				'extra' => $item['extra'],
				'postdate' => $item['postdate'],
			);
		}
		
		return $comment;
	}
	
	/**
	 * 
	 *@return PW_Comment
	 */
	function _getWiboCommentService() {
		return L::loadClass('comment', 'sns');
	}
	
	/**
	 * @return PW_Weibo
	 */
	function _getWeiboService() {
		return L::loadClass('weibo', 'sns');
	}
	
	/**
	 * @return PW_Attention
	 */
	function _getAttentionService(){
		return L::loadClass('Attention', 'friend');
	}
}