<?php
!defined('P_W') && exit('Forbidden');

define('CONTACTS_INVALID_PARAMS', 601);

class Openim_ContactApi extends BaseApi {

	var $methodsType = array(
		'getlist' => 'POST',
		'addfollow'=> 'POST',
	);

	/**
	 * ȡûϵid
	 * @param int $userid
	 * @return array array(int, int)
	 */
	function getlist($userid) {
		$userId = (int)$userid;
		if ($userid < 1) {
			return $this->errMessage(CONTACTS_INVALID_PARAMS, 'invalid params');
		}

		$contacts = array();
		
		//ȡûע
		$attentionService = L::loadClass('Attention', 'friend');
		$followingUsers = $attentionService->getFollowList($userId, 1, 1000); //max 1000
		if ($followingUsers && is_array($followingUsers)) {
			foreach ($followingUsers as $followingUser) {
				$contacts[] = (int)$followingUser['friendid'];
			}
		}
		
		//ȡûĺ
		$friendService = L::loadClass('Friend', 'friend');
		$friends = $friendService->getFriendsByUid($userId);
		if ($friends && is_array($friends)) {
			foreach ($friends as $friend) {
				$contacts[] = (int)$friend['friendid'];
			}
		}
		
		//ɾظ
		$contacts = array_unique($contacts);
		//
		sort($contacts);
		return $contacts;
	}


   /**
	 * ӹע
	 * @param int $userId
	 * @param int $followId
	 * @return boolean
	 */
	function addfollow($userId, $followId) {
		$attentionService = L::loadClass('Attention', 'friend');
		if ($attentionService->isFollow($userId, $friendId)) return true;

		return $attentionService->addFollow($userId, $followId);
	}
}