<?php !function_exists('readover') && exit('Forbidden');
class PW_OpenIm {
	var $platformApiClient;
	
	function initPlatformApiClient($db_sitehash,$db_siteownerid, $charset = null){
		$this->_loadPlatformApiSdk();
	    $this->platformApiClient = new PlatformApiClient($db_sitehash, $db_siteownerid, $charset);
	}
	
	/**
	 * ȡؿͻҳַ
	 * @return string
	 */
	function getDownloadPageUrl(){
	    return $this->platformApiClient->buildPageUrl(0, 'openim.site.downloadpage', array('yunliaoversion' => '2.0'), true);
	}
	
	function _loadPlatformApiSdk(){
		require_once(R_P . 'lib/utility/platformapisdk/client.class.php');
	}
	
	function _getSiteId() {
		global $charset;
		$jsonResult = $this->platformApiClient->get('openim.site.getmyid', array('format' => 'json'), true);
		if ($jsonResult) {
			//JSONתΪPHP
			require_once R_P . 'lib/utility/json.class.php';
			$jsonService = new Services_JSON(SERVICES_JSON_LOOSE_TYPE);
			$phpResult = $jsonService->decode($jsonResult);
			//JSONַתΪر
			$phpResult = pwConvert($phpResult, $charset, 'utf8');
			if ($phpResult && $phpResult['code'] == '0') {
				return (int)$phpResult['content']['siteId'];
			}
		}
		return null;
	}
	
	function getSiteId()
	{
		global $db_app_siteid;
		if ($db_app_siteid) {
			return $db_app_siteid;
		} else {
			$siteId = $this->_getSiteId();
			$db_app_siteid = $siteId;
			require_once(R_P . 'admin/cache.php');
			setConfig('db_app_siteid', $siteId);
			updatecache_c();
			return $siteId;
		}
	}
}