<?php
!defined('P_W') && exit('Forbidden');

/**
 * @author zuojie
 *
 */
class PW_OpenImUserDB extends BaseDB {
	var $_tableName = 'pw_openimuser';
	var $_primaryKey = 'uid';
	/**
	 * @param int $userId
	 * @return array
	 */
	function get($userId) {
		return $this->_get($userId);
	}

	/**
	 * @param int $userId
	 * @param array $fields
	 * @return int
	 */
	function insert($userId, $fieldsData) {
		$userId = intval($userId);
		if ($userId <= 0) return null;
		if(!is_array($fieldsData)) return null;
		$fieldsData[$this->_primaryKey] = $userId;
		return $this->_insert($fieldsData);
	}
	
	function update($userId, $fieldsData) {
		$userId = intval($userId);
		if ($userId <= 0) return null;
		if(!is_array($fieldsData)) return null;
		unset($fieldsData[$this->_primaryKey]);
		return $this->_update($fieldsData, $userId);
	}
}